/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URL;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.NewLauncherSettings;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.GuiModuleConfig;
import pro.gravit.launcher.client.RuntimeSecurityService;
import pro.gravit.launcher.client.StdJavaRuntimeProvider;
import pro.gravit.launcher.client.UserSettings;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.client.events.ClientGuiPhase;
import pro.gravit.launcher.client.gui.FXMLProvider;
import pro.gravit.launcher.client.gui.GuiEventHandler;
import pro.gravit.launcher.client.gui.GuiObjectsContainer;
import pro.gravit.launcher.client.gui.RuntimeSettings;
import pro.gravit.launcher.client.gui.RuntimeStateMachine;
import pro.gravit.launcher.client.gui.StdSettingsManager;
import pro.gravit.launcher.client.gui.commands.DialogCommand;
import pro.gravit.launcher.client.gui.commands.NotifyCommand;
import pro.gravit.launcher.client.gui.commands.VersionCommand;
import pro.gravit.launcher.client.gui.raw.AbstractOverlay;
import pro.gravit.launcher.client.gui.raw.AbstractScene;
import pro.gravit.launcher.client.gui.raw.MessageManager;
import pro.gravit.launcher.client.gui.stage.PrimaryStage;
import pro.gravit.launcher.gui.RuntimeProvider;
import pro.gravit.launcher.managers.ConsoleManager;
import pro.gravit.launcher.managers.SettingsManager;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.websockets.ClientWebSocketService;
import pro.gravit.launcher.request.websockets.StdWebSocketService;
import pro.gravit.utils.command.BaseCommandCategory;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.CommandCategory;
import pro.gravit.utils.command.CommandHandler;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class JavaFXApplication
extends Application {
    private static final AtomicReference<JavaFXApplication> INSTANCE = new AtomicReference();
    public final LauncherConfig config = Launcher.getConfig();
    public final ExecutorService workers = Executors.newCachedThreadPool();
    public RuntimeSettings runtimeSettings;
    public StdWebSocketService service;
    public GuiObjectsContainer gui;
    public RuntimeStateMachine runtimeStateMachine;
    public GuiModuleConfig guiModuleConfig;
    public MessageManager messageManager;
    public RuntimeSecurityService securityService;
    private ResourceBundle resources;
    private SettingsManager settingsManager;
    private FXMLProvider fxmlProvider;
    private PrimaryStage mainStage;

    public JavaFXApplication() {
        INSTANCE.set(this);
    }

    public static JavaFXApplication getInstance() {
        return INSTANCE.get();
    }

    public AbstractScene getCurrentScene() {
        return this.mainStage.getScene();
    }

    public PrimaryStage getMainStage() {
        return this.mainStage;
    }

    public void init() throws Exception {
        this.guiModuleConfig = new GuiModuleConfig();
        this.settingsManager = new StdSettingsManager();
        UserSettings.providers.register("stdruntime", RuntimeSettings.class);
        this.settingsManager.loadConfig();
        NewLauncherSettings settings = this.settingsManager.getConfig();
        if (settings.userSettings.get("stdruntime") == null) {
            settings.userSettings.put("stdruntime", RuntimeSettings.getDefault());
        }
        try {
            this.settingsManager.loadHDirStore();
        }
        catch (Exception e) {
            LogHelper.error((Throwable)e);
        }
        this.runtimeSettings = (RuntimeSettings)((Object)settings.userSettings.get("stdruntime"));
        this.runtimeSettings.apply();
        DirBridge.dirUpdates = this.runtimeSettings.updatesDir == null ? DirBridge.defaultUpdatesDir : this.runtimeSettings.updatesDir;
        this.service = Request.service;
        this.service.registerEventHandler((ClientWebSocketService.EventHandler)new GuiEventHandler(this));
        this.runtimeStateMachine = new RuntimeStateMachine();
        this.messageManager = new MessageManager(this);
        this.securityService = new RuntimeSecurityService(this);
        this.registerCommands();
    }

    public void start(Stage stage) throws Exception {
        if (this.runtimeSettings.locale == null) {
            this.runtimeSettings.locale = RuntimeSettings.DEFAULT_LOCALE;
        }
        try (InputStream input = this.getResource(String.format("runtime_%s.properties", this.runtimeSettings.locale.name));){
            this.resources = new PropertyResourceBundle(input);
        }
        this.fxmlProvider = new FXMLProvider(this::newFXMLLoader, this.workers);
        this.mainStage = new PrimaryStage(stage, String.format("%s Launcher", this.config.projectName));
        this.gui = new GuiObjectsContainer(this);
        this.gui.init();
        this.mainStage.setScene(this.gui.loginScene);
        LauncherEngine.modulesManager.invokeEvent((LauncherModule.Event)new ClientGuiPhase((RuntimeProvider)StdJavaRuntimeProvider.getInstance()));
        AuthRequest.registerProviders();
    }

    private void registerCommands() {
        BaseCommandCategory category = new BaseCommandCategory();
        category.registerCommand("notify", (Command)new NotifyCommand(this.messageManager));
        category.registerCommand("dialog", (Command)new DialogCommand(this.messageManager));
        category.registerCommand("version", (Command)new VersionCommand());
        ConsoleManager.handler.registerCategory(new CommandHandler.Category((CommandCategory)category, "runtime"));
    }

    public void stop() {
        LogHelper.debug((String)"JavaFX method stop invoked");
        LauncherEngine.modulesManager.invokeEvent((LauncherModule.Event)new ClientExitPhase(0));
    }

    private InputStream getResource(String name) throws IOException {
        return IOHelper.newInput((URL)Launcher.getResourceURL((String)name));
    }

    public URL tryResource(String name) {
        try {
            return Launcher.getResourceURL((String)name);
        }
        catch (IOException e) {
            return null;
        }
    }

    private FXMLLoader newFXMLLoader(String name) {
        FXMLLoader loader;
        try {
            loader = new FXMLLoader(IOHelper.getResourceURL((String)String.format("runtime/%s", name)));
            if (this.resources != null) {
                loader.setResources(this.resources);
            }
        }
        catch (Exception e) {
            LogHelper.error((Throwable)e);
            return null;
        }
        loader.setCharset(IOHelper.UNICODE_CHARSET);
        return loader;
    }

    private <T> Future<T> getFxmlAsync(String name) throws IOException {
        InputStream input = this.getResource(name);
        return this.fxmlProvider.queue(name, input);
    }

    public <T> T getFxml(String name) throws IOException, InterruptedException {
        return this.fxmlProvider.getFxml(name);
    }

    public <T> Future<T> getNonCachedFxmlAsync(String name) throws IOException {
        InputStream input = this.getResource(name);
        return this.fxmlProvider.queueNoCache(name, input);
    }

    public <T> Future<T> getNonCachedFxmlAsync(String name, InputStream input) throws IOException {
        return this.fxmlProvider.queueNoCache(name, input);
    }

    public void setMainScene(AbstractScene scene) throws Exception {
        this.mainStage.setScene(scene);
    }

    public Stage newStage() {
        return this.newStage(StageStyle.TRANSPARENT);
    }

    public Stage newStage(StageStyle style) {
        Stage ret = new Stage();
        ret.initStyle(style);
        ret.setResizable(false);
        return ret;
    }

    public final String getTranslation(String name) {
        return this.getTranslation(name, String.format("'%s'", name));
    }

    public final String getTranslation(String key, String defaultValue) {
        try {
            return this.resources.getString(key);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public <T extends AbstractScene> T registerScene(Class<T> clazz) {
        try {
            AbstractScene instance = (AbstractScene)MethodHandles.publicLookup().findConstructor(clazz, MethodType.methodType(Void.TYPE, JavaFXApplication.class)).invokeWithArguments(new Object[]{this});
            this.getFxmlAsync(instance.fxmlPath);
            return (T)instance;
        }
        catch (Throwable e) {
            LogHelper.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean openURL(String url) {
        try {
            this.getHostServices().showDocument(url);
            return true;
        }
        catch (Throwable e) {
            LogHelper.error((Throwable)e);
            return false;
        }
    }

    public <T extends AbstractOverlay> T registerOverlay(Class<T> clazz) {
        try {
            AbstractOverlay instance = (AbstractOverlay)MethodHandles.publicLookup().findConstructor(clazz, MethodType.methodType(Void.TYPE, JavaFXApplication.class)).invokeWithArguments(new Object[]{this});
            this.getFxmlAsync(instance.fxmlPath);
            return (T)instance;
        }
        catch (Throwable e) {
            LogHelper.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void saveSettings() throws IOException {
        this.settingsManager.saveConfig();
        this.settingsManager.saveHDirStore();
        if (this.gui != null && this.gui.optionsOverlay != null && this.runtimeStateMachine != null && this.runtimeStateMachine.getProfiles() != null) {
            try {
                this.gui.optionsOverlay.saveAll();
            }
            catch (Throwable ex) {
                LogHelper.error((Throwable)ex);
            }
        }
    }
}

