/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui;

import java.util.List;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.profiles.optional.OptionalFile;
import pro.gravit.launcher.profiles.optional.OptionalTrigger;
import pro.gravit.launcher.request.Request;

public class RuntimeStateMachine {
    private AuthRequestEvent rawAuthResult;
    private List<ClientProfile> profiles;
    private ClientProfile profile;

    public void setAuthResult(AuthRequestEvent rawAuthResult) {
        this.rawAuthResult = rawAuthResult;
        if (rawAuthResult.session != 0L) {
            Request.setSession((long)rawAuthResult.session);
        }
    }

    public void setProfilesResult(ProfilesRequestEvent rawProfilesResult) {
        this.profiles = rawProfilesResult.profiles;
        this.profiles.sort(ClientProfile::compareTo);
        for (ClientProfile profile : this.profiles) {
            for (OptionalFile optionalFile : profile.getOptional()) {
                if (optionalFile.triggers == null) continue;
                boolean anyTriggered = false;
                boolean anyNeed = false;
                boolean allNeedTriggered = false;
                for (OptionalTrigger trigger : optionalFile.triggers) {
                    boolean isTriggered = trigger.isTriggered();
                    if (isTriggered) {
                        anyTriggered = true;
                    }
                    if (!trigger.need) continue;
                    if (!anyNeed) {
                        anyNeed = true;
                        allNeedTriggered = isTriggered;
                        continue;
                    }
                    if (!allNeedTriggered) continue;
                    allNeedTriggered = isTriggered;
                }
                if (!anyNeed) {
                    if (!anyTriggered) continue;
                    profile.markOptional(optionalFile);
                    continue;
                }
                if (allNeedTriggered) {
                    profile.markOptional(optionalFile);
                    continue;
                }
                optionalFile.visible = false;
                profile.unmarkOptional(optionalFile);
            }
        }
    }

    public String getUsername() {
        if (this.rawAuthResult == null || this.rawAuthResult.playerProfile == null) {
            return "Player";
        }
        return this.rawAuthResult.playerProfile.username;
    }

    public List<ClientProfile> getProfiles() {
        return this.profiles;
    }

    public ClientProfile getProfile() {
        return this.profile;
    }

    public void setProfile(ClientProfile profile) {
        this.profile = profile;
    }

    public PlayerProfile getPlayerProfile() {
        if (this.rawAuthResult == null) {
            return null;
        }
        return this.rawAuthResult.playerProfile;
    }

    public String getAccessToken() {
        if (this.rawAuthResult == null) {
            return null;
        }
        return this.rawAuthResult.accessToken;
    }

    public void exit() {
        this.rawAuthResult = null;
        this.profile = null;
    }
}

