/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.overlay;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.raw.AbstractOverlay;
import pro.gravit.launcher.client.gui.raw.ContextHelper;
import pro.gravit.launcher.client.gui.scene.ConsoleScene;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class DebugOverlay
extends AbstractOverlay {
    private static final long MAX_LENGTH = 163840L;
    private static final int REMOVE_LENGTH = 1024;
    public Process currentProcess;
    public Thread writeParametersThread;
    private Thread readThread;
    private TextArea output;

    public DebugOverlay(JavaFXApplication application) {
        super("overlay/debug/debug.fxml", application);
    }

    @Override
    protected void doInit() {
        Pane layout = this.pane;
        this.output = (TextArea)LookupHelper.lookup((Node)layout, "#output");
        ((ButtonBase)LookupHelper.lookup((Node)layout, "#kill")).setOnAction(e -> {
            if (this.currentProcess != null && this.currentProcess.isAlive()) {
                this.currentProcess.destroyForcibly();
            }
        });
        ((Label)LookupHelper.lookup((Node)layout, "#version")).setText(ConsoleScene.getMiniLauncherInfo());
        ((ButtonBase)LookupHelper.lookup((Node)layout, "#copy")).setOnAction(e -> {
            ClipboardContent clipboardContent = new ClipboardContent();
            clipboardContent.putString(this.output.getText());
            Clipboard clipboard = Clipboard.getSystemClipboard();
            clipboard.setContent((Map)clipboardContent);
        });
        ((ButtonBase)LookupHelper.lookup((Node)layout, "#hastebin")).setOnAction(e -> {
            String haste = null;
            try {
                haste = this.hastebin(this.output.getText());
            }
            catch (IOException ex) {
                this.application.messageManager.createNotification(this.application.getTranslation("runtime.overlay.debug.hastebin.fail.header"), this.application.getTranslation("runtime.overlay.debug.hastebin.fail.description"));
                LogHelper.error((Throwable)ex);
            }
            if (haste == null) {
                return;
            }
            ClipboardContent clipboardContent = new ClipboardContent();
            clipboardContent.putString(haste);
            Clipboard clipboard = Clipboard.getSystemClipboard();
            clipboard.setContent((Map)clipboardContent);
            this.application.openURL(haste);
        });
        ((ButtonBase)LookupHelper.lookup((Node)layout, "#close")).setOnAction(e -> Platform.exit());
        ((ButtonBase)LookupHelper.lookup((Node)layout, "#back")).setOnAction(e -> {
            if (this.writeParametersThread != null && this.writeParametersThread.isAlive()) {
                return;
            }
            if (this.currentProcess != null && this.currentProcess.isAlive()) {
                Process process = this.currentProcess;
                this.currentProcess = null;
                this.readThread.interrupt();
                this.writeParametersThread = null;
                this.readThread = null;
                try {
                    process.getErrorStream().close();
                    process.getInputStream().close();
                    process.getOutputStream().close();
                }
                catch (IOException ex2) {
                    this.errorHandle(ex2);
                }
            }
            try {
                if (this.currentStage != null) {
                    this.currentStage.getScene().hideOverlay(0.0, (EventHandler<ActionEvent>)((EventHandler)ex -> {}));
                    this.application.gui.updateOverlay.reset();
                }
            }
            catch (Exception ex3) {
                this.errorHandle(ex3);
            }
        });
        ((ButtonBase)LookupHelper.lookup((Node)layout, "#hide")).setOnAction(e -> {
            if (this.currentStage != null) {
                this.currentStage.hide();
            }
        });
    }

    @Override
    public void reset() {
        this.output.clear();
    }

    public void onProcess(Process process) {
        if (this.readThread != null && this.readThread.isAlive()) {
            this.readThread.interrupt();
        }
        if (this.currentProcess != null && this.currentProcess.isAlive()) {
            this.currentProcess.destroyForcibly();
        }
        this.readThread = CommonHelper.newThread((String)"Client Process Console Reader", (boolean)true, () -> {
            InputStream stream = process.getInputStream();
            byte[] buf = IOHelper.newBuffer();
            try {
                int length = stream.read(buf);
                while (length >= 0) {
                    this.append(new String(buf, 0, length));
                    length = stream.read(buf);
                }
                if (this.currentProcess.isAlive()) {
                    this.currentProcess.waitFor();
                }
                this.onProcessExit(this.currentProcess.exitValue());
            }
            catch (IOException e) {
                this.errorHandle(e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        this.readThread.start();
        this.currentProcess = process;
    }

    public void append(String text) {
        ContextHelper.runInFxThreadStatic(() -> {
            if ((long)this.output.lengthProperty().get() > 163840L) {
                this.output.deleteText(0, 1024);
            }
            this.output.appendText(text);
        });
    }

    @Override
    public void errorHandle(Throwable e) {
        if (!(e instanceof EOFException)) {
            LogHelper.error((Throwable)e);
            if (LogHelper.isDebugEnabled()) {
                this.append(e.toString());
            }
        }
        if (this.currentProcess != null && !this.currentProcess.isAlive()) {
            this.onProcessExit(this.currentProcess.exitValue());
        }
    }

    private void onProcessExit(int code) {
        this.append(String.format("Process exit code %d", code));
        if (this.writeParametersThread != null) {
            this.writeParametersThread.interrupt();
        }
    }

    public String hastebin(String log) throws IOException {
        if (this.application.guiModuleConfig.hastebinServer == null) {
            throw new NullPointerException("Regenerate the config \"JavaRuntime.json\"");
        }
        URL url = new URL(this.application.guiModuleConfig.hastebinServer + "/documents");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
        connection.setRequestProperty("Accept", "application/json");
        connection.setConnectTimeout(10000);
        try (OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);){
            writer.write(log);
            writer.flush();
        }
        int statusCode = connection.getResponseCode();
        InputStreamReader reader = 200 <= statusCode && statusCode < 300 ? new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8) : new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8);
        try {
            HasteResponse obj = (HasteResponse)Launcher.gsonManager.gson.fromJson((Reader)reader, HasteResponse.class);
            this.application.messageManager.createNotification(this.application.getTranslation("runtime.overlay.debug.hastebin.success.header"), this.application.getTranslation("runtime.overlay.debug.hastebin.success.description"));
            return this.application.guiModuleConfig.hastebinServer + "/" + obj.key;
        }
        catch (Exception e) {
            if (200 > statusCode || statusCode > 300) {
                this.application.messageManager.createNotification(this.application.getTranslation("runtime.overlay.debug.hastebin.fail.header"), this.application.getTranslation("runtime.overlay.debug.hastebin.fail.description"));
                LogHelper.error((String)"JsonRequest failed. Server response code %d", (Object[])new Object[]{statusCode});
                throw new IOException(e);
            }
            return null;
        }
    }

    public static class HasteResponse {
        @LauncherNetworkAPI
        public String key;
    }
}

