/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.overlay;

import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.raw.AbstractOverlay;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.optional.OptionalFile;
import pro.gravit.launcher.profiles.optional.OptionalType;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class OptionsOverlay
extends AbstractOverlay {
    private Pane componentList;

    public OptionsOverlay(JavaFXApplication application) {
        super("overlay/options/options.fxml", application);
    }

    @Override
    protected void doInit() {
        Pane layout = this.pane;
        ((ButtonBase)LookupHelper.lookup((Node)layout, "#apply")).setOnAction(e -> {
            try {
                if (this.currentStage != null) {
                    this.currentStage.getScene().hideOverlay(0.0, null);
                }
            }
            catch (Exception ex) {
                this.errorHandle(ex);
            }
        });
        this.componentList = (Pane)((ScrollPane)LookupHelper.lookup((Node)layout, "#serverImage", "#optionslist")).getContent();
        ((ButtonBase)LookupHelper.lookup((Node)layout, "#close")).setOnAction(e -> Platform.exit());
        ((ButtonBase)LookupHelper.lookup((Node)layout, "#hide")).setOnAction(e -> {
            if (this.currentStage != null) {
                this.currentStage.hide();
            }
        });
    }

    @Override
    public void reset() {
        this.componentList.getChildren().clear();
    }

    @Override
    public void errorHandle(Throwable e) {
        LogHelper.error((Throwable)e);
    }

    public void addProfileOptionals(ClientProfile profile) {
        for (OptionalFile optionalFile : profile.getOptional()) {
            optionalFile.clearAllWatchers();
            if (!optionalFile.visible) continue;
            Consumer<Boolean> setCheckBox = this.add(optionalFile.name, optionalFile.info, optionalFile.mark, optionalFile.subTreeLevel, isSelected -> {
                if (isSelected.booleanValue()) {
                    profile.markOptional(optionalFile);
                } else {
                    profile.unmarkOptional(optionalFile);
                }
            });
            optionalFile.registerWatcher((o, isSelected) -> setCheckBox.accept((Boolean)isSelected));
        }
    }

    public Consumer<Boolean> add(String name, String description, boolean value, int padding, Consumer<Boolean> onChanged) {
        FlowPane container = new FlowPane();
        CheckBox checkBox = new CheckBox();
        checkBox.setSelected(value);
        checkBox.setText(name);
        Text desc = new Text();
        desc.setText(description);
        container.getChildren().add((Object)checkBox);
        container.getChildren().add((Object)desc);
        checkBox.setOnAction(e -> onChanged.accept(checkBox.isSelected()));
        this.componentList.getChildren().add((Object)container);
        container.getStyleClass().add((Object)"optContainer");
        checkBox.getStyleClass().add((Object)"optCheckbox");
        desc.getStyleClass().add((Object)"optDescription");
        FlowPane.setMargin((Node)desc, (Insets)new Insets(0.0, 0.0, 0.0, 30.0));
        VBox.setMargin((Node)container, (Insets)new Insets(0.0, 0.0, 0.0, (double)(50 * padding)));
        return arg_0 -> ((CheckBox)checkBox).setSelected(arg_0);
    }

    public void saveAll() throws IOException {
        List<ClientProfile> profiles = this.application.runtimeStateMachine.getProfiles();
        if (profiles == null) {
            return;
        }
        Path optionsFile = DirBridge.dir.resolve("options.json");
        ArrayList<OptionalListEntry> list = new ArrayList<OptionalListEntry>(5);
        for (ClientProfile clientProfile : profiles) {
            OptionalListEntry entry = new OptionalListEntry();
            entry.name = clientProfile.getTitle();
            entry.profileUUID = clientProfile.getUUID();
            for (OptionalFile optionalFile : clientProfile.getOptional()) {
                if (!optionalFile.visible) continue;
                entry.enabled.add(new OptionalListEntryPair(optionalFile));
            }
            list.add(entry);
        }
        try (BufferedWriter writer = IOHelper.newWriter((Path)optionsFile);){
            Launcher.gsonManager.gson.toJson(list, (Appendable)writer);
        }
    }

    public void loadAll() throws IOException {
        List<ClientProfile> profiles = this.application.runtimeStateMachine.getProfiles();
        if (profiles == null) {
            return;
        }
        Path optionsFile = DirBridge.dir.resolve("options.json");
        if (!Files.exists(optionsFile, new LinkOption[0])) {
            return;
        }
        Type collectionType = new TypeToken<List<OptionalListEntry>>(){}.getType();
        try (BufferedReader reader = IOHelper.newReader((Path)optionsFile);){
            List list = (List)Launcher.gsonManager.gson.fromJson((Reader)reader, collectionType);
            for (OptionalListEntry entry : list) {
                ClientProfile selectedProfile = null;
                for (ClientProfile clientProfile : profiles) {
                    if (!(entry.profileUUID != null ? entry.profileUUID.equals(clientProfile.getUUID()) : clientProfile.getTitle().equals(entry.name))) continue;
                    selectedProfile = clientProfile;
                }
                if (selectedProfile == null) {
                    LogHelper.warning((String)"Optional: profile %s(%s) not found", (Object[])new Object[]{entry.name, entry.profileUUID});
                    continue;
                }
                for (OptionalListEntryPair entryPair : entry.enabled) {
                    try {
                        OptionalFile file = selectedProfile.getOptionalFile(entryPair.name, entryPair.type);
                        if (!file.visible) continue;
                        if (entryPair.mark) {
                            selectedProfile.markOptional(file);
                            continue;
                        }
                        selectedProfile.unmarkOptional(file);
                    }
                    catch (Exception exc) {
                        LogHelper.warning((String)"Optional: in profile %s markOptional mod %s failed", (Object[])new Object[]{selectedProfile.getTitle(), entryPair.name});
                    }
                }
            }
        }
    }

    public static class OptionalListEntry {
        public List<OptionalListEntryPair> enabled = new LinkedList<OptionalListEntryPair>();
        public String name;
        public UUID profileUUID;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OptionalListEntry that = (OptionalListEntry)o;
            return Objects.equals(this.profileUUID, that.profileUUID) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.profileUUID);
        }
    }

    public static class OptionalListEntryPair {
        public OptionalType type;
        public String name;
        public boolean mark;

        public OptionalListEntryPair(OptionalFile optionalFile) {
            this.type = optionalFile.type;
            this.name = optionalFile.name;
            this.mark = optionalFile.mark;
        }
    }
}

