/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.overlay;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Slider;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import oshi.SystemInfo;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.RuntimeSettings;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.raw.AbstractOverlay;
import pro.gravit.launcher.client.gui.stage.ConsoleStage;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class SettingsOverlay
extends AbstractOverlay {
    private Pane componentList;
    private Label ramLabel;

    public SettingsOverlay(JavaFXApplication application) {
        super("overlay/settings/settings.fxml", application);
    }

    @Override
    protected void doInit() {
        Pane layout = this.pane;
        this.componentList = (Pane)((ScrollPane)LookupHelper.lookup((Node)layout, "#settingslist")).getContent();
        ((ButtonBase)LookupHelper.lookup((Node)layout, "#apply")).setOnAction(e -> {
            try {
                if (this.currentStage != null) {
                    this.currentStage.getScene().hideOverlay(0.0, null);
                }
            }
            catch (Exception ex) {
                this.errorHandle(ex);
            }
        });
        ((ButtonBase)LookupHelper.lookup((Node)layout, "#console")).setOnAction(e -> {
            try {
                if (this.application.gui.consoleStage == null) {
                    this.application.gui.consoleStage = new ConsoleStage(this.application);
                }
                if (this.application.gui.consoleStage.isNullScene()) {
                    this.application.gui.consoleStage.setScene(this.application.gui.consoleScene);
                }
                this.application.gui.consoleStage.show();
            }
            catch (Exception ex) {
                this.errorHandle(ex);
            }
        });
        ((ButtonBase)LookupHelper.lookup((Node)layout, "#close")).setOnAction(e -> Platform.exit());
        ((ButtonBase)LookupHelper.lookup((Node)layout, "#hide")).setOnAction(e -> {
            if (this.currentStage != null) {
                this.currentStage.hide();
            }
        });
        Button langButton = (Button)LookupHelper.lookup((Node)layout, "#lang");
        ContextMenu langChoice = langButton.getContextMenu();
        RuntimeSettings.LAUNCHER_LOCALE[] locales = RuntimeSettings.LAUNCHER_LOCALE.values();
        Object[] items = new MenuItem[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            items[i] = new MenuItem(locales[i].displayName);
            int finalI = i;
            items[i].setOnAction(e -> {
                this.application.runtimeSettings.locale = locales[finalI];
                this.application.messageManager.createNotification(this.application.getTranslation("runtime.overlay.settings.langChanged.head"), this.application.getTranslation("runtime.overlay.settings.langChanged.description"));
            });
        }
        langChoice.getItems().addAll(items);
        langButton.setOnMousePressed(e -> {
            if (!e.isPrimaryButtonDown()) {
                return;
            }
            langChoice.show((Node)langButton, e.getScreenX(), e.getScreenY());
        });
        Slider ramSlider = (Slider)LookupHelper.lookup((Node)layout, "#ramSlider");
        this.ramLabel = (Label)LookupHelper.lookup((Node)layout, "#serverImage", "#ramLabel");
        this.updateRamLabel();
        try {
            SystemInfo systemInfo = new SystemInfo();
            ramSlider.setMax((double)(systemInfo.getHardware().getMemory().getTotal() >> 20));
        }
        catch (Throwable e2) {
            ramSlider.setMax(2048.0);
        }
        ramSlider.setSnapToTicks(true);
        ramSlider.setShowTickMarks(true);
        ramSlider.setShowTickLabels(true);
        ramSlider.setMinorTickCount(3);
        ramSlider.setMajorTickUnit(1024.0);
        ramSlider.setBlockIncrement(1024.0);
        ramSlider.setValue((double)this.application.runtimeSettings.ram);
        ramSlider.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.application.runtimeSettings.ram = newValue.intValue();
            this.updateRamLabel();
        });
        Hyperlink updateDirLink = (Hyperlink)LookupHelper.lookup((Node)layout, "#dirLabel", "#patch");
        updateDirLink.setText(DirBridge.dirUpdates.toAbsolutePath().toString());
        updateDirLink.setOnAction(e -> this.application.openURL(DirBridge.dirUpdates.toAbsolutePath().toString()));
        ((ButtonBase)LookupHelper.lookup((Node)layout, "#changeDir")).setOnAction(e -> {
            DirectoryChooser directoryChooser = new DirectoryChooser();
            directoryChooser.setTitle("\u0421\u043c\u0435\u043d\u0438\u0442\u044c \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044e \u0437\u0430\u0433\u0440\u0443\u0437\u043e\u043a");
            directoryChooser.setInitialDirectory(DirBridge.dir.toFile());
            File choose = directoryChooser.showDialog((Window)this.application.getMainStage().stage);
            if (choose == null) {
                return;
            }
            Path newDir = choose.toPath().toAbsolutePath();
            try {
                DirBridge.move((Path)newDir);
            }
            catch (IOException ex) {
                LogHelper.error((Throwable)ex);
            }
            this.application.runtimeSettings.updatesDirPath = newDir.toString();
            this.application.runtimeSettings.updatesDir = newDir;
            updateDirLink.setText(this.application.runtimeSettings.updatesDirPath);
        });
        ((ButtonBase)LookupHelper.lookup((Node)layout, "#deleteDir")).setOnAction(e -> this.application.messageManager.showApplyDialog(this.application.getTranslation("runtime.overlay.settings.deletedir.header"), this.application.getTranslation("runtime.overlay.settings.deletedir.description"), () -> {
            LogHelper.debug((String)"Delete dir: %s", (Object[])new Object[]{DirBridge.dirUpdates});
            try {
                IOHelper.deleteDir((Path)DirBridge.dirUpdates, (boolean)false);
            }
            catch (IOException ex) {
                LogHelper.error((Throwable)ex);
                this.application.messageManager.createNotification(this.application.getTranslation("runtime.overlay.settings.deletedir.fail.header"), this.application.getTranslation("runtime.overlay.settings.deletedir.fail.description"));
            }
        }, () -> {}, true));
        this.add("Debug", this.application.runtimeSettings.debug, value -> {
            this.application.runtimeSettings.debug = value;
        });
        this.add("AutoEnter", this.application.runtimeSettings.autoEnter, value -> {
            this.application.runtimeSettings.autoEnter = value;
        });
        this.add("Fullscreen", this.application.runtimeSettings.fullScreen, value -> {
            this.application.runtimeSettings.fullScreen = value;
        });
        if (this.application.securityService.isMayBeDownloadJava() && this.application.guiModuleConfig.enableDownloadJava && this.application.guiModuleConfig.userDisableDownloadJava) {
            this.add("DisableJavaDownload", this.application.runtimeSettings.disableJavaDownload, value -> {
                this.application.runtimeSettings.disableJavaDownload = value;
            });
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void errorHandle(Throwable e) {
        LogHelper.error((Throwable)e);
    }

    public void add(String languageName, boolean value, Consumer<Boolean> onChanged) {
        String nameKey = String.format("runtime.overlay.settings.properties.%s.name", languageName.toLowerCase());
        String descriptionKey = String.format("runtime.overlay.settings.properties.%s.description", languageName.toLowerCase());
        this.add(this.application.getTranslation(nameKey, languageName), this.application.getTranslation(descriptionKey, languageName), value, onChanged);
    }

    public void add(String name, String description, boolean value, Consumer<Boolean> onChanged) {
        FlowPane container = new FlowPane();
        CheckBox checkBox = new CheckBox();
        checkBox.setSelected(value);
        checkBox.setText(name);
        Text desc = new Text();
        desc.setText(description);
        container.getChildren().add((Object)checkBox);
        container.getChildren().add((Object)desc);
        checkBox.setOnAction(e -> onChanged.accept(checkBox.isSelected()));
        this.componentList.getChildren().add((Object)container);
        container.getStyleClass().add((Object)"optContainer");
        checkBox.getStyleClass().add((Object)"optCheckbox");
        desc.getStyleClass().add((Object)"optDescription");
        FlowPane.setMargin((Node)desc, (Insets)new Insets(0.0, 0.0, 0.0, 30.0));
    }

    public void updateRamLabel() {
        this.ramLabel.setText(this.application.runtimeSettings.ram == 0 ? "Auto" : Integer.toString(this.application.runtimeSettings.ram).concat(" MiB"));
    }
}

