/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.overlay;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextArea;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import pro.gravit.launcher.AsyncDownloader;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.raw.AbstractOverlay;
import pro.gravit.launcher.client.gui.raw.ContextHelper;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.hasher.HashedEntry;
import pro.gravit.launcher.hasher.HashedFile;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.update.UpdateRequest;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class UpdateOverlay
extends AbstractOverlay {
    private final AtomicLong totalDownloaded = new AtomicLong(0L);
    private final AtomicLong lastUpdateTime = new AtomicLong(0L);
    private final AtomicLong lastDownloaded = new AtomicLong(0L);
    private ProgressBar progressBar;
    private Circle[] phases;
    private Label speed;
    private Label volume;
    private TextArea logOutput;
    private Text currentStatus;
    private long totalSize;
    private int currentPhase = 0;
    private double phaseOffset;
    private double progressRatio = 1.0;
    private double phaseRatio;

    public UpdateOverlay(JavaFXApplication application) {
        super("overlay/update/update.fxml", application);
    }

    @Override
    protected void doInit() {
        this.progressBar = (ProgressBar)LookupHelper.lookup((Node)this.pane, "#progress");
        this.phases = new Circle[5];
        for (int i = 1; i <= 5; ++i) {
            Circle circle;
            this.phases[i - 1] = circle = (Circle)LookupHelper.lookup((Node)this.pane, String.format("#phase%d", i));
            this.phaseOffset = circle.getRadius() * 2.0 / this.progressBar.getPrefWidth();
            this.progressRatio -= this.phaseOffset;
        }
        this.phaseRatio = this.progressRatio / 4.0;
        this.speed = (Label)LookupHelper.lookup((Node)this.pane, "#speed");
        this.volume = (Label)LookupHelper.lookup((Node)this.pane, "#volume");
        this.logOutput = (TextArea)LookupHelper.lookup((Node)this.pane, "#outputUpdate");
        this.currentStatus = (Text)LookupHelper.lookup((Node)this.pane, "#headingUpdate");
        this.logOutput.setText("");
        ((ButtonBase)LookupHelper.lookup((Node)this.pane, "#close")).setOnAction(e -> Platform.exit());
        ((ButtonBase)LookupHelper.lookup((Node)this.pane, "#hide")).setOnAction(e -> {
            if (this.currentStage != null) {
                this.currentStage.hide();
            }
        });
    }

    private void deleteExtraDir(Path subDir, HashedDir subHDir, boolean deleteDir) throws IOException {
        block4: for (Map.Entry mapEntry : subHDir.map().entrySet()) {
            String name = (String)mapEntry.getKey();
            Path path = subDir.resolve(name);
            HashedEntry entry = (HashedEntry)mapEntry.getValue();
            HashedEntry.Type entryType = entry.getType();
            switch (entryType) {
                case FILE: {
                    Files.delete(path);
                    continue block4;
                }
                case DIR: {
                    this.deleteExtraDir(path, (HashedDir)entry, deleteDir || entry.flag);
                    continue block4;
                }
            }
            throw new AssertionError((Object)("Unsupported hashed entry type: " + entryType.name()));
        }
        if (deleteDir) {
            Files.delete(subDir);
        }
    }

    public void sendUpdateRequest(String dirName, Path dir, FileNameMatcher matcher, boolean digest, ClientProfile profile, boolean optionalsEnabled, Consumer<HashedDir> onSuccess) {
        UpdateRequest request = new UpdateRequest(dirName);
        try {
            ((CompletableFuture)this.application.service.request((Request)request).thenAccept(updateRequestEvent -> {
                LogHelper.dev((String)"Start updating %s", (Object[])new Object[]{dirName});
                this.totalDownloaded.set(0L);
                this.lastUpdateTime.set(System.currentTimeMillis());
                this.lastDownloaded.set(0L);
                this.totalSize = 0L;
                if (optionalsEnabled) {
                    profile.pushOptionalFile(updateRequestEvent.hdir, digest);
                }
                try {
                    ContextHelper.runInFxThreadStatic(() -> this.addLog(String.format("Hashing %s", dirName)));
                    if (!IOHelper.exists((Path)dir)) {
                        Files.createDirectories(dir, new FileAttribute[0]);
                    }
                    HashedDir hashedDir = new HashedDir(dir, matcher, false, digest);
                    HashedDir.Diff diff = updateRequestEvent.hdir.diff(hashedDir, matcher);
                    ArrayList adds = new ArrayList();
                    diff.mismatch.walk((CharSequence)"/", (path, name, entry) -> {
                        switch (entry.getType()) {
                            case FILE: {
                                HashedFile file = (HashedFile)entry;
                                this.totalSize += file.size;
                                adds.add(new AsyncDownloader.SizedFile(path, file.size));
                                break;
                            }
                            case DIR: {
                                Files.createDirectories(dir.resolve(path), new FileAttribute[0]);
                            }
                        }
                        return HashedDir.WalkAction.CONTINUE;
                    });
                    LogHelper.info((String)"Diff %d %d", (Object[])new Object[]{diff.mismatch.size(), diff.extra.size()});
                    ContextHelper.runInFxThreadStatic(() -> this.addLog(String.format("Downloading %s...", dirName)));
                    AsyncDownloader asyncDownloader = new AsyncDownloader(d -> {
                        long old = this.totalDownloaded.getAndAdd(d);
                        this.updateProgress(old, old + d);
                    });
                    List tasks = asyncDownloader.sortFiles(adds, 4);
                    CompletableFuture[] futures = asyncDownloader.runDownloadList(tasks, updateRequestEvent.url, dir, (Executor)this.application.workers);
                    ((CompletableFuture)CompletableFuture.allOf(futures).thenAccept(e -> {
                        ContextHelper.runInFxThreadStatic(() -> this.addLog(String.format("Delete Extra files %s", dirName)));
                        try {
                            this.deleteExtraDir(dir, diff.extra, diff.extra.flag);
                            onSuccess.accept(updateRequestEvent.hdir);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    })).exceptionally(e -> {
                        ContextHelper.runInFxThreadStatic(() -> this.errorHandle((Throwable)e));
                        return null;
                    });
                }
                catch (IOException e2) {
                    ContextHelper.runInFxThreadStatic(() -> this.errorHandle(e2));
                }
            })).exceptionally(error -> {
                ContextHelper.runInFxThreadStatic(() -> this.errorHandle(error.getCause()));
                return null;
            });
        }
        catch (IOException e) {
            this.errorHandle(e);
        }
    }

    private void addLog(String string) {
        LogHelper.dev((String)"Update event %s", (Object[])new Object[]{string});
        this.logOutput.appendText(string.concat("\n"));
    }

    public void initNewPhase(String name) {
        this.currentStatus.setText(name);
        this.phases[this.currentPhase].getStyleClass().add((Object)"phaseActive");
        DoubleProperty property = this.progressBar.progressProperty();
        property.set(this.phaseOffset + (this.phaseOffset + this.phaseRatio) * (double)this.currentPhase);
        LogHelper.debug((String)"NewPhase %f", (Object[])new Object[]{this.progressBar.progressProperty().doubleValue()});
        ++this.currentPhase;
    }

    private void updateProgress(long oldValue, long newValue) {
        double add = (double)(newValue - oldValue) / (double)this.totalSize;
        DoubleProperty property = this.progressBar.progressProperty();
        property.set(property.get() + add * this.phaseRatio);
        long lastTime = this.lastUpdateTime.get();
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastTime >= 130L) {
            String format = String.format("%.1f MB / %.1f MB", (double)newValue / 1048576.0, (double)this.totalSize / 1048576.0);
            double bytesSpeed = (double)(newValue - this.lastDownloaded.get()) / (double)(currentTime - lastTime) * 1000.0;
            String speedFormat = String.format("%.2f MiB/s", bytesSpeed * 8.0 / 1000000.0);
            ContextHelper.runInFxThreadStatic(() -> {
                this.volume.setText(format);
                this.speed.setText(speedFormat);
            });
            this.lastUpdateTime.set(currentTime);
            this.lastDownloaded.set(newValue);
        }
    }

    @Override
    public void reset() {
        this.progressBar.progressProperty().setValue((Number)0);
        this.logOutput.clear();
        this.volume.setText("");
        this.speed.setText("");
        for (Circle circle : this.phases) {
            circle.getStyleClass().removeAll((Object[])new String[]{"phaseActive"});
            circle.getStyleClass().removeAll((Object[])new String[]{"phaseError"});
        }
        this.currentPhase = 0;
    }

    @Override
    public void errorHandle(Throwable e) {
        this.addLog(String.format("Exception %s: %s", e.getClass(), e.getMessage() == null ? "" : e.getMessage()));
        this.phases[this.currentPhase].getStyleClass().add((Object)"phaseError");
        LogHelper.error((Throwable)e);
    }
}

