/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.raw;

import java.io.IOException;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.interfaces.AllowDisable;
import pro.gravit.launcher.client.gui.raw.AbstractScene;
import pro.gravit.launcher.client.gui.raw.AbstractStage;

public abstract class AbstractOverlay
implements AllowDisable {
    public final String fxmlPath;
    protected final JavaFXApplication application;
    protected AbstractStage currentStage;
    protected Pane pane;
    boolean isInit;

    protected AbstractOverlay(String fxmlPath, JavaFXApplication application) {
        this.application = application;
        this.fxmlPath = fxmlPath;
    }

    public final void init() throws IOException, InterruptedException {
        this.pane = (Pane)this.application.getFxml(this.fxmlPath);
        this.doInit();
        this.isInit = true;
    }

    protected final void hide(double delay, AbstractScene scene, EventHandler<ActionEvent> onFinished) {
        if (!this.isInit) {
            throw new IllegalStateException("Using method hide before init");
        }
        scene.hideOverlay(delay, (EventHandler<ActionEvent>)((EventHandler)e -> {
            if (onFinished != null) {
                onFinished.handle(e);
            }
        }));
    }

    protected abstract void doInit();

    public abstract void reset();

    public abstract void errorHandle(Throwable var1);

    public Pane getPane() {
        return this.pane;
    }

    @Override
    public void disable() {
    }

    @Override
    public void enable() {
    }
}

