/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.raw;

import java.io.IOException;
import java.util.function.Consumer;
import javafx.animation.FadeTransition;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ButtonBase;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.interfaces.AllowDisable;
import pro.gravit.launcher.client.gui.raw.AbstractOverlay;
import pro.gravit.launcher.client.gui.raw.AbstractStage;
import pro.gravit.launcher.client.gui.raw.ContextHelper;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.WebSocketEvent;

public abstract class AbstractScene
implements AllowDisable {
    public final String fxmlPath;
    protected final JavaFXApplication application;
    protected final LauncherConfig launcherConfig;
    protected final ContextHelper contextHelper;
    protected Scene scene;
    AbstractStage currentStage;
    private Node currentOverlayNode;
    private AbstractOverlay currentOverlay;
    private boolean enabled = true;

    protected AbstractScene(String fxmlPath, JavaFXApplication application) {
        this.fxmlPath = fxmlPath;
        this.application = application;
        this.launcherConfig = Launcher.getConfig();
        this.contextHelper = new ContextHelper(this);
    }

    public static void fade(Node region, double delay, double from, double to, EventHandler<ActionEvent> onFinished) {
        FadeTransition fadeTransition = new FadeTransition(Duration.millis((double)100.0), region);
        if (onFinished != null) {
            fadeTransition.setOnFinished(onFinished);
        }
        fadeTransition.setDelay(Duration.millis((double)delay));
        fadeTransition.setFromValue(from);
        fadeTransition.setToValue(to);
        fadeTransition.play();
    }

    protected AbstractStage getCurrentStage() {
        return this.currentStage;
    }

    public void init() throws Exception {
        if (this.scene == null) {
            this.scene = new Scene((Parent)this.application.getFxml(this.fxmlPath));
            this.scene.setFill((Paint)Color.TRANSPARENT);
        }
        this.doInit();
    }

    protected abstract void doInit() throws Exception;

    public void showOverlay(AbstractOverlay overlay, EventHandler<ActionEvent> onFinished) {
        this.currentOverlay = overlay;
        if (!overlay.isInit) {
            try {
                overlay.init();
            }
            catch (IOException | InterruptedException e) {
                this.contextHelper.errorHandling(e);
                return;
            }
        }
        overlay.currentStage = this.currentStage;
        this.currentStage.enableMouseDrag((Node)overlay.pane);
        this.showOverlay(overlay.getPane(), onFinished);
    }

    private void showOverlay(Pane newOverlay, EventHandler<ActionEvent> onFinished) {
        if (newOverlay == null) {
            throw new NullPointerException();
        }
        if (this.currentOverlayNode != null) {
            this.swapOverlay(newOverlay, onFinished);
            return;
        }
        this.disable();
        this.currentOverlayNode = newOverlay;
        Pane root = (Pane)this.scene.getRoot();
        ((Node)root.getChildren().get(0)).setEffect((Effect)new GaussianBlur(10.0));
        root.getChildren().add((Object)newOverlay);
        newOverlay.setLayoutX((root.getPrefWidth() - newOverlay.getPrefWidth()) / 2.0);
        newOverlay.setLayoutY((root.getPrefHeight() - newOverlay.getPrefHeight()) / 2.0);
        newOverlay.toFront();
        newOverlay.requestFocus();
        AbstractScene.fade((Node)newOverlay, 0.0, 0.0, 1.0, onFinished);
    }

    public void hideOverlay(double delay, EventHandler<ActionEvent> onFinished) {
        if (this.currentOverlayNode == null) {
            return;
        }
        if (this.currentOverlay == null) {
            return;
        }
        this.enable();
        Pane root = (Pane)this.scene.getRoot();
        AbstractScene.fade(this.currentOverlayNode, delay, 1.0, 0.0, (EventHandler<ActionEvent>)((EventHandler)e -> {
            root.getChildren().remove((Object)this.currentOverlayNode);
            root.requestFocus();
            ((Node)root.getChildren().get(0)).setEffect((Effect)new GaussianBlur(0.0));
            this.currentOverlayNode = null;
            if (this.currentOverlay != null) {
                this.currentOverlay.currentStage = null;
            }
            if (this.currentOverlay != null) {
                this.currentOverlay.reset();
            }
            this.currentOverlay = null;
            if (onFinished != null) {
                onFinished.handle(e);
            }
        }));
    }

    private void swapOverlay(Pane newOverlay, EventHandler<ActionEvent> onFinished) {
        if (this.currentOverlayNode == null) {
            throw new IllegalStateException("Try swap null overlay");
        }
        Pane root = (Pane)this.scene.getRoot();
        AbstractScene.fade(this.currentOverlayNode, 0.0, 1.0, 0.0, (EventHandler<ActionEvent>)((EventHandler)e -> {
            if (this.currentOverlayNode != newOverlay) {
                ObservableList child = root.getChildren();
                child.set(child.indexOf((Object)this.currentOverlayNode), (Object)newOverlay);
            }
            newOverlay.setLayoutX((root.getPrefWidth() - newOverlay.getPrefWidth()) / 2.0);
            newOverlay.setLayoutY((root.getPrefHeight() - newOverlay.getPrefHeight()) / 2.0);
            this.currentOverlayNode = newOverlay;
            newOverlay.toFront();
            newOverlay.requestFocus();
            AbstractScene.fade((Node)newOverlay, 0.0, 0.0, 1.0, onFinished);
        }));
    }

    protected final <T extends WebSocketEvent> void processRequest(String message, Request<T> request, Consumer<T> onSuccess, EventHandler<ActionEvent> onError) {
        this.application.gui.processingOverlay.processRequest(this, message, request, onSuccess, onError);
    }

    public AbstractOverlay getCurrentOverlay() {
        return this.currentOverlay;
    }

    @Override
    public void disable() {
        this.enabled = false;
    }

    @Override
    public void enable() {
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void doShow() {
    }

    public abstract void reset();

    public abstract void errorHandle(Throwable var1);

    public Scene getScene() {
        return this.scene;
    }

    protected void sceneBaseInit(Node node) {
        ((ButtonBase)LookupHelper.lookup(node, "#close")).setOnAction(e -> this.currentStage.close());
        ((ButtonBase)LookupHelper.lookup(node, "#hide")).setOnAction(e -> this.currentStage.hide());
        this.currentStage.enableMouseDrag(node);
    }
}

