/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.raw;

import java.util.concurrent.atomic.AtomicReference;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.stage.Stage;
import pro.gravit.launcher.client.gui.raw.AbstractScene;

public abstract class AbstractStage {
    public final Stage stage;
    protected AbstractScene scene;

    protected AbstractStage(Stage stage) {
        this.stage = stage;
    }

    public void hide() {
        this.stage.setIconified(true);
    }

    public void close() {
        this.stage.hide();
    }

    public void enableMouseDrag(Node node) {
        AtomicReference movePoint = new AtomicReference();
        node.setOnMousePressed(event -> movePoint.set(new Point2D(event.getSceneX(), event.getSceneY())));
        node.setOnMouseDragged(event -> {
            if (movePoint.get() == null) {
                return;
            }
            this.stage.setX(event.getScreenX() - ((Point2D)movePoint.get()).getX());
            this.stage.setY(event.getScreenY() - ((Point2D)movePoint.get()).getY());
        });
    }

    public AbstractScene getScene() {
        return this.scene;
    }

    public void setScene(AbstractScene scene) throws Exception {
        if (scene == null) {
            throw new NullPointerException("Try set null scene");
        }
        scene.currentStage = this;
        if (scene.getScene() == null) {
            scene.init();
        }
        scene.doShow();
        this.stage.setScene(scene.getScene());
        this.stage.sizeToScene();
        this.stage.show();
        this.scene = scene;
    }

    public final boolean isNullScene() {
        return this.scene == null;
    }

    public void show() {
        this.stage.show();
    }
}

