/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.raw;

import javafx.application.Platform;
import pro.gravit.launcher.client.gui.raw.AbstractOverlay;
import pro.gravit.launcher.client.gui.raw.AbstractScene;
import pro.gravit.utils.helper.LogHelper;

public class ContextHelper {
    private final AbstractScene scene;

    ContextHelper(AbstractScene scene) {
        this.scene = scene;
    }

    public static void runInFxThreadStatic(GuiExceptionCallback callback) {
        Platform.runLater(() -> {
            try {
                callback.call();
            }
            catch (Throwable ex) {
                LogHelper.error((Throwable)ex);
            }
        });
    }

    public final Runnable runCallback(GuiExceptionCallback callback) {
        return () -> {
            try {
                callback.call();
            }
            catch (Throwable ex) {
                this.errorHandling(ex);
            }
        };
    }

    public final void runInFxThread(GuiExceptionCallback callback) {
        Platform.runLater(() -> {
            try {
                callback.call();
            }
            catch (Throwable ex) {
                this.errorHandling(ex);
            }
        });
    }

    final void errorHandling(Throwable e) {
        AbstractOverlay currentOverlay;
        LogHelper.error((Throwable)e);
        if (this.scene != null && (currentOverlay = this.scene.getCurrentOverlay()) != null) {
            currentOverlay.errorHandle(e);
            this.scene.hideOverlay(2000.0, null);
        }
    }

    public static interface GuiExceptionCallback {
        public void call() throws Throwable;
    }
}

