/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.raw;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.raw.AbstractScene;
import pro.gravit.launcher.client.gui.raw.ContextHelper;
import pro.gravit.utils.helper.LogHelper;

public class MessageManager {
    public final JavaFXApplication application;
    private final AtomicInteger count = new AtomicInteger(0);
    private final AtomicInteger localCount = new AtomicInteger(0);

    public MessageManager(JavaFXApplication application) {
        this.application = application;
    }

    public void createNotification(String head, String message) {
        this.createNotification(head, message, this.application.getCurrentScene() != null);
    }

    public void createNotification(String head, String message, boolean isLauncher) {
        Pane pane;
        if (isLauncher && this.application.getCurrentScene() == null) {
            throw new NullPointerException("Try show launcher notification in application.getCurrentScene() == null");
        }
        try {
            pane = (Pane)this.application.getNonCachedFxmlAsync("components/notification.fxml").get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        Pane finalPane = pane;
        Scene scene = isLauncher ? null : new Scene((Parent)finalPane);
        ContextHelper.runInFxThreadStatic(() -> {
            Runnable onClose;
            ((Text)LookupHelper.lookup((Node)finalPane, "#notificationHeading")).setText(head);
            ((Text)LookupHelper.lookup((Node)finalPane, "#notificationText")).setText(message);
            if (!isLauncher) {
                Screen screen = Screen.getPrimary();
                Rectangle2D bounds = screen.getVisualBounds();
                Stage notificationStage = this.application.newStage(StageStyle.TRANSPARENT);
                onClose = () -> {
                    if (!notificationStage.isShowing()) {
                        return;
                    }
                    notificationStage.hide();
                    notificationStage.setScene(null);
                    this.count.getAndDecrement();
                };
                finalPane.setOnMouseClicked(e -> onClose.run());
                notificationStage.setAlwaysOnTop(true);
                notificationStage.setScene(scene);
                notificationStage.sizeToScene();
                notificationStage.setResizable(false);
                notificationStage.setTitle(head);
                notificationStage.show();
                int currentCount = this.count.getAndIncrement() + 1;
                double maxX = bounds.getMaxX();
                double maxY = bounds.getMaxY();
                double x = maxX - notificationStage.getWidth() * 1.1;
                double y = maxY - notificationStage.getHeight() * (double)currentCount * 1.1;
                LogHelper.dev((String)"Screen %f %f setted %f %f", (Object[])new Object[]{maxX, maxY, x, y});
                notificationStage.setX(x);
                notificationStage.setY(y);
            } else {
                AbstractScene currentScene = this.application.getCurrentScene();
                Pane root = (Pane)currentScene.getScene().getRoot();
                root.getChildren().add((Object)finalPane);
                onClose = () -> {
                    if (!root.getChildren().remove((Object)finalPane)) {
                        return;
                    }
                    this.localCount.getAndDecrement();
                };
                int currentCount = this.localCount.getAndIncrement();
                double maxX = root.getWidth();
                double maxY = root.getHeight();
                finalPane.setVisible(true);
                double x = maxX - finalPane.getPrefWidth();
                double y = finalPane.getPrefHeight() * (double)currentCount * 1.1 + finalPane.getPrefHeight() * 0.6;
                finalPane.setLayoutX(x);
                finalPane.setLayoutY(y);
                LogHelper.dev((String)"Layout %f %f setted %f %f", (Object[])new Object[]{maxX, maxY, x, y});
            }
            finalPane.setOnMouseClicked(e -> {
                if (!e.getButton().equals((Object)MouseButton.PRIMARY)) {
                    return;
                }
                onClose.run();
            });
            AbstractScene.fade((Node)finalPane, 2500.0, 1.0, 0.0, (EventHandler<ActionEvent>)((EventHandler)e -> onClose.run()));
        });
    }

    public void showDialog(String header, String text, Runnable onApplyCallback, Runnable onCloseCallback, boolean isLauncher) {
        this.showAbstractDialog("components/dialog.fxml", header, pane -> {
            ((Text)LookupHelper.lookup((Node)pane, "#headingDialog")).setText(header);
            ((Text)LookupHelper.lookup((Node)pane, "#textDialog")).setText(text);
        }, (pane, onClose) -> {
            ((Button)LookupHelper.lookup((Node)pane, "#close")).setOnAction(e -> {
                onClose.run();
                onCloseCallback.run();
            });
            ((Button)LookupHelper.lookup((Node)pane, "#apply")).setOnAction(e -> {
                onClose.run();
                onApplyCallback.run();
            });
        }, isLauncher);
    }

    public void showApplyDialog(String header, String text, Runnable onApplyCallback, Runnable onDenyCallback, boolean isLauncher) {
        this.showApplyDialog(header, text, onApplyCallback, onDenyCallback, onDenyCallback, isLauncher);
    }

    public void showApplyDialog(String header, String text, Runnable onApplyCallback, Runnable onDenyCallback, Runnable onCloseCallback, boolean isLauncher) {
        this.showAbstractDialog("components/dialogApply.fxml", header, pane -> {
            ((Text)LookupHelper.lookup((Node)pane, "#headingDialog")).setText(header);
            ((Text)LookupHelper.lookup((Node)pane, "#textDialog")).setText(text);
        }, (pane, onClose) -> {
            ((Button)LookupHelper.lookup((Node)pane, "#close")).setOnAction(e -> {
                onClose.run();
                onCloseCallback.run();
            });
            ((Button)LookupHelper.lookup((Node)pane, "#apply")).setOnAction(e -> {
                onClose.run();
                onApplyCallback.run();
            });
            ((Button)LookupHelper.lookup((Node)pane, "#deny")).setOnAction(e -> {
                onClose.run();
                onDenyCallback.run();
            });
        }, isLauncher);
    }

    public void showTextDialog(String header, Consumer<String> onApplyCallback, Runnable onCloseCallback, boolean isLauncher) {
        this.showAbstractDialog("components/dialogTextInput.fxml", header, pane -> ((Text)LookupHelper.lookup((Node)pane, "#headingDialog")).setText(header), (pane, onClose) -> {
            ((Button)LookupHelper.lookup((Node)pane, "#close")).setOnAction(e -> {
                onClose.run();
                onCloseCallback.run();
            });
            TextField a = (TextField)LookupHelper.lookup((Node)pane, "#dialogInput");
            ((Button)LookupHelper.lookup((Node)pane, "#apply")).setOnAction(e -> {
                onClose.run();
                onApplyCallback.accept(a.getText());
            });
        }, isLauncher);
    }

    private void showAbstractDialog(String componentName, String nativeHeader, Consumer<Pane> initPane, BiConsumer<Pane, Runnable> bindPane, boolean isLauncher) {
        Pane pane;
        try {
            pane = (Pane)this.application.getNonCachedFxmlAsync(componentName).get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        Pane finalPane = pane;
        Scene scene = isLauncher ? null : new Scene((Parent)finalPane);
        ContextHelper.runInFxThreadStatic(() -> {
            Runnable onClose;
            initPane.accept(finalPane);
            if (isLauncher) {
                AbstractScene currentScene = this.application.getCurrentScene();
                Pane root = (Pane)currentScene.getScene().getRoot();
                Pane shadow = new Pane();
                shadow.setPrefHeight(root.getPrefHeight());
                shadow.setPrefWidth(root.getPrefWidth());
                root.getChildren().add((Object)shadow);
                root.getChildren().add((Object)finalPane);
                onClose = () -> {
                    root.getChildren().remove((Object)finalPane);
                    root.getChildren().remove((Object)shadow);
                };
                pane.setLayoutX((root.getPrefWidth() - pane.getPrefWidth()) / 2.0);
                pane.setLayoutY((root.getPrefHeight() - pane.getPrefHeight()) / 2.0);
                LogHelper.debug((String)"Layout: X: %f, Y: %f", (Object[])new Object[]{pane.getLayoutX(), pane.getLayoutY()});
            } else {
                Screen screen = Screen.getPrimary();
                Rectangle2D bounds = screen.getVisualBounds();
                Stage notificationStage = this.application.newStage(StageStyle.TRANSPARENT);
                onClose = () -> {
                    notificationStage.hide();
                    notificationStage.setScene(null);
                };
                finalPane.setOnMouseClicked(e -> onClose.run());
                notificationStage.setAlwaysOnTop(true);
                notificationStage.setScene(scene);
                notificationStage.sizeToScene();
                notificationStage.setResizable(false);
                notificationStage.setTitle(nativeHeader);
                notificationStage.show();
                double x = (bounds.getMaxX() - pane.getPrefWidth()) / 2.0;
                double y = (bounds.getMaxY() - pane.getPrefHeight()) / 2.0;
                notificationStage.setX(x);
                notificationStage.setY(y);
            }
            bindPane.accept(finalPane, onClose);
        });
    }
}

