/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scene;

import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Labeled;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.raw.AbstractScene;
import pro.gravit.launcher.managers.ConsoleManager;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class ConsoleScene
extends AbstractScene {
    private static final long MAX_LENGTH = 16384L;
    private static final int REMOVE_LENGTH = 1024;
    private TextField commandLine;
    private TextArea output;

    public ConsoleScene(JavaFXApplication application) {
        super("scenes/console/console.fxml", application);
    }

    public static String getLauncherInfo() {
        return String.format("Launcher %s | Java %d(%s %s) x%d | %s x%d", Version.getVersion().toString(), JVMHelper.JVM_VERSION, JVMHelper.RUNTIME_MXBEAN.getVmName(), System.getProperty("java.version"), JVMHelper.JVM_BITS, JVMHelper.OS_TYPE.name(), JVMHelper.OS_BITS);
    }

    public static String getMiniLauncherInfo() {
        return String.format("Launcher %s | Java %d(%s) x%d | %s x%d", Version.getVersion().toString(), JVMHelper.JVM_VERSION, System.getProperty("java.version"), JVMHelper.JVM_BITS, JVMHelper.OS_TYPE.name(), JVMHelper.OS_BITS);
    }

    @Override
    protected void doInit() {
        Parent layout = this.scene.getRoot();
        this.sceneBaseInit((Node)layout);
        this.output = (TextArea)LookupHelper.lookup((Node)layout, "#output");
        this.commandLine = (TextField)LookupHelper.lookup((Node)layout, "#commandInput");
        LogHelper.addOutput(this::append, (LogHelper.OutputTypes)LogHelper.OutputTypes.PLAIN);
        this.commandLine.setOnAction(this::send);
        ((ButtonBase)LookupHelper.lookup((Node)layout, "#send")).setOnAction(this::send);
        ((Labeled)LookupHelper.lookup((Node)layout, "#version")).setText(ConsoleScene.getMiniLauncherInfo());
    }

    @Override
    public void reset() {
        this.output.clear();
        this.commandLine.clear();
        this.commandLine.getStyleClass().removeAll((Object[])new String[]{"InputError"});
    }

    @Override
    public void errorHandle(Throwable e) {
        LogHelper.error((Throwable)e);
    }

    @Override
    protected void doShow() {
        super.doShow();
    }

    private void send(ActionEvent ignored) {
        String command = this.commandLine.getText();
        this.commandLine.clear();
        try {
            ConsoleManager.handler.evalNative(command, false);
            this.commandLine.getStyleClass().removeAll((Object[])new String[]{"InputError"});
        }
        catch (Exception ex) {
            LogHelper.error((Throwable)ex);
            this.commandLine.getStyleClass().add((Object)"InputError");
        }
    }

    private void append(String text) {
        this.contextHelper.runInFxThread(() -> {
            if ((long)this.output.lengthProperty().get() > 16384L) {
                this.output.deleteText(0, 1024);
            }
            this.output.appendText(text.concat("\n"));
        });
    }
}

