/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scene;

import java.util.List;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.raw.AbstractScene;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.events.request.LauncherRequestEvent;
import pro.gravit.launcher.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launcher.request.update.LauncherRequest;
import pro.gravit.launcher.request.update.ProfilesRequest;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class LoginScene
extends AbstractScene {
    public boolean isLoginStarted;
    private List<GetAvailabilityAuthRequestEvent.AuthAvailability> auth;
    private TextField loginField;
    private TextField passwordField;
    private CheckBox savePasswordCheckBox;
    private CheckBox autoenter;
    private ComboBox<GetAvailabilityAuthRequestEvent.AuthAvailability> authList;

    public LoginScene(JavaFXApplication application) {
        super("scenes/login/login.fxml", application);
    }

    @Override
    public void doInit() {
        Object layout = LookupHelper.lookup((Node)this.scene.getRoot(), "#layout", "#authPane");
        this.sceneBaseInit((Node)layout);
        this.loginField = (TextField)LookupHelper.lookup(layout, new String[]{"#login"});
        if (this.application.runtimeSettings.login != null) {
            this.loginField.setText(this.application.runtimeSettings.login);
        }
        this.passwordField = (TextField)LookupHelper.lookup(layout, new String[]{"#password"});
        this.savePasswordCheckBox = (CheckBox)LookupHelper.lookup(layout, new String[]{"#savePassword"});
        if (this.application.runtimeSettings.encryptedPassword != null) {
            this.passwordField.getStyleClass().add((Object)"hasSaved");
            this.passwordField.setPromptText(this.application.getTranslation("runtime.scenes.login.login.password.saved"));
            ((CheckBox)LookupHelper.lookup(layout, new String[]{"#savePassword"})).setSelected(true);
        }
        this.autoenter = (CheckBox)LookupHelper.lookup(layout, new String[]{"#autoenter"});
        this.autoenter.setSelected(this.application.runtimeSettings.autoAuth);
        this.autoenter.setOnAction(event -> {
            this.application.runtimeSettings.autoAuth = this.autoenter.isSelected();
        });
        if (this.application.guiModuleConfig.createAccountURL != null) {
            ((Hyperlink)LookupHelper.lookup(layout, new String[]{"#createAccount"})).setOnAction(e -> this.application.openURL(this.application.guiModuleConfig.createAccountURL));
        }
        if (this.application.guiModuleConfig.forgotPassURL != null) {
            ((Hyperlink)LookupHelper.lookup(layout, new String[]{"#forgotPass"})).setOnAction(e -> this.application.openURL(this.application.guiModuleConfig.forgotPassURL));
        }
        this.authList = (ComboBox)LookupHelper.lookup(layout, new String[]{"#combologin"});
        this.authList.setConverter((StringConverter)new AuthConverter());
        ((ButtonBase)LookupHelper.lookup(layout, new String[]{"#goAuth"})).setOnAction(e -> this.contextHelper.runCallback(this::loginWithGui).run());
        LauncherRequest launcherRequest = new LauncherRequest();
        this.processRequest(this.application.getTranslation("runtime.overlay.processing.text.launcher"), launcherRequest, result -> {
            if (result.needUpdate) {
                try {
                    LogHelper.debug((String)"Start update processing");
                    this.application.securityService.update((LauncherRequestEvent)result);
                    LogHelper.debug((String)"Exit with Platform.exit");
                    Platform.exit();
                    return;
                }
                catch (Throwable e) {
                    this.contextHelper.runInFxThread(() -> this.getCurrentOverlay().errorHandle(e));
                    try {
                        Thread.sleep(1500L);
                        LauncherEngine.modulesManager.invokeEvent((LauncherModule.Event)new ClientExitPhase(0));
                        Platform.exit();
                    }
                    catch (Throwable ex) {
                        LauncherEngine.exitLauncher((int)0);
                    }
                }
            }
            LogHelper.dev((String)"Launcher update processed");
            GetAvailabilityAuthRequest getAvailabilityAuthRequest = new GetAvailabilityAuthRequest();
            this.processRequest(this.application.getTranslation("runtime.overlay.processing.text.authAvailability"), getAvailabilityAuthRequest, auth -> this.contextHelper.runInFxThread(() -> {
                this.auth = auth.list;
                GetAvailabilityAuthRequestEvent.AuthAvailability lastAuth = null;
                for (GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability : auth.list) {
                    if (authAvailability.equals(this.application.runtimeSettings.lastAuth)) {
                        lastAuth = authAvailability;
                    }
                    this.authList.getItems().add((Object)authAvailability);
                }
                if (lastAuth != null) {
                    this.authList.getSelectionModel().select(lastAuth);
                } else {
                    this.authList.getSelectionModel().selectFirst();
                }
                this.hideOverlay(0.0, (EventHandler<ActionEvent>)((EventHandler)event -> {
                    if (this.application.runtimeSettings.encryptedPassword != null && this.application.runtimeSettings.autoAuth) {
                        this.contextHelper.runCallback(this::loginWithGui).run();
                    }
                }));
            }), (EventHandler<ActionEvent>)null);
        }, (EventHandler<ActionEvent>)((EventHandler)event -> LauncherEngine.exitLauncher((int)0)));
    }

    @Override
    public void reset() {
        this.passwordField.getStyleClass().removeAll((Object[])new String[]{"hasSaved"});
        this.passwordField.setPromptText(this.application.getTranslation("runtime.scenes.login.login.password"));
        this.passwordField.setText("");
        this.loginField.setText("");
    }

    @Override
    public void errorHandle(Throwable e) {
        LogHelper.error((Throwable)e);
    }

    private void loginWithGui() {
        byte[] encryptedPassword;
        String login = this.loginField.getText();
        if (this.passwordField.getText().isEmpty() && this.passwordField.getPromptText().equals(this.application.getTranslation("runtime.scenes.login.login.password.saved"))) {
            encryptedPassword = this.application.runtimeSettings.encryptedPassword;
        } else {
            String password = this.passwordField.getText();
            try {
                encryptedPassword = this.encryptPassword(password);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        GetAvailabilityAuthRequestEvent.AuthAvailability authId = (GetAvailabilityAuthRequestEvent.AuthAvailability)this.authList.getSelectionModel().getSelectedItem();
        boolean savePassword = this.savePasswordCheckBox.isSelected();
        this.login(login, encryptedPassword, authId, savePassword);
    }

    private byte[] encryptPassword(String password) throws Exception {
        return SecurityHelper.encrypt((String)this.launcherConfig.passwordEncryptKey, (String)password);
    }

    private void login(String login, byte[] password, GetAvailabilityAuthRequestEvent.AuthAvailability authId, boolean savePassword) {
        this.isLoginStarted = true;
        LogHelper.dev((String)"Auth with %s password ***** authId %s", (Object[])new Object[]{login, authId});
        AuthRequest authRequest = new AuthRequest(login, password, authId.name);
        this.processRequest(this.application.getTranslation("runtime.overlay.processing.text.auth"), authRequest, result -> {
            this.application.runtimeStateMachine.setAuthResult((AuthRequestEvent)result);
            if (savePassword) {
                this.application.runtimeSettings.login = login;
                this.application.runtimeSettings.encryptedPassword = password;
                this.application.runtimeSettings.lastAuth = authId;
            }
            this.onGetProfiles();
        }, (EventHandler<ActionEvent>)null);
    }

    public void onGetProfiles() {
        this.processRequest(this.application.getTranslation("runtime.overlay.processing.text.profiles"), new ProfilesRequest(), profiles -> {
            this.application.runtimeStateMachine.setProfilesResult((ProfilesRequestEvent)profiles);
            this.contextHelper.runInFxThread(() -> {
                this.hideOverlay(0.0, null);
                this.application.securityService.startRequest();
                if (this.application.gui.optionsOverlay != null) {
                    try {
                        this.application.gui.optionsOverlay.loadAll();
                    }
                    catch (Throwable ex) {
                        LogHelper.error((Throwable)ex);
                    }
                }
                if (this.application.getCurrentScene() instanceof LoginScene) {
                    ((LoginScene)this.application.getCurrentScene()).isLoginStarted = false;
                }
                this.application.setMainScene(this.application.gui.serverMenuScene);
            });
        }, (EventHandler<ActionEvent>)null);
    }

    public void clearPassword() {
        this.application.runtimeSettings.encryptedPassword = null;
        this.application.runtimeSettings.login = null;
    }

    private class AuthConverter
    extends StringConverter<GetAvailabilityAuthRequestEvent.AuthAvailability> {
        private AuthConverter() {
        }

        public String toString(GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability) {
            return authAvailability.displayName;
        }

        public GetAvailabilityAuthRequestEvent.AuthAvailability fromString(String s) {
            for (GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability : LoginScene.this.auth) {
                if (!authAvailability.displayName.equals(s)) continue;
                return authAvailability;
            }
            return null;
        }
    }
}

