/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scene;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Labeled;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import javax.imageio.ImageIO;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.client.ClientLauncherProcess;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.ServerPinger;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.overlay.DebugOverlay;
import pro.gravit.launcher.client.gui.raw.AbstractScene;
import pro.gravit.launcher.client.gui.raw.ContextHelper;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.request.auth.ExitRequest;
import pro.gravit.launcher.request.auth.SetProfileRequest;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class ServerMenuScene
extends AbstractScene {
    private static final String SERVER_BUTTON_FXML = "components/serverButton.fxml";
    private static final String SERVER_BUTTON_CUSTOM_FXML = "components/serverButton/%s.fxml";
    private static final String SERVER_BUTTON_CUSTOM_IMAGE = "images/servers/%s.png";
    private Node layout;
    private ImageView avatar;
    private ImageView serverImage;
    private Node lastSelectedServerButton;
    private List<ClientProfile> lastProfiles;
    private javafx.scene.image.Image originalAvatarImage;
    private javafx.scene.image.Image originalServerImage;

    public ServerMenuScene(JavaFXApplication application) {
        super("scenes/servermenu/servermenu.fxml", application);
    }

    private static javafx.scene.image.Image convertToFxImage(BufferedImage image) {
        if (JVMHelper.JVM_VERSION >= 9) {
            return SwingFXUtils.toFXImage((BufferedImage)image, null);
        }
        return ServerMenuScene.convertToFxImageJava8(image);
    }

    private static javafx.scene.image.Image convertToFxImageJava8(BufferedImage image) {
        int bw = image.getWidth();
        int bh = image.getHeight();
        switch (image.getType()) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                BufferedImage converted = new BufferedImage(bw, bh, 3);
                Graphics2D graphics2D = converted.createGraphics();
                graphics2D.drawImage((Image)image, 0, 0, null);
                graphics2D.dispose();
                image = converted;
            }
        }
        WritableImage writableImage = new WritableImage(bw, bh);
        DataBufferInt raster = (DataBufferInt)image.getRaster().getDataBuffer();
        int scan = image.getRaster().getSampleModel() instanceof SinglePixelPackedSampleModel ? ((SinglePixelPackedSampleModel)image.getRaster().getSampleModel()).getScanlineStride() : 0;
        WritablePixelFormat pf = image.isAlphaPremultiplied() ? PixelFormat.getIntArgbPreInstance() : PixelFormat.getIntArgbInstance();
        writableImage.getPixelWriter().setPixels(0, 0, bw, bh, (PixelFormat)pf, raster.getData(), raster.getOffset(), scan);
        return writableImage;
    }

    @Override
    public void doInit() throws Exception {
        this.layout = LookupHelper.lookup((Node)this.scene.getRoot(), "#layout", "#serverMenu");
        this.sceneBaseInit(this.layout);
        this.avatar = (ImageView)LookupHelper.lookup(this.layout, "#avatar");
        this.serverImage = (ImageView)LookupHelper.lookup(this.layout, "#serverImage");
        this.originalAvatarImage = this.avatar.getImage();
        this.originalServerImage = this.serverImage.getImage();
        ((ButtonBase)LookupHelper.lookup(this.layout, "#clientSettings")).setOnAction(e -> {
            try {
                if (this.application.runtimeStateMachine.getProfile() == null) {
                    return;
                }
                this.showOverlay(this.application.gui.optionsOverlay, (EventHandler<ActionEvent>)((EventHandler)ec -> this.application.gui.optionsOverlay.addProfileOptionals(this.application.runtimeStateMachine.getProfile())));
            }
            catch (Exception ex) {
                LogHelper.error((Throwable)ex);
            }
        });
        ((ButtonBase)LookupHelper.lookup(this.layout, "#settings")).setOnAction(e -> this.showOverlay(this.application.gui.settingsOverlay, null));
        ((ButtonBase)LookupHelper.lookup(this.layout, "#exit")).setOnAction(e -> this.application.messageManager.showApplyDialog(this.application.getTranslation("runtime.overlay.settings.exitDialog.header"), this.application.getTranslation("runtime.overlay.settings.exitDialog.description"), () -> this.processRequest(this.application.getTranslation("runtime.overlay.settings.exitDialog.processing"), new ExitRequest(), event -> ContextHelper.runInFxThreadStatic(() -> {
            this.hideOverlay(0.0, null);
            this.application.gui.loginScene.clearPassword();
            this.application.gui.loginScene.reset();
            try {
                this.application.saveSettings();
                this.application.runtimeStateMachine.exit();
                this.getCurrentStage().setScene(this.application.gui.loginScene);
            }
            catch (Exception ex) {
                LogHelper.error((Throwable)ex);
            }
        }), (EventHandler<ActionEvent>)((EventHandler)event -> {})), () -> {}, true));
        ((ButtonBase)LookupHelper.lookup(this.layout, "#clientLaunch")).setOnAction(e -> this.launchClient());
        this.reset();
    }

    @Override
    public void reset() {
        this.lastProfiles = this.application.runtimeStateMachine.getProfiles();
        LinkedHashMap<ClientProfile, ServerButtonCache> serverButtonCacheMap = new LinkedHashMap<ClientProfile, ServerButtonCache>();
        ((Labeled)LookupHelper.lookup(this.layout, "#nickname")).setText(this.application.runtimeStateMachine.getUsername());
        this.avatar.setImage(this.originalAvatarImage);
        try {
            int position = 0;
            for (ClientProfile profile2 : this.application.runtimeStateMachine.getProfiles()) {
                String customFxmlName;
                URL customFxml;
                ServerButtonCache cache = new ServerButtonCache();
                UUID profileUUID = profile2.getUUID();
                if (profileUUID == null) {
                    profileUUID = UUID.randomUUID();
                    LogHelper.warning((String)"Profile %s UUID null", (Object[])new Object[]{profileUUID});
                }
                cache.pane = (customFxml = this.application.tryResource(customFxmlName = String.format(SERVER_BUTTON_CUSTOM_FXML, profileUUID))) != null ? this.application.getNonCachedFxmlAsync(customFxmlName, IOHelper.newInput((URL)customFxml)) : this.application.getNonCachedFxmlAsync(SERVER_BUTTON_FXML);
                String customImageName = String.format(SERVER_BUTTON_CUSTOM_IMAGE, profileUUID);
                URL customImage = this.application.tryResource(customImageName);
                if (customImage != null) {
                    cache.getImage = () -> new javafx.scene.image.Image(customImage.toString());
                }
                cache.position = position++;
                serverButtonCacheMap.put(profile2, cache);
            }
        }
        catch (IOException e) {
            this.errorHandle(e);
            return;
        }
        Pane serverList = (Pane)((ScrollPane)LookupHelper.lookup(this.layout, "#serverlist")).getContent();
        serverList.getChildren().clear();
        serverButtonCacheMap.forEach((profile, serverButtonCache) -> {
            try {
                Pane pane = serverButtonCache.pane.get();
                AtomicReference pingerResult = new AtomicReference();
                ((Hyperlink)LookupHelper.lookup((Node)pane, "#nameServer")).setText(profile.getTitle());
                ((Text)LookupHelper.lookup((Node)pane, "#genreServer")).setText(profile.getVersion().toString());
                profile.updateOptionalGraph();
                EventHandler handle = event -> {
                    if (!event.getButton().equals((Object)MouseButton.PRIMARY)) {
                        return;
                    }
                    if (this.lastSelectedServerButton != null) {
                        this.lastSelectedServerButton.getStyleClass().remove((Object)"serverButtonsActive");
                    }
                    this.lastSelectedServerButton = pane;
                    this.lastSelectedServerButton.getStyleClass().add((Object)"serverButtonsActive");
                    this.changeServer((ClientProfile)profile, (ServerPinger.Result)pingerResult.get(), serverButtonCache.getImage());
                    LogHelper.dev((String)"Selected profile %s", (Object[])new Object[]{profile.getTitle()});
                };
                pane.setOnMouseClicked(handle);
                LookupHelper.lookup((Node)pane, "#nameServer").setOnMouseClicked(handle);
                int profilePosition = serverButtonCache.position;
                if (profilePosition >= serverList.getChildren().size()) {
                    profilePosition = serverList.getChildren().size();
                }
                serverList.getChildren().add(profilePosition, (Object)pane);
                this.application.workers.submit(() -> {
                    ServerPinger.Result result;
                    ServerPinger pinger = new ServerPinger(profile);
                    try {
                        result = pinger.ping();
                    }
                    catch (IOException e) {
                        result = new ServerPinger.Result(0, 0, "0 / 0");
                    }
                    pingerResult.set(result);
                    ServerPinger.Result finalResult = result;
                    this.contextHelper.runInFxThread(() -> {
                        ((Text)LookupHelper.lookup((Node)pane, "#online")).setText(String.valueOf(finalResult.onlinePlayers));
                        if (this.application.runtimeStateMachine.getProfile() != null && this.application.runtimeStateMachine.getProfile() == profile) {
                            ((Text)LookupHelper.lookup(this.layout, "#headingOnline")).setText(String.format("%d / %d", finalResult.onlinePlayers, finalResult.maxPlayers));
                        }
                    });
                });
                if (this.application.runtimeSettings.lastProfile == null && this.lastSelectedServerButton == null || profile.getUUID() != null && profile.getUUID().equals(this.application.runtimeSettings.lastProfile)) {
                    this.lastSelectedServerButton = pane;
                    this.lastSelectedServerButton.getStyleClass().add((Object)"serverButtonsActive");
                    this.changeServer((ClientProfile)profile, (ServerPinger.Result)pingerResult.get(), serverButtonCache.getImage());
                    LogHelper.dev((String)"Selected profile %s", (Object[])new Object[]{profile.getTitle()});
                }
            }
            catch (InterruptedException | ExecutionException e) {
                LogHelper.error((Throwable)e);
            }
        });
        CommonHelper.newThread((String)"SkinHead Downloader Thread", (boolean)true, () -> {
            try {
                this.updateSkinHead();
            }
            catch (Throwable e) {
                LogHelper.error((Throwable)e);
            }
        }).start();
    }

    @Override
    public void errorHandle(Throwable e) {
        LogHelper.error((Throwable)e);
    }

    @Override
    protected void doShow() {
        super.doShow();
        if (this.lastProfiles != this.application.runtimeStateMachine.getProfiles()) {
            this.reset();
        }
    }

    private void updateSkinHead() throws IOException {
        PlayerProfile playerProfile = this.application.runtimeStateMachine.getPlayerProfile();
        if (playerProfile == null) {
            return;
        }
        if (playerProfile.skin == null || playerProfile.skin.url == null) {
            LogHelper.debug((String)"Skin not found");
            return;
        }
        String url = playerProfile.skin.url;
        BufferedImage origImage = this.downloadSkinHead(url);
        int imageHeight = (int)this.avatar.getFitHeight();
        int imageWidth = (int)this.avatar.getFitWidth();
        Image resized = origImage.getScaledInstance(imageWidth, imageHeight, 2);
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, 3);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.drawImage(resized, 0, 0, null);
        graphics2D.dispose();
        this.avatar.setImage(ServerMenuScene.convertToFxImage(image));
    }

    private BufferedImage downloadSkinHead(String url) throws IOException {
        BufferedImage image = ImageIO.read(new URL(url));
        int width = image.getWidth();
        int renderScale = width / 64;
        int offset = 8 * renderScale;
        LogHelper.debug((String)"ShinHead debug: W: %d Scale: %d Offset: %d", (Object[])new Object[]{width, renderScale, offset});
        return image.getSubimage(offset, offset, offset, offset);
    }

    private void changeServer(ClientProfile profile, ServerPinger.Result pingerResult, javafx.scene.image.Image serverImage) {
        this.application.runtimeStateMachine.setProfile(profile);
        this.application.runtimeSettings.lastProfile = profile.getUUID();
        ((Text)LookupHelper.lookup(this.layout, "#heading")).setText(profile.getTitle());
        ((Text)LookupHelper.lookup(((ScrollPane)LookupHelper.lookup(this.layout, "#serverInfo")).getContent(), "#servertext")).setText(profile.getInfo());
        if (pingerResult != null) {
            ((Text)LookupHelper.lookup(this.layout, "#headingOnline")).setText(String.format("%d / %d", pingerResult.onlinePlayers, pingerResult.maxPlayers));
        } else {
            ((Text)LookupHelper.lookup(this.layout, "#headingOnline")).setText("? / ?");
        }
        if (serverImage != null) {
            this.serverImage.setImage(serverImage);
        }
    }

    private boolean isEnabledDownloadJava() {
        return this.application.securityService.isMayBeDownloadJava() && this.application.guiModuleConfig.enableDownloadJava && (!this.application.guiModuleConfig.userDisableDownloadJava || this.application.runtimeSettings.disableJavaDownload);
    }

    private void launchClient() {
        ClientProfile profile = this.application.runtimeStateMachine.getProfile();
        if (profile == null) {
            return;
        }
        this.processRequest(this.application.getTranslation("runtime.overlay.processing.text.setprofile"), new SetProfileRequest(profile), result -> this.showOverlay(this.application.gui.updateOverlay, (EventHandler<ActionEvent>)((EventHandler)e -> {
            this.application.gui.updateOverlay.initNewPhase(this.application.getTranslation("runtime.overlay.update.phase.java"));
            if (this.isEnabledDownloadJava()) {
                String jvmDirName = JVMHelper.OS_BITS == 64 ? this.application.guiModuleConfig.jvmWindows64Dir : this.application.guiModuleConfig.jvmWindows32Dir;
                Path jvmDirPath = DirBridge.dirUpdates.resolve(jvmDirName);
                this.application.gui.updateOverlay.sendUpdateRequest(jvmDirName, jvmDirPath, null, profile.isUpdateFastCheck(), profile, false, jvmHDir -> this.downloadClients(profile, jvmDirPath, (HashedDir)jvmHDir));
            } else {
                this.downloadClients(profile, null, null);
            }
        })), (EventHandler<ActionEvent>)null);
    }

    private void downloadClients(ClientProfile profile, Path jvmDir, HashedDir jvmHDir) {
        Path target = DirBridge.dirUpdates.resolve(profile.getAssetDir());
        LogHelper.info((String)"Start update to %s", (Object[])new Object[]{target.toString()});
        this.application.gui.updateOverlay.initNewPhase(this.application.getTranslation("runtime.overlay.update.phase.assets"));
        this.application.gui.updateOverlay.sendUpdateRequest(profile.getAssetDir(), target, profile.getAssetUpdateMatcher(), profile.isUpdateFastCheck(), profile, false, assetHDir -> {
            Path targetClient = DirBridge.dirUpdates.resolve(profile.getDir());
            LogHelper.info((String)"Start update to %s", (Object[])new Object[]{targetClient.toString()});
            this.application.gui.updateOverlay.initNewPhase(this.application.getTranslation("runtime.overlay.update.phase.client"));
            this.application.gui.updateOverlay.sendUpdateRequest(profile.getDir(), targetClient, profile.getClientUpdateMatcher(), profile.isUpdateFastCheck(), profile, true, clientHDir -> {
                LogHelper.info((String)"Success update");
                this.application.gui.updateOverlay.initNewPhase(this.application.getTranslation("runtime.overlay.update.phase.launch"));
                this.doLaunchClient(target, (HashedDir)assetHDir, targetClient, (HashedDir)clientHDir, profile, jvmDir, jvmHDir);
            });
        });
    }

    private void doLaunchClient(Path assetDir, HashedDir assetHDir, Path clientDir, HashedDir clientHDir, ClientProfile profile, Path jvmDir, HashedDir jvmHDir) {
        ClientLauncherProcess clientLauncherProcess = new ClientLauncherProcess(clientDir, assetDir, jvmDir != null ? jvmDir : Paths.get(System.getProperty("java.home"), new String[0]), profile, this.application.runtimeStateMachine.getPlayerProfile(), this.application.runtimeStateMachine.getAccessToken(), clientHDir, assetHDir, jvmHDir == null ? new HashedDir() : jvmHDir);
        clientLauncherProcess.params.ram = this.application.runtimeSettings.ram;
        if (clientLauncherProcess.params.ram > 0) {
            clientLauncherProcess.jvmArgs.add("-Xms" + clientLauncherProcess.params.ram + 'M');
            clientLauncherProcess.jvmArgs.add("-Xmx" + clientLauncherProcess.params.ram + 'M');
        }
        clientLauncherProcess.params.fullScreen = this.application.runtimeSettings.fullScreen;
        clientLauncherProcess.params.autoEnter = this.application.runtimeSettings.autoEnter;
        this.contextHelper.runCallback(() -> {
            Thread writerThread = CommonHelper.newThread((String)"Client Params Writer Thread", (boolean)true, () -> {
                block3: {
                    try {
                        clientLauncherProcess.runWriteParams((SocketAddress)new InetSocketAddress("127.0.0.1", Launcher.getConfig().clientPort));
                        if (!this.application.runtimeSettings.debug) {
                            LogHelper.debug((String)"Params writted successful. Exit...");
                            LauncherEngine.exitLauncher((int)0);
                        }
                    }
                    catch (Throwable e) {
                        LogHelper.error((Throwable)e);
                        if (!(this.getCurrentOverlay() instanceof DebugOverlay)) break block3;
                        DebugOverlay debugOverlay = (DebugOverlay)this.getCurrentOverlay();
                        debugOverlay.append(String.format("Launcher fatal error(Write Params Thread): %s: %s", e.getClass().getName(), e.getMessage()));
                        if (debugOverlay.currentProcess == null || !debugOverlay.currentProcess.isAlive()) break block3;
                        debugOverlay.currentProcess.destroy();
                    }
                }
            });
            writerThread.start();
            this.application.gui.debugOverlay.writeParametersThread = writerThread;
            clientLauncherProcess.start(true);
            this.showOverlay(this.application.gui.debugOverlay, (EventHandler<ActionEvent>)((EventHandler)e -> this.application.gui.debugOverlay.onProcess(clientLauncherProcess.getProcess())));
        }).run();
    }

    class ServerButtonCache {
        public Future<Pane> pane;
        SoftReference<javafx.scene.image.Image> imageRef = new SoftReference<Object>(null);
        public int position;
        Supplier<javafx.scene.image.Image> getImage = () -> ServerMenuScene.access$000(ServerMenuScene.this);

        ServerButtonCache() {
        }

        public javafx.scene.image.Image getImage() {
            javafx.scene.image.Image result = this.imageRef.get();
            if (result != null) {
                return result;
            }
            result = this.getImage.get();
            this.imageRef = new SoftReference<javafx.scene.image.Image>(result);
            return result;
        }
    }
}

