/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedList;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.client.ClientLauncher;
import pro.gravit.launcher.client.ClientModuleManager;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class ClientLauncherWrapper {
    public static final String MAGIC_ARG = "-Djdk.attach.allowAttachSelf";
    public static final String WAIT_PROCESS_PROPERTY = "launcher.waitProcess";
    public static final String NO_JAVA9_CHECK_PROPERTY = "launcher.noJava9Check";
    public static boolean waitProcess = Boolean.getBoolean("launcher.waitProcess");
    public static boolean noJava9check = Boolean.getBoolean("launcher.noJava9Check");

    public static void main(String[] arguments) throws IOException, InterruptedException {
        LogHelper.printVersion((String)"Launcher");
        LogHelper.printLicense((String)"Launcher");
        JVMHelper.checkStackTrace(ClientLauncherWrapper.class);
        JVMHelper.verifySystemProperties(Launcher.class, (boolean)true);
        EnvHelper.checkDangerousParams();
        LauncherConfig config = Launcher.getConfig();
        LauncherEngine.modulesManager = new ClientModuleManager();
        LauncherConfig.getAutogenConfig().initModules();
        LogHelper.info((String)"Launcher for project %s", (Object[])new Object[]{config.projectname});
        if (config.environment.equals((Object)LauncherConfig.LauncherEnvironment.PROD)) {
            if (System.getProperty("launcher.debug") != null) {
                LogHelper.warning((String)"Found -Dlauncher.debug=true");
            }
            if (System.getProperty("launcher.stacktrace") != null) {
                LogHelper.warning((String)"Found -Dlauncher.stacktrace=true");
            }
            LogHelper.info((String)"Debug mode disabled (found env PRODUCTION)");
        } else {
            LogHelper.info((String)"If need debug output use -Dlauncher.debug=true");
            LogHelper.info((String)"If need stacktrace output use -Dlauncher.stacktrace=true");
            if (LogHelper.isDebugEnabled()) {
                waitProcess = true;
            }
        }
        LogHelper.info((String)"Restart Launcher with JavaAgent...");
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (waitProcess) {
            processBuilder.inheritIO();
        }
        Path javaBin = IOHelper.resolveJavaBin((Path)Paths.get(System.getProperty("java.home"), new String[0]));
        LinkedList<String> args = new LinkedList<String>();
        args.add(javaBin.toString());
        String pathLauncher = IOHelper.getCodeSource(ClientLauncher.class).toString();
        args.add(JVMHelper.jvmProperty((String)"launcher.debug", (String)Boolean.toString(LogHelper.isDebugEnabled())));
        args.add(JVMHelper.jvmProperty((String)"launcher.stacktrace", (String)Boolean.toString(LogHelper.isStacktraceEnabled())));
        args.add(JVMHelper.jvmProperty((String)"launcher.dev", (String)Boolean.toString(LogHelper.isDevEnabled())));
        JVMHelper.addSystemPropertyToArgs(args, (String)"launcher.customdir");
        JVMHelper.addSystemPropertyToArgs(args, (String)"launcher.usecustomdir");
        JVMHelper.addSystemPropertyToArgs(args, (String)"launcher.useoptdir");
        if (!noJava9check && !System.getProperty("java.version").startsWith("1.8")) {
            LogHelper.debug((String)"Found Java 9+ ( %s )", (Object[])new Object[]{System.getProperty("java.version")});
            Collections.addAll(args, "--add-modules");
            Collections.addAll(args, "javafx.base,javafx.fxml,javafx.controls,jdk.unsupported");
            Path jvmDir = Paths.get(System.getProperty("java.home"), new String[0]);
            String pathToFx = System.getenv("PATH_TO_FX");
            Path fxPath = pathToFx == null ? null : Paths.get(pathToFx, new String[0]);
            StringBuilder builder = new StringBuilder();
            Path[] findPath = new Path[]{jvmDir, fxPath};
            ClientLauncherWrapper.tryAddModule(findPath, "javafx.base", builder);
            ClientLauncherWrapper.tryAddModule(findPath, "javafx.graphics", builder);
            ClientLauncherWrapper.tryAddModule(findPath, "javafx.fxml", builder);
            ClientLauncherWrapper.tryAddModule(findPath, "javafx.controls", builder);
            String modulePath = builder.toString();
            if (!modulePath.isEmpty()) {
                Collections.addAll(args, "--module-path");
                Collections.addAll(args, modulePath);
            }
        }
        Collections.addAll(args, MAGIC_ARG);
        Collections.addAll(args, "-XX:+DisableAttachMechanism");
        Collections.addAll(args, "-javaagent:".concat(pathLauncher));
        Collections.addAll(args, "-cp");
        Collections.addAll(args, pathLauncher);
        Collections.addAll(args, LauncherEngine.class.getName());
        LauncherEngine.modulesManager.callWrapper(processBuilder, args);
        EnvHelper.addEnv((ProcessBuilder)processBuilder);
        LogHelper.debug((String)("Commandline: " + args));
        processBuilder.command(args);
        Process process = processBuilder.start();
        if (!waitProcess) {
            Thread.sleep(3000L);
            if (!process.isAlive()) {
                int errorcode = process.exitValue();
                if (errorcode != 0) {
                    LogHelper.error((String)"Process exit with error code: %d", (Object[])new Object[]{errorcode});
                } else {
                    LogHelper.info((String)"Process exit with code 0");
                }
            } else {
                LogHelper.debug((String)"Process started success");
            }
        } else {
            process.waitFor();
        }
    }

    public static Path tryFindModule(Path path, String moduleName) {
        Path result = path.resolve(moduleName.concat(".jar"));
        LogHelper.dev((String)"Try resolve %s", (Object[])new Object[]{result.toString()});
        if (IOHelper.isFile((Path)result)) {
            return result;
        }
        result = path.resolve("lib").resolve(moduleName.concat(".jar"));
        if (!IOHelper.isFile((Path)result)) {
            return null;
        }
        return result;
    }

    public static boolean tryAddModule(Path[] paths, String moduleName, StringBuilder args) {
        for (Path path : paths) {
            Path result;
            if (path == null || (result = ClientLauncherWrapper.tryFindModule(path, moduleName)) == null) continue;
            if (args.length() != 0) {
                args.append(File.pathSeparatorChar);
            }
            args.append(result.toAbsolutePath().toString());
            return true;
        }
        return false;
    }
}

