/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import pro.gravit.launcher.NewLauncherSettings;
import pro.gravit.launcher.downloader.ListDownloader;
import pro.gravit.launcher.events.request.UpdateRequestEvent;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.hasher.HashedEntry;
import pro.gravit.launcher.hasher.HashedFile;
import pro.gravit.launcher.managers.SettingsManager;
import pro.gravit.launcher.request.update.UpdateRequest;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class LauncherUpdateController
implements UpdateRequest.UpdateController {
    public void preUpdate(UpdateRequest request, UpdateRequestEvent e) {
    }

    public void preDiff(UpdateRequest request, UpdateRequestEvent e) {
    }

    public void postDiff(UpdateRequest request, UpdateRequestEvent e, HashedDir.Diff diff) throws IOException {
        if (e.zip && e.fullDownload) {
            return;
        }
        if (SettingsManager.settings.featureStore) {
            LogHelper.info((String)"Enabled HStore feature. Find");
            AtomicReference<Object> lastEn = new AtomicReference<Object>(null);
            diff.mismatch.walk((CharSequence)File.separator, (path, name, entry) -> {
                if (entry.getType() == HashedEntry.Type.DIR) {
                    Files.createDirectories(request.getDir().resolve(path), new FileAttribute[0]);
                    return HashedDir.WalkAction.CONTINUE;
                }
                HashedFile file = (HashedFile)entry;
                Path ret = null;
                if (lastEn.get() == null) {
                    for (NewLauncherSettings.HashedStoreEntry en : SettingsManager.settings.lastHDirs) {
                        ret = this.tryFind(en, file);
                        if (ret == null) continue;
                        lastEn.set(en);
                        break;
                    }
                } else {
                    ret = this.tryFind((NewLauncherSettings.HashedStoreEntry)lastEn.get(), file);
                }
                if (ret == null) {
                    for (NewLauncherSettings.HashedStoreEntry en : SettingsManager.settings.lastHDirs) {
                        ret = this.tryFind(en, file);
                        if (ret == null) continue;
                        lastEn.set(en);
                        break;
                    }
                }
                if (ret != null) {
                    Path source = request.getDir().resolve(path);
                    if (LogHelper.isDebugEnabled()) {
                        LogHelper.debug((String)"Copy file %s to %s", (Object[])new Object[]{ret.toAbsolutePath().toString(), source.toAbsolutePath().toString()});
                    }
                    Files.deleteIfExists(source);
                    Files.copy(ret, source, new CopyOption[0]);
                    try (InputStream input = IOHelper.newInput((Path)ret);){
                        IOHelper.transfer((InputStream)input, (Path)source);
                    }
                    entry.flag = true;
                }
                return HashedDir.WalkAction.CONTINUE;
            });
        }
    }

    public Path tryFind(NewLauncherSettings.HashedStoreEntry en, HashedFile file) throws IOException {
        AtomicReference<Object> ret = new AtomicReference<Object>(null);
        en.hdir.walk((CharSequence)File.separator, (path, name, entry) -> {
            if (entry.getType() == HashedEntry.Type.DIR) {
                return HashedDir.WalkAction.CONTINUE;
            }
            HashedFile tfile = (HashedFile)entry;
            if (tfile.isSame(file)) {
                if (LogHelper.isDevEnabled()) {
                    LogHelper.dev((String)"[DIR:%s] Found file %s in %s", (Object[])new Object[]{en.name, name, path});
                }
                Path tdir = Paths.get(en.fullPath, new String[0]).resolve(path);
                try {
                    if (tfile.isSame(tdir, true)) {
                        if (LogHelper.isDevEnabled()) {
                            LogHelper.dev((String)"[DIR:%s] Confirmed file %s in %s", (Object[])new Object[]{en.name, name, path});
                        }
                        ret.set(tdir);
                        return HashedDir.WalkAction.STOP;
                    }
                }
                catch (IOException e) {
                    LogHelper.error((String)"Check file error %s %s", (Object[])new Object[]{e.getClass().getName(), e.getMessage()});
                }
            }
            return HashedDir.WalkAction.CONTINUE;
        });
        return ret.get();
    }

    public void preDownload(UpdateRequest request, UpdateRequestEvent e, List<ListDownloader.DownloadTask> adds) {
    }

    public void postDownload(UpdateRequest request, UpdateRequestEvent e) {
    }

    public void postUpdate(UpdateRequest request, UpdateRequestEvent e) {
    }
}

