/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherAPI;
import pro.gravit.launcher.LauncherAgent;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.client.ClientLauncherContext;
import pro.gravit.launcher.client.ClientModuleManager;
import pro.gravit.launcher.client.FunctionalBridge;
import pro.gravit.launcher.guard.LauncherGuardManager;
import pro.gravit.launcher.gui.JSRuntimeProvider;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.hwid.HWIDProvider;
import pro.gravit.launcher.managers.ClientGsonManager;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.auth.RestoreSessionRequest;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.launcher.serialize.stream.StreamObject;
import pro.gravit.launcher.utils.DirWatcher;
import pro.gravit.utils.PublicURLClassLoader;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public final class ClientLauncher {
    private static final String SOCKET_HOST = "127.0.0.1";
    private static final int SOCKET_PORT = Launcher.getConfig().clientPort;
    private static final String MAGICAL_INTEL_OPTION = "-XX:HeapDumpPath=ThisTricksIntelDriversForPerformance_javaw.exe_minecraft.exe.heapdump";
    private static Path JavaBinPath;
    private static final Set<PosixFilePermission> BIN_POSIX_PERMISSIONS;
    private static final Path NATIVES_DIR;
    private static final Path RESOURCEPACKS_DIR;
    private static PublicURLClassLoader classLoader;
    private static Process process;
    private static boolean clientStarted;
    private static Thread writeParamsThread;
    public static PlayerProfile playerProfile;

    public static Path getJavaBinPath() {
        return JavaBinPath;
    }

    private static void addClientArgs(Collection<String> args, ClientProfile profile, Params params) {
        PlayerProfile pp = params.pp;
        ClientProfile.Version version = profile.getVersion();
        Collections.addAll(args, "--username", pp.username);
        if (version.compareTo((Enum)ClientProfile.Version.MC172) >= 0) {
            Collections.addAll(args, "--uuid", Launcher.toHash((UUID)pp.uuid));
            Collections.addAll(args, "--accessToken", params.accessToken);
            if (version.compareTo((Enum)ClientProfile.Version.MC1710) >= 0) {
                Collections.addAll(args, "--userType", "mojang");
                ClientUserProperties properties = new ClientUserProperties();
                if (pp.skin != null) {
                    properties.skinURL = new String[]{pp.skin.url};
                    properties.skinDigest = new String[]{SecurityHelper.toHex((byte[])pp.skin.digest)};
                }
                if (pp.cloak != null) {
                    properties.cloakURL = new String[]{pp.cloak.url};
                    properties.cloakDigest = new String[]{SecurityHelper.toHex((byte[])pp.cloak.digest)};
                }
                Collections.addAll(args, "--userProperties", Launcher.gsonManager.gson.toJson((Object)properties));
                Collections.addAll(args, "--assetIndex", profile.getAssetIndex());
            }
        } else {
            Collections.addAll(args, "--session", params.accessToken);
        }
        Collections.addAll(args, "--version", profile.getVersion().name);
        Collections.addAll(args, "--gameDir", params.clientDir.toString());
        Collections.addAll(args, "--assetsDir", params.assetDir.toString());
        Collections.addAll(args, "--resourcePackDir", params.clientDir.resolve(RESOURCEPACKS_DIR).toString());
        if (version.compareTo((Enum)ClientProfile.Version.MC194) >= 0) {
            Collections.addAll(args, "--versionType", "Launcher v" + Version.getVersion().getVersionString());
        }
        if (params.autoEnter) {
            Collections.addAll(args, "--server", profile.getServerAddress());
            Collections.addAll(args, "--port", Integer.toString(profile.getServerPort()));
        }
        profile.pushOptionalClientArgs(args);
        if (params.fullScreen) {
            Collections.addAll(args, "--fullscreen", Boolean.toString(true));
        }
        if (params.width > 0 && params.height > 0) {
            Collections.addAll(args, "--width", Integer.toString(params.width));
            Collections.addAll(args, "--height", Integer.toString(params.height));
        }
    }

    @LauncherAPI
    public static void setJavaBinPath(Path javaBinPath) {
        JavaBinPath = javaBinPath;
    }

    private static void addClientLegacyArgs(Collection<String> args, ClientProfile profile, Params params) {
        args.add(params.pp.username);
        args.add(params.accessToken);
        Collections.addAll(args, "--version", profile.getVersion().name);
        Collections.addAll(args, "--gameDir", params.clientDir.toString());
        Collections.addAll(args, "--assetsDir", params.assetDir.toString());
    }

    @LauncherAPI
    public static void checkJVMBitsAndVersion() {
        if (JVMHelper.JVM_BITS != JVMHelper.OS_BITS) {
            String error = String.format("\u0423 \u0412\u0430\u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 Java %d, \u043d\u043e \u0412\u0430\u0448\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430 \u043a\u0430\u043a %d. \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 Java \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0439 \u0440\u0430\u0437\u0440\u044f\u0434\u043d\u043e\u0441\u0442\u0438", JVMHelper.JVM_BITS, JVMHelper.OS_BITS);
            LogHelper.error((String)error);
            if (Launcher.getConfig().isWarningMissArchJava) {
                JOptionPane.showMessageDialog(null, error);
            }
        }
        String jvmVersion = JVMHelper.RUNTIME_MXBEAN.getVmVersion();
        LogHelper.info((String)jvmVersion);
        if (jvmVersion.startsWith("10.") || jvmVersion.startsWith("9.") || jvmVersion.startsWith("11.")) {
            String error = String.format("\u0423 \u0412\u0430\u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 Java %s. \u0414\u043b\u044f \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0439 \u0440\u0430\u0431\u043e\u0442\u044b \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 Java 8", JVMHelper.RUNTIME_MXBEAN.getVmVersion());
            LogHelper.error((String)error);
            if (Launcher.getConfig().isWarningMissArchJava) {
                JOptionPane.showMessageDialog(null, error);
            }
        }
    }

    @LauncherAPI
    public static boolean isLaunched() {
        return Launcher.LAUNCHED.get();
    }

    private static void launch(ClientProfile profile, Params params) throws Throwable {
        LinkedList<String> args = new LinkedList<String>();
        if (profile.getVersion().compareTo((Enum)ClientProfile.Version.MC164) >= 0) {
            ClientLauncher.addClientArgs(args, profile, params);
        } else {
            ClientLauncher.addClientLegacyArgs(args, profile, params);
            System.setProperty("minecraft.applet.TargetDirectory", params.clientDir.toString());
        }
        Collections.addAll(args, profile.getClientArgs());
        ArrayList<String> copy = new ArrayList<String>(args);
        int l = copy.size();
        for (int i = 0; i < l; ++i) {
            String s = (String)copy.get(i);
            if (i + 1 >= l || !"--accessToken".equals(s) && !"--session".equals(s)) continue;
            copy.set(i + 1, "censored");
        }
        LogHelper.debug((String)("Args: " + copy));
        Class mainClass = classLoader.loadClass(profile.getMainClass());
        MethodHandle mainMethod = MethodHandles.publicLookup().findStatic(mainClass, "main", MethodType.methodType(Void.TYPE, String[].class));
        Launcher.LAUNCHED.set(true);
        JVMHelper.fullGC();
        mainMethod.invoke(args.toArray(new String[0]));
    }

    @LauncherAPI
    public static Process launch(HashedDir assetHDir, HashedDir clientHDir, ClientProfile profile, Params params, boolean pipeOutput) throws Throwable {
        ProcessBuilder builder;
        String pathLauncher;
        Path javaBin;
        LogHelper.debug((String)"Writing ClientLauncher params");
        ClientLauncherContext context = new ClientLauncherContext();
        clientStarted = false;
        if (writeParamsThread != null && writeParamsThread.isAlive()) {
            writeParamsThread.interrupt();
        }
        writeParamsThread = CommonHelper.newThread((String)"Client params writter", (boolean)true, () -> {
            try (ServerSocket socket = new ServerSocket();){
                socket.setReuseAddress(true);
                socket.setSoTimeout(30000);
                socket.bind(new InetSocketAddress(SOCKET_HOST, SOCKET_PORT));
                Socket client = socket.accept();
                if (process == null) {
                    LogHelper.error((String)"Process is null");
                    return;
                }
                if (!process.isAlive()) {
                    LogHelper.error((String)"Process is not alive");
                    JOptionPane.showMessageDialog(null, "Client Process crashed", "Launcher", 0);
                    return;
                }
                try (HOutput output = new HOutput(client.getOutputStream());){
                    params.write(output);
                    output.writeString(Launcher.gsonManager.gson.toJson((Object)profile), 0);
                    assetHDir.write(output);
                    clientHDir.write(output);
                }
                clientStarted = true;
            }
            catch (IOException e) {
                LogHelper.error((Throwable)e);
            }
        });
        writeParamsThread.start();
        ClientLauncher.checkJVMBitsAndVersion();
        LogHelper.debug((String)"Resolving JVM binary");
        context.javaBin = javaBin = LauncherGuardManager.getGuardJavaBinPath();
        context.clientProfile = profile;
        context.playerProfile = params.pp;
        context.args.add(javaBin.toString());
        context.args.add(MAGICAL_INTEL_OPTION);
        if (params.ram > 0 && params.ram <= FunctionalBridge.getJVMTotalMemory()) {
            context.args.add("-Xms" + params.ram + 'M');
            context.args.add("-Xmx" + params.ram + 'M');
        }
        context.args.add(JVMHelper.jvmProperty((String)"launcher.debug", (String)Boolean.toString(LogHelper.isDebugEnabled())));
        context.args.add(JVMHelper.jvmProperty((String)"launcher.stacktrace", (String)Boolean.toString(LogHelper.isStacktraceEnabled())));
        context.args.add(JVMHelper.jvmProperty((String)"launcher.dev", (String)Boolean.toString(LogHelper.isDevEnabled())));
        context.args.add(JVMHelper.jvmProperty((String)"launcher.noJAnsi", (String)"true"));
        JVMHelper.addSystemPropertyToArgs(context.args, (String)"launcher.customdir");
        JVMHelper.addSystemPropertyToArgs(context.args, (String)"launcher.usecustomdir");
        JVMHelper.addSystemPropertyToArgs(context.args, (String)"launcher.useoptdir");
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE && JVMHelper.OS_VERSION.startsWith("10.")) {
            LogHelper.debug((String)"MustDie 10 fix is applied");
            context.args.add(JVMHelper.jvmProperty((String)"os.name", (String)"Windows 10"));
            context.args.add(JVMHelper.jvmProperty((String)"os.version", (String)"10.0"));
        }
        context.pathLauncher = pathLauncher = IOHelper.getCodeSource(ClientLauncher.class).toString();
        Collections.addAll(context.args, "-Djdk.attach.allowAttachSelf");
        Collections.addAll(context.args, profile.getJvmArgs());
        profile.pushOptionalJvmArgs(context.args);
        Collections.addAll(context.args, "-Djava.library.path=".concat(params.clientDir.resolve(NATIVES_DIR).toString()));
        Collections.addAll(context.args, "-javaagent:".concat(pathLauncher));
        LauncherGuardManager.guard.addCustomParams(context);
        Collections.addAll(context.args, ClientLauncher.class.getName());
        LogHelper.debug((String)("Commandline: " + context.args));
        LogHelper.debug((String)"Launching client instance");
        context.builder = builder = new ProcessBuilder(context.args);
        LauncherGuardManager.guard.addCustomEnv(context);
        EnvHelper.addEnv((ProcessBuilder)builder);
        builder.directory(params.clientDir.toFile());
        builder.inheritIO();
        if (pipeOutput) {
            builder.redirectErrorStream(true);
            builder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        }
        process = builder.start();
        if (!pipeOutput) {
            for (int i = 0; i < 50; ++i) {
                if (!process.isAlive()) {
                    int exitCode = process.exitValue();
                    LogHelper.error((String)"Process exit code %d", (Object[])new Object[]{exitCode});
                    if (writeParamsThread == null || !writeParamsThread.isAlive()) break;
                    writeParamsThread.interrupt();
                    break;
                }
                if (clientStarted) break;
                Thread.sleep(200L);
            }
            if (!clientStarted) {
                LogHelper.error((String)"Client did not start properly. Enable debug mode for more information");
            }
        }
        clientStarted = false;
        return process;
    }

    @LauncherAPI
    public static void main(String ... args) throws Throwable {
        HashedDir clientHDir;
        HashedDir assetHDir;
        ClientProfile profile;
        Params params;
        LauncherEngine engine = LauncherEngine.clientInstance();
        Launcher.modulesManager = new ClientModuleManager(engine);
        LauncherConfig.getAutogenConfig().initModules();
        ClientLauncher.initGson();
        Launcher.modulesManager.preInitModules();
        JVMHelper.verifySystemProperties(ClientLauncher.class, (boolean)true);
        EnvHelper.checkDangerousParams();
        JVMHelper.checkStackTrace(ClientLauncher.class);
        LogHelper.printVersion((String)"Client Launcher");
        if (engine.runtimeProvider == null) {
            engine.runtimeProvider = new JSRuntimeProvider();
        }
        engine.runtimeProvider.init(true);
        engine.runtimeProvider.preLoad();
        HWIDProvider.registerHWIDs();
        LauncherGuardManager.initGuard(true);
        LogHelper.debug((String)"Reading ClientLauncher params");
        try {
            Socket socket = IOHelper.newSocket();
            Object object = null;
            try {
                socket.connect(new InetSocketAddress(SOCKET_HOST, SOCKET_PORT));
                try (HInput input = new HInput(socket.getInputStream());){
                    params = new Params(input);
                    profile = (ClientProfile)Launcher.gsonManager.gson.fromJson(input.readString(0), ClientProfile.class);
                    assetHDir = new HashedDir(input);
                    clientHDir = new HashedDir(input);
                }
            }
            catch (Throwable input) {
                object = input;
                throw input;
            }
            finally {
                if (socket != null) {
                    if (object != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable input) {
                            ((Throwable)object).addSuppressed(input);
                        }
                    } else {
                        socket.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            LogHelper.error((Throwable)ex);
            System.exit(-98);
            return;
        }
        Launcher.profile = profile;
        playerProfile = params.pp;
        Request.setSession((long)params.session);
        ClientLauncher.checkJVMBitsAndVersion();
        Launcher.modulesManager.initModules();
        LogHelper.debug((String)"Verifying ClientLauncher sign and classpath");
        LinkedList<Path> classPath = ClientLauncher.resolveClassPathList(params.clientDir, profile.getClassPath());
        for (Path classpathURL : classPath) {
            LauncherAgent.addJVMClassPath(classpathURL.toAbsolutePath().toString());
        }
        profile.pushOptionalClassPath(cp -> {
            LinkedList<Path> optionalClassPath = ClientLauncher.resolveClassPathList(params.clientDir, cp);
            for (Path classpathURL : optionalClassPath) {
                LauncherAgent.addJVMClassPath(classpathURL.toAbsolutePath().toString());
            }
        });
        URL[] classpathurls = ClientLauncher.resolveClassPath(params.clientDir, profile.getClassPath());
        classLoader = new PublicURLClassLoader(classpathurls, ClassLoader.getSystemClassLoader());
        Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
        ClientLauncher.classLoader.nativePath = params.clientDir.resolve(NATIVES_DIR).toString();
        PublicURLClassLoader.systemclassloader = classLoader;
        boolean digest = !profile.isUpdateFastCheck();
        LogHelper.debug((String)"Restore sessions");
        RestoreSessionRequest request = new RestoreSessionRequest(Request.getSession());
        request.request();
        Request.service.reconnectCallback = () -> {
            LogHelper.debug((String)"WebSocket connect closed. Try reconnect");
            try {
                Request.service.open();
                LogHelper.debug((String)"Connect to %s", (Object[])new Object[]{Launcher.getConfig().address});
            }
            catch (Exception e) {
                LogHelper.error((Throwable)e);
                throw new RequestException(String.format("Connect error: %s", e.getMessage() != null ? e.getMessage() : "null"));
            }
            try {
                RestoreSessionRequest request1 = new RestoreSessionRequest(Request.getSession());
                request1.request();
            }
            catch (Exception e) {
                LogHelper.error((Throwable)e);
            }
        };
        LogHelper.debug((String)"Starting JVM and client WatchService");
        FileNameMatcher assetMatcher = profile.getAssetUpdateMatcher();
        FileNameMatcher clientMatcher = profile.getClientUpdateMatcher();
        try (DirWatcher assetWatcher = new DirWatcher(params.assetDir, assetHDir, assetMatcher, digest);
             DirWatcher clientWatcher = new DirWatcher(params.clientDir, clientHDir, clientMatcher, digest);){
            Launcher.profile.pushOptionalFile(clientHDir, false);
            Launcher.modulesManager.postInitModules();
            CommonHelper.newThread((String)"Asset Directory Watcher", (boolean)true, (Runnable)assetWatcher).start();
            CommonHelper.newThread((String)"Client Directory Watcher", (boolean)true, (Runnable)clientWatcher).start();
            ClientLauncher.verifyHDir(params.assetDir, assetHDir, assetMatcher, digest);
            ClientLauncher.verifyHDir(params.clientDir, clientHDir, clientMatcher, digest);
            ClientLauncher.launch(profile, params);
        }
    }

    private static URL[] resolveClassPath(Path clientDir, String ... classPath) throws IOException {
        return (URL[])ClientLauncher.resolveClassPathStream(clientDir, classPath).map(IOHelper::toURL).toArray(URL[]::new);
    }

    private static LinkedList<Path> resolveClassPathList(Path clientDir, String ... classPath) throws IOException {
        return ClientLauncher.resolveClassPathStream(clientDir, classPath).collect(Collectors.toCollection(LinkedList::new));
    }

    private static Stream<Path> resolveClassPathStream(Path clientDir, String ... classPath) throws IOException {
        Stream.Builder<Path> builder = Stream.builder();
        for (String classPathEntry : classPath) {
            Path path = clientDir.resolve(IOHelper.toPath((String)classPathEntry));
            if (IOHelper.isDir((Path)path)) {
                IOHelper.walk((Path)path, (FileVisitor)new ClassPathFileVisitor(builder), (boolean)false);
                continue;
            }
            builder.accept(path);
        }
        return builder.build();
    }

    private static void initGson() {
        Launcher.gsonManager = new ClientGsonManager();
        Launcher.gsonManager.initGson();
    }

    @LauncherAPI
    public static void setProfile(ClientProfile profile) {
        Launcher.profile = profile;
        LogHelper.debug((String)"New Profile name: %s", (Object[])new Object[]{profile.getTitle()});
    }

    public static void verifyHDir(Path dir, HashedDir hdir, FileNameMatcher matcher, boolean digest) throws IOException {
        HashedDir currentHDir = new HashedDir(dir, matcher, true, digest);
        HashedDir.Diff diff = hdir.diff(currentHDir, matcher);
        if (!diff.isSame()) {
            throw new SecurityException(String.format("Forbidden modification: '%s'", IOHelper.getFileName((Path)dir)));
        }
    }

    private ClientLauncher() {
    }

    static {
        BIN_POSIX_PERMISSIONS = Collections.unmodifiableSet(EnumSet.of(PosixFilePermission.OWNER_READ, new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE}));
        NATIVES_DIR = IOHelper.toPath((String)"natives");
        RESOURCEPACKS_DIR = IOHelper.toPath((String)"resourcepacks");
        process = null;
        clientStarted = false;
    }

    public static class ClientUserProperties {
        @LauncherAPI
        String[] skinURL;
        @LauncherAPI
        String[] skinDigest;
        @LauncherAPI
        String[] cloakURL;
        @LauncherAPI
        String[] cloakDigest;
    }

    public static final class Params
    extends StreamObject {
        @LauncherAPI
        public final Path assetDir;
        @LauncherAPI
        public final Path clientDir;
        @LauncherAPI
        public final PlayerProfile pp;
        @LauncherAPI
        public final String accessToken;
        @LauncherAPI
        public final boolean autoEnter;
        @LauncherAPI
        public final boolean fullScreen;
        @LauncherAPI
        public final int ram;
        @LauncherAPI
        public final int width;
        @LauncherAPI
        public final int height;
        @LauncherAPI
        public final long session;

        @LauncherAPI
        public Params(byte[] launcherDigest, Path assetDir, Path clientDir, PlayerProfile pp, String accessToken, boolean autoEnter, boolean fullScreen, int ram, int width, int height) {
            this.assetDir = assetDir;
            this.clientDir = clientDir;
            this.pp = pp;
            this.accessToken = SecurityHelper.verifyToken((String)accessToken);
            this.autoEnter = autoEnter;
            this.fullScreen = fullScreen;
            this.ram = ram;
            this.width = width;
            this.height = height;
            this.session = Request.getSession();
        }

        @LauncherAPI
        public Params(HInput input) throws Exception {
            this.session = input.readLong();
            this.assetDir = IOHelper.toPath((String)input.readString(0));
            this.clientDir = IOHelper.toPath((String)input.readString(0));
            this.pp = new PlayerProfile(input);
            byte[] encryptedAccessToken = input.readByteArray(2048);
            String accessTokenD = new String(SecurityHelper.decrypt((byte[])Launcher.getConfig().secretKeyClient.getBytes(), (byte[])encryptedAccessToken));
            this.accessToken = SecurityHelper.verifyToken((String)accessTokenD);
            this.autoEnter = input.readBoolean();
            this.fullScreen = input.readBoolean();
            this.ram = input.readVarInt();
            this.width = input.readVarInt();
            this.height = input.readVarInt();
        }

        public void write(HOutput output) throws IOException {
            output.writeLong(this.session);
            output.writeString(this.assetDir.toString(), 0);
            output.writeString(this.clientDir.toString(), 0);
            this.pp.write(output);
            try {
                output.writeByteArray(SecurityHelper.encrypt((byte[])Launcher.getConfig().secretKeyClient.getBytes(), (byte[])this.accessToken.getBytes()), 2048);
            }
            catch (Exception e) {
                LogHelper.error((Throwable)e);
            }
            output.writeBoolean(this.autoEnter);
            output.writeBoolean(this.fullScreen);
            output.writeVarInt(this.ram);
            output.writeVarInt(this.width);
            output.writeVarInt(this.height);
        }
    }

    private static final class ClassPathFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Stream.Builder<Path> result;

        private ClassPathFileVisitor(Stream.Builder<Path> result) {
            this.result = result;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (IOHelper.hasExtension((Path)file, (String)"jar") || IOHelper.hasExtension((Path)file, (String)"zip")) {
                this.result.accept(file);
            }
            return super.visitFile(file, attrs);
        }
    }
}

