/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.managers;

import java.io.IOException;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.console.FeatureCommand;
import pro.gravit.launcher.console.UnlockCommand;
import pro.gravit.launcher.console.admin.ExecCommand;
import pro.gravit.launcher.console.admin.LogListenerCommand;
import pro.gravit.launcher.console.store.CopyStoreDirCommand;
import pro.gravit.launcher.console.store.LinkStoreDirCommand;
import pro.gravit.launcher.console.store.StoreListCommand;
import pro.gravit.utils.command.BaseCommandCategory;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.CommandCategory;
import pro.gravit.utils.command.CommandHandler;
import pro.gravit.utils.command.JLineCommandHandler;
import pro.gravit.utils.command.StdCommandHandler;
import pro.gravit.utils.command.basic.ClearCommand;
import pro.gravit.utils.command.basic.DebugCommand;
import pro.gravit.utils.command.basic.GCCommand;
import pro.gravit.utils.command.basic.HelpCommand;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.LogHelper;

public class ConsoleManager {
    public static CommandHandler handler;
    public static Thread thread;
    public static boolean isConsoleUnlock;

    public static void initConsole() throws IOException {
        JLineCommandHandler localCommandHandler;
        try {
            Class.forName("org.jline.terminal.Terminal");
            localCommandHandler = new JLineCommandHandler();
            LogHelper.info((String)"JLine2 terminal enabled");
        }
        catch (ClassNotFoundException ignored) {
            localCommandHandler = new StdCommandHandler(true);
            LogHelper.warning((String)"JLine2 isn't in classpath, using std");
        }
        handler = localCommandHandler;
        ConsoleManager.registerCommands();
        thread = CommonHelper.newThread((String)"Launcher Console", (boolean)true, (Runnable)handler);
        thread.start();
    }

    public static void registerCommands() {
        handler.registerCommand("help", (Command)new HelpCommand(handler));
        handler.registerCommand("gc", (Command)new GCCommand());
        handler.registerCommand("clear", (Command)new ClearCommand(handler));
        handler.registerCommand("unlock", (Command)new UnlockCommand());
    }

    public static boolean checkUnlockKey(String key) {
        return key.equals(Launcher.getConfig().oemUnlockKey);
    }

    public static void unlock() {
        handler.registerCommand("debug", (Command)new DebugCommand());
        handler.registerCommand("feature", (Command)new FeatureCommand());
        BaseCommandCategory admin = new BaseCommandCategory();
        admin.registerCommand("exec", (Command)new ExecCommand());
        admin.registerCommand("logListen", (Command)new LogListenerCommand());
        handler.registerCategory(new CommandHandler.Category((CommandCategory)admin, "admin", "Server admin commands"));
        BaseCommandCategory store = new BaseCommandCategory();
        store.registerCommand("storeList", (Command)new StoreListCommand());
        store.registerCommand("copyStoreDir", (Command)new CopyStoreDirCommand());
        store.registerCommand("linkStoreDir", (Command)new LinkStoreDirCommand());
        handler.registerCategory(new CommandHandler.Category((CommandCategory)admin, "store", "Store admin commands"));
        isConsoleUnlock = true;
    }

    static {
        isConsoleUnlock = false;
    }
}

