/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.nio.file.Path;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import pro.gravit.launcher.LauncherAPI;
import pro.gravit.launcher.client.ClientLauncher;
import pro.gravit.launcher.client.UserSettings;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.guard.LauncherGuardManager;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.hwid.HWID;
import pro.gravit.launcher.hwid.OshiHWIDProvider;
import pro.gravit.launcher.managers.ConsoleManager;
import pro.gravit.launcher.managers.HasherManager;
import pro.gravit.launcher.managers.HasherStore;
import pro.gravit.launcher.request.Request;
import pro.gravit.utils.helper.LogHelper;

public class FunctionalBridge {
    @LauncherAPI
    public static ScheduledExecutorService threadPool = Executors.newScheduledThreadPool(0);
    @LauncherAPI
    public static OshiHWIDProvider hwidProvider;
    @LauncherAPI
    public static AtomicReference<HWID> hwid;
    @LauncherAPI
    public static Thread getHWID;
    private static long cachedMemorySize;

    @LauncherAPI
    public static HashedDirRunnable offlineUpdateRequest(String dirName, Path dir, HashedDir hdir, FileNameMatcher matcher, boolean digest) {
        return () -> {
            if (hdir == null) {
                Request.requestError((String)String.format("\u0414\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0438 '%s' \u043d\u0435\u0442 \u0432 \u043a\u044d\u0448\u0435", dirName));
            }
            ClientLauncher.verifyHDir(dir, hdir, matcher, digest);
            return hdir;
        };
    }

    @LauncherAPI
    public static void startTask(Runnable task) {
        threadPool.execute(task);
    }

    @LauncherAPI
    public static HWID getHWID() {
        HWID hhwid = hwid.get();
        if (hhwid == null) {
            if (hwidProvider == null) {
                hwidProvider = new OshiHWIDProvider();
            }
            hwid.set(hwidProvider.getHWID());
        }
        return hhwid;
    }

    @LauncherAPI
    public static long getTotalMemory() {
        if (cachedMemorySize > 0L) {
            return cachedMemorySize;
        }
        if (hwidProvider == null) {
            hwidProvider = new OshiHWIDProvider();
        }
        cachedMemorySize = hwidProvider.getTotalMemory() >> 20;
        return cachedMemorySize;
    }

    @LauncherAPI
    public static int getClientJVMBits() {
        return LauncherGuardManager.guard.getClientJVMBits();
    }

    @LauncherAPI
    public static long getJVMTotalMemory() {
        if (FunctionalBridge.getClientJVMBits() == 32) {
            return Math.min(FunctionalBridge.getTotalMemory(), 1536L);
        }
        return FunctionalBridge.getTotalMemory();
    }

    @LauncherAPI
    public static HasherStore getDefaultHasherStore() {
        return HasherManager.getDefaultStore();
    }

    @LauncherAPI
    public static void registerUserSettings(String typename, Class<? extends UserSettings> clazz) {
        UserSettings.providers.register(typename, clazz);
    }

    @LauncherAPI
    public static void close() throws Exception {
        threadPool.awaitTermination(2L, TimeUnit.SECONDS);
    }

    @LauncherAPI
    public static void setAuthParams(AuthRequestEvent event) {
        if (event.session != 0L) {
            Request.setSession((long)event.session);
        }
        LauncherGuardManager.guard.setProtectToken(event.protectToken);
    }

    @LauncherAPI
    public static void evalCommand(String cmd) {
        ConsoleManager.handler.eval(cmd, false);
    }

    @LauncherAPI
    public static void addPlainOutput(LogHelper.Output output) {
        LogHelper.addOutput((LogHelper.Output)output, (LogHelper.OutputTypes)LogHelper.OutputTypes.PLAIN);
    }

    @LauncherAPI
    public static String getLauncherVersion() {
        return String.format("GravitLauncher v%d.%d.%d build %d", 5, 0, 7, 1);
    }

    static {
        hwid = new AtomicReference();
        getHWID = null;
        cachedMemorySize = -1L;
    }

    @FunctionalInterface
    public static interface HashedDirRunnable {
        public HashedDir run() throws Exception;
    }
}

