/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.console.store;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import pro.gravit.launcher.NewLauncherSettings;
import pro.gravit.launcher.managers.SettingsManager;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.helper.LogHelper;

public class LinkStoreDirCommand
extends Command {
    public String getArgsDescription() {
        return "[index]";
    }

    public String getUsageDescription() {
        return "Create symlink to GravitLauncherStore directory";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 1);
        int ind = 1;
        int index = Integer.valueOf(args[0]);
        for (NewLauncherSettings.HashedStoreEntry e : SettingsManager.settings.lastHDirs) {
            if (ind == index) {
                LogHelper.info((String)"Copy [%d] FullPath: %s name: %s", (Object[])new Object[]{ind, e.fullPath, e.name});
                Path path = Paths.get(e.fullPath, new String[0]);
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    LogHelper.error((String)"Directory %s not found", (Object[])new Object[]{path.toAbsolutePath().toString()});
                    return;
                }
                Path target = Paths.get(SettingsManager.settings.updatesDirPath, new String[0]).resolve(e.name);
                if (Files.exists(target, new LinkOption[0])) {
                    LogHelper.error((String)"Directory %s already exists", (Object[])new Object[]{target.toAbsolutePath().toString()});
                    return;
                }
                Files.createSymbolicLink(path, target, new FileAttribute[0]);
            }
            ++ind;
        }
    }
}

