/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.hwid;

import java.net.NetworkInterface;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import pro.gravit.launcher.hwid.HWID;
import pro.gravit.launcher.hwid.LauncherHWIDInterface;
import pro.gravit.launcher.hwid.OshiHWID;
import pro.gravit.utils.helper.LogHelper;

public class OshiHWIDProvider
implements LauncherHWIDInterface {
    public SystemInfo systemInfo;
    public HardwareAbstractionLayer hardware;
    public boolean noHWID;

    public OshiHWIDProvider() {
        try {
            this.systemInfo = new SystemInfo();
            this.noHWID = false;
        }
        catch (Throwable e) {
            LogHelper.error((Throwable)e);
            this.noHWID = true;
        }
    }

    public String getSerial() {
        try {
            if (this.hardware == null) {
                this.hardware = this.systemInfo.getHardware();
            }
            return this.hardware.getComputerSystem().getSerialNumber();
        }
        catch (Exception e) {
            LogHelper.error((Throwable)e);
            return "";
        }
    }

    public String getProcessorID() {
        try {
            if (this.hardware == null) {
                this.hardware = this.systemInfo.getHardware();
            }
            return this.hardware.getProcessor().getProcessorID();
        }
        catch (Exception e) {
            LogHelper.error((Throwable)e);
            return "";
        }
    }

    public String getHWDisk() {
        try {
            if (this.hardware == null) {
                this.hardware = this.systemInfo.getHardware();
            }
            HWDiskStore store = null;
            long size = 0L;
            for (HWDiskStore s : this.hardware.getDiskStores()) {
                if (size >= s.getSize()) continue;
                store = s;
                size = s.getSize();
            }
            return store == null ? "" : store.getSerial();
        }
        catch (Exception e) {
            LogHelper.error((Throwable)e);
            return "";
        }
    }

    public String getMacAddr() {
        for (NetworkIF networkIF : this.hardware.getNetworkIFs()) {
            if (networkIF.getNetworkInterface().isVirtual()) continue;
            for (String ipv4 : networkIF.getIPv4addr()) {
                if (ipv4.startsWith("127.") || ipv4.startsWith("10.")) continue;
                return networkIF.getMacaddr();
            }
        }
        return "";
    }

    public long getTotalMemory() {
        if (this.noHWID) {
            return 0x40000000L;
        }
        if (this.hardware == null) {
            this.hardware = this.systemInfo.getHardware();
        }
        return this.hardware.getMemory().getTotal();
    }

    public long getAvailableMemory() {
        if (this.noHWID) {
            return -1L;
        }
        if (this.hardware == null) {
            this.hardware = this.systemInfo.getHardware();
        }
        return this.hardware.getMemory().getAvailable();
    }

    public void printHardwareInformation() {
        try {
            if (this.hardware == null) {
                this.hardware = this.systemInfo.getHardware();
            }
            ComputerSystem computerSystem = this.hardware.getComputerSystem();
            LogHelper.debug((String)"ComputerSystem Model: %s Serial: %s", (Object[])new Object[]{computerSystem.getModel(), computerSystem.getSerialNumber()});
            for (HWDiskStore hWDiskStore : this.hardware.getDiskStores()) {
                LogHelper.debug((String)"HWDiskStore Serial: %s Model: %s Size: %d", (Object[])new Object[]{hWDiskStore.getSerial(), hWDiskStore.getModel(), hWDiskStore.getSize()});
            }
            for (HWDiskStore hWDiskStore : this.hardware.getUsbDevices(true)) {
                LogHelper.debug((String)"USBDevice Serial: %s Name: %s", (Object[])new Object[]{hWDiskStore.getSerialNumber(), hWDiskStore.getName()});
            }
            for (HWDiskStore hWDiskStore : this.hardware.getNetworkIFs()) {
                LogHelper.debug((String)"Network Interface: %s mac: %s", (Object[])new Object[]{hWDiskStore.getName(), hWDiskStore.getMacaddr()});
                NetworkInterface network = hWDiskStore.getNetworkInterface();
                if (network.isLoopback() || network.isVirtual()) continue;
                LogHelper.debug((String)"Network Interface display: %s name: %s", (Object[])new Object[]{network.getDisplayName(), network.getName()});
                for (String ipv4 : hWDiskStore.getIPv4addr()) {
                    if (ipv4.startsWith("127.") || ipv4.startsWith("10.")) continue;
                    LogHelper.subDebug((String)"IPv4: %s", (Object[])new Object[]{ipv4});
                }
            }
            CentralProcessor processor = this.hardware.getProcessor();
            LogHelper.debug((String)"Processor Model: %s ID: %s", (Object[])new Object[]{processor.getModel(), processor.getProcessorID()});
        }
        catch (Throwable e) {
            LogHelper.error((Throwable)e);
        }
    }

    public HWID getHWID() {
        OshiHWID hwid = new OshiHWID();
        hwid.serialNumber = this.getSerial();
        hwid.totalMemory = this.getTotalMemory();
        hwid.HWDiskSerial = this.getHWDisk();
        hwid.processorID = this.getProcessorID();
        hwid.macAddr = this.getMacAddr();
        this.printHardwareInformation();
        return hwid;
    }
}

