/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.utils;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import pro.gravit.launcher.LauncherAPI;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.hasher.HashedEntry;
import pro.gravit.launcher.hasher.HashedFile;
import pro.gravit.launcher.utils.NativeJVMHalt;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public final class DirWatcher
implements Runnable,
AutoCloseable {
    public static final boolean FILE_TREE_SUPPORTED = JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE;
    private static final WatchEvent.Kind<?>[] KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE};
    private final Path dir;
    private final HashedDir hdir;
    private final FileNameMatcher matcher;
    private final WatchService service;
    private final boolean digest;

    private static void handleError(Throwable e) {
        LogHelper.error((Throwable)e);
        NativeJVMHalt.haltA(-123);
    }

    private static Deque<String> toPath(Iterable<Path> path) {
        LinkedList<String> result = new LinkedList<String>();
        for (Path pe : path) {
            result.add(pe.toString());
        }
        return result;
    }

    @LauncherAPI
    public DirWatcher(Path dir, HashedDir hdir, FileNameMatcher matcher, boolean digest) throws IOException {
        this.dir = Objects.requireNonNull(dir, "dir");
        this.hdir = Objects.requireNonNull(hdir, "hdir");
        this.matcher = matcher;
        this.digest = digest;
        this.service = dir.getFileSystem().newWatchService();
        IOHelper.walk((Path)dir, (FileVisitor)new RegisterFileVisitor(), (boolean)true);
        LogHelper.subInfo((String)"DirWatcher %s", (Object[])new Object[]{dir.toString()});
    }

    @Override
    @LauncherAPI
    public void close() throws IOException {
        this.service.close();
    }

    private void processKey(WatchKey key) throws IOException {
        Path watchDir = (Path)key.watchable();
        for (WatchEvent<?> event : key.pollEvents()) {
            HashedEntry entry;
            WatchEvent.Kind<?> kind = event.kind();
            if (kind.equals(StandardWatchEventKinds.OVERFLOW)) {
                if (Boolean.getBoolean("launcher.dirwatcher.ignoreOverflows")) continue;
                throw new IOException("Overflow");
            }
            Path path = watchDir.resolve((Path)event.context());
            Deque<String> stringPath = DirWatcher.toPath(this.dir.relativize(path));
            if (this.matcher != null && !this.matcher.shouldVerify(stringPath) || kind.equals(StandardWatchEventKinds.ENTRY_MODIFY) && (entry = this.hdir.resolve(stringPath)) != null && (entry.getType() != HashedEntry.Type.FILE || ((HashedFile)entry).isSame(path, this.digest))) continue;
            throw new SecurityException(String.format("Forbidden modification (%s, %d times): '%s'", kind, event.count(), path));
        }
        key.reset();
    }

    private void processLoop() throws IOException, InterruptedException {
        LogHelper.debug((String)"WatchService start processing");
        while (!Thread.interrupted()) {
            this.processKey(this.service.take());
        }
        LogHelper.debug((String)"WatchService closed");
    }

    @Override
    @LauncherAPI
    public void run() {
        try {
            this.processLoop();
        }
        catch (InterruptedException | ClosedWatchServiceException ignored) {
            LogHelper.debug((String)"WatchService closed 2");
        }
        catch (Throwable exc) {
            DirWatcher.handleError(exc);
        }
    }

    private final class RegisterFileVisitor
    extends SimpleFileVisitor<Path> {
        private RegisterFileVisitor() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            FileVisitResult result = super.preVisitDirectory(dir, attrs);
            if (DirWatcher.this.dir.equals(dir)) {
                dir.register(DirWatcher.this.service, KINDS);
                return result;
            }
            dir.register(DirWatcher.this.service, KINDS);
            return result;
        }
    }
}

