/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherAPI;
import pro.gravit.launcher.LauncherAgent;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.client.ClientModuleManager;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.FunctionalBridge;
import pro.gravit.launcher.client.LauncherUpdateController;
import pro.gravit.launcher.client.events.ClientEngineInitPhase;
import pro.gravit.launcher.client.events.ClientPreGuiPhase;
import pro.gravit.launcher.guard.LauncherGuardManager;
import pro.gravit.launcher.gui.JSRuntimeProvider;
import pro.gravit.launcher.gui.RuntimeProvider;
import pro.gravit.launcher.hwid.HWIDProvider;
import pro.gravit.launcher.managers.ClientGsonManager;
import pro.gravit.launcher.managers.ClientHookManager;
import pro.gravit.launcher.managers.ConsoleManager;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.events.PreConfigPhase;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.auth.RestoreSessionRequest;
import pro.gravit.launcher.request.update.UpdateRequest;
import pro.gravit.launcher.request.websockets.StandartClientWebSocketService;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class LauncherEngine {
    private final AtomicBoolean started = new AtomicBoolean(false);
    public RuntimeProvider runtimeProvider;
    public static ClientModuleManager modulesManager;

    public static void main(String ... args) throws Throwable {
        JVMHelper.checkStackTrace(LauncherEngine.class);
        JVMHelper.verifySystemProperties(Launcher.class, (boolean)true);
        EnvHelper.checkDangerousParams();
        LogHelper.printVersion((String)"Launcher");
        LogHelper.printLicense((String)"Launcher");
        modulesManager = new ClientModuleManager();
        LauncherConfig.getAutogenConfig().initModules();
        modulesManager.initModules(null);
        LauncherEngine.initGson(modulesManager);
        ConsoleManager.initConsole();
        HWIDProvider.registerHWIDs();
        modulesManager.invokeEvent((LauncherModule.Event)new PreConfigPhase());
        LauncherConfig config = Launcher.getConfig();
        if (config.environment.equals((Object)LauncherConfig.LauncherEnvironment.PROD) && !LauncherAgent.isStarted()) {
            throw new SecurityException("LauncherAgent must started");
        }
        long startTime = System.currentTimeMillis();
        try {
            new LauncherEngine().start(args);
        }
        catch (Exception e) {
            LogHelper.error((Throwable)e);
            return;
        }
        long endTime = System.currentTimeMillis();
        LogHelper.debug((String)"Launcher started in %dms", (Object[])new Object[]{endTime - startTime});
        System.exit(0);
    }

    public static void initGson(ClientModuleManager modulesManager) {
        Launcher.gsonManager = new ClientGsonManager(modulesManager);
        Launcher.gsonManager.initGson();
    }

    private LauncherEngine() {
    }

    @LauncherAPI
    public void start(String ... args) throws Throwable {
        ClientPreGuiPhase event = new ClientPreGuiPhase(null);
        modulesManager.invokeEvent(event);
        this.runtimeProvider = event.runtimeProvider;
        if (this.runtimeProvider == null) {
            this.runtimeProvider = new JSRuntimeProvider();
        }
        ClientHookManager.initGuiHook.hook((Object)this.runtimeProvider);
        this.runtimeProvider.init(false);
        if (Request.service == null) {
            String address = Launcher.getConfig().address;
            LogHelper.debug((String)"Start async connection to %s", (Object[])new Object[]{address});
            Request.service = StandartClientWebSocketService.initWebSockets((String)address, (boolean)true);
            Request.service.reconnectCallback = () -> {
                LogHelper.debug((String)"WebSocket connect closed. Try reconnect");
                try {
                    Request.service.open();
                    LogHelper.debug((String)"Connect to %s", (Object[])new Object[]{Launcher.getConfig().address});
                }
                catch (Exception e) {
                    LogHelper.error((Throwable)e);
                    throw new RequestException(String.format("Connect error: %s", e.getMessage() != null ? e.getMessage() : "null"));
                }
                try {
                    RestoreSessionRequest request1 = new RestoreSessionRequest(Request.getSession());
                    request1.request();
                }
                catch (Exception e) {
                    LogHelper.error((Throwable)e);
                }
            };
        }
        if (UpdateRequest.getController() == null) {
            UpdateRequest.setController((UpdateRequest.UpdateController)new LauncherUpdateController());
        }
        Objects.requireNonNull(args, "args");
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException("Launcher has been already started");
        }
        modulesManager.invokeEvent((LauncherModule.Event)new ClientEngineInitPhase(this));
        this.runtimeProvider.preLoad();
        LauncherGuardManager.initGuard(false);
        FunctionalBridge.getHWID = CommonHelper.newThread((String)"GetHWID Thread", (boolean)true, FunctionalBridge::getHWID);
        FunctionalBridge.getHWID.start();
        LogHelper.debug((String)"Dir: %s", (Object[])new Object[]{DirBridge.dir});
        this.runtimeProvider.run(args);
    }

    public static LauncherEngine clientInstance() {
        return new LauncherEngine();
    }
}

