/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import pro.gravit.launcher.LauncherAPI;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;

public class DirBridge {
    public static final String USE_CUSTOMDIR_PROPERTY = "launcher.usecustomdir";
    public static final String CUSTOMDIR_PROPERTY = "launcher.customdir";
    public static final String USE_OPTDIR_PROPERTY = "launcher.useoptdir";
    @LauncherAPI
    public static Path dir;
    @LauncherAPI
    public static Path dirStore;
    @LauncherAPI
    public static Path dirProjectStore;
    @LauncherAPI
    public static Path dirUpdates;
    @LauncherAPI
    public static Path defaultUpdatesDir;
    @LauncherAPI
    public static boolean useLegacyDir;

    @LauncherAPI
    public static void move(Path newDir) throws IOException {
        IOHelper.move((Path)dirUpdates, (Path)newDir);
        dirUpdates = newDir;
    }

    @LauncherAPI
    public static Path getAppDataDir() throws IOException {
        boolean isCustomDir = Boolean.getBoolean(System.getProperty(USE_CUSTOMDIR_PROPERTY, "false"));
        if (isCustomDir) {
            return Paths.get(System.getProperty(CUSTOMDIR_PROPERTY), new String[0]);
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
            boolean isOpt = Boolean.getBoolean(System.getProperty(USE_OPTDIR_PROPERTY, "false"));
            if (isOpt) {
                Path opt = Paths.get("/", new String[0]).resolve("opt");
                if (!IOHelper.isDir((Path)opt)) {
                    Files.createDirectories(opt, new FileAttribute[0]);
                }
                return opt;
            }
            Path local = IOHelper.HOME_DIR.resolve(".minecraftlauncher");
            if (!IOHelper.isDir((Path)local)) {
                Files.createDirectories(local, new FileAttribute[0]);
            }
            return local;
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE) {
            Path appdata = IOHelper.HOME_DIR.resolve("AppData").resolve("Roaming");
            if (!IOHelper.isDir((Path)appdata)) {
                Files.createDirectories(appdata, new FileAttribute[0]);
            }
            return appdata;
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MACOSX) {
            Path minecraft = IOHelper.HOME_DIR.resolve("minecraft");
            if (!IOHelper.isDir((Path)minecraft)) {
                Files.createDirectories(minecraft, new FileAttribute[0]);
            }
            return minecraft;
        }
        return IOHelper.HOME_DIR;
    }

    @LauncherAPI
    public static Path getLauncherDir(String projectname) throws IOException {
        return DirBridge.getAppDataDir().resolve(projectname);
    }

    @LauncherAPI
    public static Path getStoreDir(String projectname) throws IOException {
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
            return DirBridge.getAppDataDir().resolve("store");
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE) {
            return DirBridge.getAppDataDir().resolve("GravitLauncherStore");
        }
        return DirBridge.getAppDataDir().resolve("minecraftStore");
    }

    @LauncherAPI
    public static Path getProjectStoreDir(String projectname) throws IOException {
        return DirBridge.getStoreDir(projectname).resolve(projectname);
    }

    @LauncherAPI
    public static Path getGuardDir() {
        return dir.resolve("guard");
    }

    @LauncherAPI
    public static Path getLegacyLauncherDir(String projectname) {
        return IOHelper.HOME_DIR.resolve(projectname);
    }

    @LauncherAPI
    public static void setUseLegacyDir(boolean b) {
        useLegacyDir = b;
    }
}

