/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.managers;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import pro.gravit.launcher.NewLauncherSettings;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.config.JsonConfigurable;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.managers.ConsoleManager;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class SettingsManager
extends JsonConfigurable<NewLauncherSettings> {
    public static NewLauncherSettings settings;

    public SettingsManager() {
        super(NewLauncherSettings.class, DirBridge.dir.resolve("settings.json"));
    }

    public NewLauncherSettings getConfig() {
        return settings;
    }

    public NewLauncherSettings getDefaultConfig() {
        return new NewLauncherSettings();
    }

    public void setConfig(NewLauncherSettings config) {
        settings = config;
        if (SettingsManager.settings.consoleUnlockKey != null && !ConsoleManager.isConsoleUnlock && ConsoleManager.checkUnlockKey(SettingsManager.settings.consoleUnlockKey)) {
            ConsoleManager.unlock();
            LogHelper.info((String)"Console auto unlocked");
        }
    }

    public void loadHDirStore(Path storePath) throws IOException {
        Files.createDirectories(storePath, new FileAttribute[0]);
        IOHelper.walk((Path)storePath, (FileVisitor)new StoreFileVisitor(), (boolean)false);
    }

    public void saveHDirStore(Path storeProjectPath) throws IOException {
        Files.createDirectories(storeProjectPath, new FileAttribute[0]);
        for (NewLauncherSettings.HashedStoreEntry e : SettingsManager.settings.lastHDirs) {
            if (!e.needSave) continue;
            Path file = storeProjectPath.resolve(e.name.concat(".bin"));
            if (!Files.exists(file, new LinkOption[0])) {
                Files.createFile(file, new FileAttribute[0]);
            }
            try (HOutput output = new HOutput(IOHelper.newOutput((Path)file));){
                output.writeString(e.name, 128);
                output.writeString(e.fullPath, 1024);
                e.hdir.write(output);
            }
        }
    }

    public void loadHDirStore() throws IOException {
        this.loadHDirStore(DirBridge.dirStore);
    }

    public void saveHDirStore() throws IOException {
        this.saveHDirStore(DirBridge.dirProjectStore);
    }

    public static class StoreFileVisitor
    extends SimpleFileVisitor<Path> {
        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            try (HInput input = new HInput(IOHelper.newInput((Path)file));){
                String dirName = input.readString(128);
                String fullPath = input.readString(1024);
                HashedDir dir = new HashedDir(input);
                SettingsManager.settings.lastHDirs.add(new NewLauncherSettings.HashedStoreEntry(dir, dirName, fullPath));
            }
            catch (IOException e) {
                LogHelper.error((String)"Skip file %s exception: %s", (Object[])new Object[]{file.toAbsolutePath().toString(), e.getMessage()});
            }
            return super.visitFile(file, attrs);
        }
    }
}

