/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.IOException;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherAgent;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.LauncherTrustManager;
import pro.gravit.launcher.client.ClientLauncherCoreModule;
import pro.gravit.launcher.client.ClientLauncherEntryPoint;
import pro.gravit.launcher.client.ClientLauncherProcess;
import pro.gravit.launcher.client.ClientModuleManager;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.events.ClientEngineInitPhase;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.client.events.ClientPreGuiPhase;
import pro.gravit.launcher.guard.LauncherGuardInterface;
import pro.gravit.launcher.guard.LauncherGuardManager;
import pro.gravit.launcher.guard.LauncherNoGuard;
import pro.gravit.launcher.guard.LauncherWrapperGuard;
import pro.gravit.launcher.gui.NoRuntimeProvider;
import pro.gravit.launcher.gui.RuntimeProvider;
import pro.gravit.launcher.managers.ClientGsonManager;
import pro.gravit.launcher.managers.ConsoleManager;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.LauncherModulesManager;
import pro.gravit.launcher.modules.events.PreConfigPhase;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.RestoreSessionRequest;
import pro.gravit.launcher.request.websockets.StdWebSocketService;
import pro.gravit.launcher.utils.NativeJVMHalt;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class LauncherEngine {
    public static final AtomicBoolean IS_CLIENT = new AtomicBoolean(false);
    public static ClientLauncherProcess.ClientParams clientParams;
    public static LauncherGuardInterface guard;
    public static ClientModuleManager modulesManager;
    private final AtomicBoolean started = new AtomicBoolean(false);
    public RuntimeProvider runtimeProvider;
    public ECPublicKey publicKey;
    public ECPrivateKey privateKey;

    private LauncherEngine() {
    }

    public static X509Certificate[] getCertificates(Class<?> clazz) {
        Object[] signers = clazz.getSigners();
        if (signers == null) {
            return null;
        }
        return (X509Certificate[])Arrays.stream(signers).filter(c -> c instanceof X509Certificate).map(c -> (X509Certificate)c).toArray(X509Certificate[]::new);
    }

    public static void checkClass(Class<?> clazz) throws SecurityException {
        LauncherTrustManager trustManager = Launcher.getConfig().trustManager;
        if (trustManager == null) {
            return;
        }
        X509Certificate[] certificates = LauncherEngine.getCertificates(clazz);
        if (certificates == null) {
            throw new SecurityException(String.format("Class %s not signed", clazz.getName()));
        }
        try {
            trustManager.checkCertificate(certificates, (arg_0, arg_1, arg_2) -> ((LauncherTrustManager)trustManager).stdCertificateChecker(arg_0, arg_1, arg_2));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            throw new SecurityException(e);
        }
    }

    public static void exitLauncher(int code) {
        modulesManager.invokeEvent((LauncherModule.Event)new ClientExitPhase(code));
        try {
            System.exit(code);
        }
        catch (Throwable e) {
            NativeJVMHalt.haltA(code);
        }
    }

    public static void main(String ... args) throws Throwable {
        JVMHelper.checkStackTrace(LauncherEngine.class);
        JVMHelper.verifySystemProperties(Launcher.class, (boolean)true);
        EnvHelper.checkDangerousParams();
        LauncherEngine.verifyNoAgent();
        LogHelper.printVersion((String)"Launcher");
        LogHelper.printLicense((String)"Launcher");
        LauncherEngine.checkClass(LauncherEngine.class);
        LauncherEngine.checkClass(LauncherAgent.class);
        LauncherEngine.checkClass(ClientLauncherEntryPoint.class);
        modulesManager = new ClientModuleManager();
        modulesManager.loadModule(new ClientLauncherCoreModule());
        LauncherConfig.initModules((LauncherModulesManager)modulesManager);
        modulesManager.initModules(null);
        LauncherEngine.initGson(modulesManager);
        ConsoleManager.initConsole();
        modulesManager.invokeEvent((LauncherModule.Event)new PreConfigPhase());
        Launcher.getConfig();
        long startTime = System.currentTimeMillis();
        try {
            new LauncherEngine().start(args);
        }
        catch (Exception e) {
            LogHelper.error((Throwable)e);
            return;
        }
        long endTime = System.currentTimeMillis();
        LogHelper.debug((String)"Launcher started in %dms", (Object[])new Object[]{endTime - startTime});
        LauncherEngine.exitLauncher(0);
    }

    public static void initGson(ClientModuleManager modulesManager) {
        AuthRequest.registerProviders();
        OptionalAction.registerProviders();
        Launcher.gsonManager = new ClientGsonManager(modulesManager);
        Launcher.gsonManager.initGson();
    }

    public static void verifyNoAgent() {
        if (JVMHelper.RUNTIME_MXBEAN.getInputArguments().stream().filter(e -> e != null && !e.isEmpty()).anyMatch(e -> e.contains("javaagent"))) {
            throw new SecurityException("JavaAgent found");
        }
    }

    public static LauncherGuardInterface tryGetStdGuard() {
        switch (Launcher.getConfig().guardType) {
            case "no": {
                return new LauncherNoGuard();
            }
            case "wrapper": {
                return new LauncherWrapperGuard();
            }
        }
        return null;
    }

    public static LauncherEngine clientInstance() {
        return new LauncherEngine();
    }

    public void readKeys() throws IOException, InvalidKeySpecException {
        if (this.privateKey != null || this.publicKey != null) {
            return;
        }
        Path dir = DirBridge.dir;
        Path publicKeyFile = dir.resolve("public.key");
        Path privateKeyFile = dir.resolve("private.key");
        if (IOHelper.isFile((Path)publicKeyFile) && IOHelper.isFile((Path)privateKeyFile)) {
            LogHelper.info((String)"Reading EC keypair");
            this.publicKey = SecurityHelper.toPublicECKey((byte[])IOHelper.read((Path)publicKeyFile));
            this.privateKey = SecurityHelper.toPrivateECKey((byte[])IOHelper.read((Path)privateKeyFile));
        } else {
            LogHelper.info((String)"Generating EC keypair");
            KeyPair pair = SecurityHelper.genECKeyPair((SecureRandom)new SecureRandom());
            this.publicKey = (ECPublicKey)pair.getPublic();
            this.privateKey = (ECPrivateKey)pair.getPrivate();
            LogHelper.info((String)"Writing EC keypair list");
            IOHelper.write((Path)publicKeyFile, (byte[])this.publicKey.getEncoded());
            IOHelper.write((Path)privateKeyFile, (byte[])this.privateKey.getEncoded());
        }
    }

    public void start(String ... args) throws Throwable {
        guard = LauncherEngine.tryGetStdGuard();
        ClientPreGuiPhase event = new ClientPreGuiPhase(null);
        modulesManager.invokeEvent(event);
        this.runtimeProvider = event.runtimeProvider;
        if (this.runtimeProvider == null) {
            this.runtimeProvider = new NoRuntimeProvider();
        }
        this.runtimeProvider.init(false);
        if (Request.service == null) {
            String address = Launcher.getConfig().address;
            LogHelper.debug((String)"Start async connection to %s", (Object[])new Object[]{address});
            Request.service = StdWebSocketService.initWebSockets((String)address, (boolean)true);
            Request.service.reconnectCallback = () -> {
                LogHelper.debug((String)"WebSocket connect closed. Try reconnect");
                try {
                    Request.service.open();
                    LogHelper.debug((String)"Connect to %s", (Object[])new Object[]{Launcher.getConfig().address});
                }
                catch (Exception e) {
                    LogHelper.error((Throwable)e);
                    throw new RequestException(String.format("Connect error: %s", e.getMessage() != null ? e.getMessage() : "null"));
                }
                try {
                    RestoreSessionRequest request1 = new RestoreSessionRequest(Request.getSession());
                    request1.request();
                }
                catch (Exception e) {
                    LogHelper.error((Throwable)e);
                }
            };
        }
        Objects.requireNonNull(args, "args");
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException("Launcher has been already started");
        }
        this.readKeys();
        modulesManager.invokeEvent((LauncherModule.Event)new ClientEngineInitPhase(this));
        this.runtimeProvider.preLoad();
        LauncherGuardManager.initGuard(false);
        LogHelper.debug((String)"Dir: %s", (Object[])new Object[]{DirBridge.dir});
        this.runtimeProvider.run(args);
    }
}

