/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.Properties;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.client.ClientModuleManager;
import pro.gravit.launcher.modules.LauncherModulesManager;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class ClientLauncherWrapper {
    public static final String MAGIC_ARG = "-Djdk.attach.allowAttachSelf";
    public static final String WAIT_PROCESS_PROPERTY = "launcher.waitProcess";
    public static final String NO_JAVA_CHECK_PROPERTY = "launcher.noJavaCheck";
    public static boolean noJavaCheck = Boolean.getBoolean("launcher.noJavaCheck");
    public static boolean waitProcess = Boolean.getBoolean("launcher.waitProcess");

    public static void main(String[] arguments) throws IOException, InterruptedException {
        LogHelper.printVersion((String)"Launcher");
        LogHelper.printLicense((String)"Launcher");
        JVMHelper.checkStackTrace(ClientLauncherWrapper.class);
        JVMHelper.verifySystemProperties(Launcher.class, (boolean)true);
        EnvHelper.checkDangerousParams();
        LauncherConfig config = Launcher.getConfig();
        LauncherEngine.modulesManager = new ClientModuleManager();
        LauncherConfig.initModules((LauncherModulesManager)LauncherEngine.modulesManager);
        LogHelper.info((String)"Launcher for project %s", (Object[])new Object[]{config.projectName});
        if (config.environment.equals((Object)LauncherConfig.LauncherEnvironment.PROD)) {
            if (System.getProperty("launcher.debug") != null) {
                LogHelper.warning((String)"Found -Dlauncher.debug=true");
            }
            if (System.getProperty("launcher.stacktrace") != null) {
                LogHelper.warning((String)"Found -Dlauncher.stacktrace=true");
            }
            LogHelper.info((String)"Debug mode disabled (found env PRODUCTION)");
        } else {
            LogHelper.info((String)"If need debug output use -Dlauncher.debug=true");
            LogHelper.info((String)"If need stacktrace output use -Dlauncher.stacktrace=true");
            if (LogHelper.isDebugEnabled()) {
                waitProcess = true;
            }
        }
        LogHelper.info((String)"Restart Launcher with JavaAgent...");
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (waitProcess) {
            processBuilder.inheritIO();
        }
        JavaVersion javaVersion = null;
        try {
            if (!noJavaCheck) {
                javaVersion = ClientLauncherWrapper.findJava();
            }
        }
        catch (Throwable e) {
            LogHelper.error((Throwable)e);
        }
        if (javaVersion == null) {
            javaVersion = JavaVersion.getCurrentJavaVersion();
        }
        Path javaBin = IOHelper.resolveJavaBin((Path)javaVersion.jvmDir);
        LinkedList<String> args = new LinkedList<String>();
        args.add(javaBin.toString());
        String pathLauncher = IOHelper.getCodeSource(LauncherEngine.class).toString();
        args.add(JVMHelper.jvmProperty((String)"launcher.debug", (String)Boolean.toString(LogHelper.isDebugEnabled())));
        args.add(JVMHelper.jvmProperty((String)"launcher.stacktrace", (String)Boolean.toString(LogHelper.isStacktraceEnabled())));
        args.add(JVMHelper.jvmProperty((String)"launcher.dev", (String)Boolean.toString(LogHelper.isDevEnabled())));
        JVMHelper.addSystemPropertyToArgs(args, (String)"launcher.customdir");
        JVMHelper.addSystemPropertyToArgs(args, (String)"launcher.usecustomdir");
        JVMHelper.addSystemPropertyToArgs(args, (String)"launcher.useoptdir");
        JVMHelper.addSystemPropertyToArgs(args, (String)"launcher.dirwatcher.ignoreOverflows");
        if (javaVersion.version >= 9) {
            LogHelper.debug((String)"Found Java 9+ ( %s )", (Object[])new Object[]{System.getProperty("java.version")});
            String pathToFx = System.getenv("PATH_TO_FX");
            Path fxPath = pathToFx == null ? null : Paths.get(pathToFx, new String[0]);
            StringBuilder builder = new StringBuilder();
            Path[] findPath = new Path[]{javaVersion.jvmDir, javaVersion.jvmDir.resolve("jre"), fxPath};
            ClientLauncherWrapper.tryAddModule(findPath, "javafx.base", builder);
            ClientLauncherWrapper.tryAddModule(findPath, "javafx.graphics", builder);
            ClientLauncherWrapper.tryAddModule(findPath, "javafx.fxml", builder);
            ClientLauncherWrapper.tryAddModule(findPath, "javafx.controls", builder);
            boolean useSwing = ClientLauncherWrapper.tryAddModule(findPath, "javafx.swing", builder);
            String modulePath = builder.toString();
            if (!modulePath.isEmpty()) {
                args.add("--add-modules");
                String javaModules = "javafx.base,javafx.fxml,javafx.controls,jdk.unsupported";
                if (useSwing) {
                    javaModules = javaModules.concat(",javafx.swing");
                }
                args.add(javaModules);
                args.add("--module-path");
                args.add(modulePath);
            }
        }
        args.add(MAGIC_ARG);
        args.add("-XX:+DisableAttachMechanism");
        args.add("-Xmx256M");
        args.add("-cp");
        args.add(pathLauncher);
        args.add(LauncherEngine.class.getName());
        LauncherEngine.modulesManager.callWrapper(processBuilder, args);
        EnvHelper.addEnv((ProcessBuilder)processBuilder);
        LogHelper.debug((String)("Commandline: " + args));
        processBuilder.command(args);
        Process process = processBuilder.start();
        if (!waitProcess) {
            Thread.sleep(3000L);
            if (!process.isAlive()) {
                int errorcode = process.exitValue();
                if (errorcode != 0) {
                    LogHelper.error((String)"Process exit with error code: %d", (Object[])new Object[]{errorcode});
                } else {
                    LogHelper.info((String)"Process exit with code 0");
                }
            } else {
                LogHelper.debug((String)"Process started success");
            }
        } else {
            process.waitFor();
        }
    }

    public static Path tryFindModule(Path path, String moduleName) {
        Path result = path.resolve(moduleName.concat(".jar"));
        LogHelper.dev((String)"Try resolve %s", (Object[])new Object[]{result.toString()});
        if (IOHelper.isFile((Path)result)) {
            return result;
        }
        result = path.resolve("lib").resolve(moduleName.concat(".jar"));
        if (!IOHelper.isFile((Path)result)) {
            return null;
        }
        return result;
    }

    public static boolean tryAddModule(Path[] paths, String moduleName, StringBuilder args) {
        for (Path path : paths) {
            Path result;
            if (path == null || (result = ClientLauncherWrapper.tryFindModule(path, moduleName)) == null) continue;
            if (args.length() != 0) {
                args.append(File.pathSeparatorChar);
            }
            args.append(result.toAbsolutePath().toString());
            return true;
        }
        return false;
    }

    public static JavaVersion findJavaByProgramFiles(Path path) {
        LogHelper.debug((String)"Check Java in %s", (Object[])new Object[]{path.toString()});
        JavaVersion selectedJava = null;
        File[] candidates = path.toFile().listFiles(File::isDirectory);
        if (candidates == null) {
            return null;
        }
        for (File candidate : candidates) {
            Path javaPath = candidate.toPath();
            try {
                JavaVersion javaVersion = JavaVersion.getByPath(javaPath);
                if (javaVersion == null || javaVersion.version < 8) continue;
                LogHelper.debug((String)"Found Java %d in %s (javafx %s)", (Object[])new Object[]{javaVersion.version, javaVersion.jvmDir.toString(), javaVersion.enabledJavaFX ? "true" : "false"});
                if (javaVersion.enabledJavaFX && (selectedJava == null || !selectedJava.enabledJavaFX)) {
                    selectedJava = javaVersion;
                    continue;
                }
                if (selectedJava == null || !javaVersion.enabledJavaFX || javaVersion.version >= selectedJava.version) continue;
                selectedJava = javaVersion;
            }
            catch (IOException e) {
                LogHelper.error((Throwable)e);
            }
        }
        if (selectedJava != null) {
            LogHelper.debug((String)"Selected Java %d in %s (javafx %s)", (Object[])new Object[]{selectedJava.version, selectedJava.jvmDir.toString(), selectedJava.enabledJavaFX ? "true" : "false"});
        }
        return selectedJava;
    }

    public static JavaVersion findJava() {
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE) {
            Path programFiles64;
            JavaVersion result = null;
            Path defaultJvmContainerDir = Paths.get(System.getProperty("java.home"), new String[0]).getParent();
            if (defaultJvmContainerDir.getParent().getFileName().toString().contains("x86") && IOHelper.isDir((Path)(programFiles64 = defaultJvmContainerDir.getParent().getParent().resolve("Program Files").resolve("Java")))) {
                result = ClientLauncherWrapper.findJavaByProgramFiles(programFiles64);
            }
            if (result == null) {
                result = ClientLauncherWrapper.findJavaByProgramFiles(defaultJvmContainerDir);
            }
            return result;
        }
        return null;
    }

    public static int getJavaVersion(String version) {
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    public static class JavaVersion {
        public final Path jvmDir;
        public final int version;
        public boolean enabledJavaFX;

        public JavaVersion(Path jvmDir, int version) {
            this.jvmDir = jvmDir;
            this.version = version;
            this.enabledJavaFX = true;
        }

        public static JavaVersion getCurrentJavaVersion() {
            return new JavaVersion(Paths.get(System.getProperty("java.home"), new String[0]), JVMHelper.getVersion());
        }

        public static JavaVersion getByPath(Path jvmDir) throws IOException {
            Path releaseFile = jvmDir.resolve("release");
            if (!IOHelper.isFile((Path)releaseFile)) {
                return null;
            }
            Properties properties = new Properties();
            properties.load(IOHelper.newReader((Path)releaseFile));
            int javaVersion = ClientLauncherWrapper.getJavaVersion(properties.getProperty("JAVA_VERSION").replaceAll("\"", ""));
            JavaVersion resultJavaVersion = new JavaVersion(jvmDir, javaVersion);
            if (javaVersion <= 8) {
                resultJavaVersion.enabledJavaFX = JavaVersion.isExistExtJavaLibrary(jvmDir, "jfxrt");
            } else {
                boolean bl = resultJavaVersion.enabledJavaFX = ClientLauncherWrapper.tryFindModule(jvmDir, "javafx.base") != null;
                if (!resultJavaVersion.enabledJavaFX) {
                    resultJavaVersion.enabledJavaFX = ClientLauncherWrapper.tryFindModule(jvmDir.resolve("jre"), "javafx.base") != null;
                }
            }
            return resultJavaVersion;
        }

        public static boolean isExistExtJavaLibrary(Path jvmDir, String name) {
            Path jrePath = jvmDir.resolve("lib").resolve("ext").resolve(name.concat(".jar"));
            Path jdkPath = jvmDir.resolve("jre").resolve("lib").resolve("ext").resolve(name.concat(".jar"));
            return IOHelper.isFile((Path)jrePath) || IOHelper.isFile((Path)jdkPath);
        }
    }
}

