/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherAgent;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.api.AuthService;
import pro.gravit.launcher.api.ClientService;
import pro.gravit.launcher.client.ClientClassLoader;
import pro.gravit.launcher.client.ClientLauncherCoreModule;
import pro.gravit.launcher.client.ClientLauncherProcess;
import pro.gravit.launcher.client.ClientModuleManager;
import pro.gravit.launcher.client.events.client.ClientProcessClassLoaderEvent;
import pro.gravit.launcher.client.events.client.ClientProcessInitPhase;
import pro.gravit.launcher.client.events.client.ClientProcessLaunchEvent;
import pro.gravit.launcher.client.events.client.ClientProcessPreInvokeMainClassEvent;
import pro.gravit.launcher.client.events.client.ClientProcessReadyEvent;
import pro.gravit.launcher.guard.LauncherGuardManager;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.managers.ClientGsonManager;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.LauncherModulesManager;
import pro.gravit.launcher.modules.events.PreConfigPhase;
import pro.gravit.launcher.patches.FMLPatcher;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.profiles.optional.actions.OptionalActionClassPath;
import pro.gravit.launcher.profiles.optional.actions.OptionalActionClientArgs;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.RestoreSessionRequest;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.utils.DirWatcher;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class ClientLauncherEntryPoint {
    private static ClientClassLoader classLoader;

    private static ClientLauncherProcess.ClientParams readParams(SocketAddress address) throws IOException {
        try (Socket socket = IOHelper.newSocket();){
            ClientLauncherProcess.ClientParams clientParams;
            socket.connect(address);
            try (HInput input = new HInput(socket.getInputStream());){
                byte[] serialized = input.readByteArray(0);
                ClientLauncherProcess.ClientParams params = (ClientLauncherProcess.ClientParams)Launcher.gsonManager.gson.fromJson(new String(serialized, IOHelper.UNICODE_CHARSET), ClientLauncherProcess.ClientParams.class);
                params.clientHDir = new HashedDir(input);
                params.assetHDir = new HashedDir(input);
                boolean isNeedReadJavaDir = input.readBoolean();
                if (isNeedReadJavaDir) {
                    params.javaHDir = new HashedDir(input);
                }
                clientParams = params;
            }
            return clientParams;
        }
    }

    public static void main(String[] args) throws Throwable {
        ClientProfile profile;
        LauncherEngine.IS_CLIENT.set(true);
        LauncherEngine engine = LauncherEngine.clientInstance();
        JVMHelper.verifySystemProperties(ClientLauncherEntryPoint.class, (boolean)true);
        EnvHelper.checkDangerousParams();
        JVMHelper.checkStackTrace(ClientLauncherEntryPoint.class);
        LogHelper.printVersion((String)"Client Launcher");
        LauncherEngine.checkClass(LauncherEngine.class);
        LauncherEngine.checkClass(LauncherAgent.class);
        LauncherEngine.checkClass(ClientLauncherEntryPoint.class);
        LauncherEngine.modulesManager = new ClientModuleManager();
        LauncherEngine.modulesManager.loadModule(new ClientLauncherCoreModule());
        LauncherConfig.initModules((LauncherModulesManager)LauncherEngine.modulesManager);
        LauncherEngine.modulesManager.initModules(null);
        ClientLauncherEntryPoint.initGson(LauncherEngine.modulesManager);
        LauncherEngine.verifyNoAgent();
        LauncherEngine.modulesManager.invokeEvent((LauncherModule.Event)new PreConfigPhase());
        engine.readKeys();
        LauncherGuardManager.initGuard(true);
        LogHelper.debug((String)"Reading ClientLauncher params");
        ClientLauncherProcess.ClientParams params = ClientLauncherEntryPoint.readParams(new InetSocketAddress("127.0.0.1", Launcher.getConfig().clientPort));
        Launcher.profile = profile = params.profile;
        AuthService.profile = profile;
        LauncherEngine.clientParams = params;
        Request.setSession((UUID)params.session);
        ClientLauncherEntryPoint.checkJVMBitsAndVersion();
        LauncherEngine.modulesManager.invokeEvent((LauncherModule.Event)new ClientProcessInitPhase(engine, params));
        Path clientDir = Paths.get(params.clientDir, new String[0]);
        Path assetDir = Paths.get(params.assetDir, new String[0]);
        LogHelper.debug((String)"Verifying ClientLauncher sign and classpath");
        LinkedList classpath = new LinkedList();
        ClientLauncherEntryPoint.resolveClassPathStream(clientDir, params.profile.getClassPath()).map(IOHelper::toURL).collect(Collectors.toCollection(() -> classpath));
        for (OptionalAction a : params.actions) {
            if (!(a instanceof OptionalActionClassPath)) continue;
            ClientLauncherEntryPoint.resolveClassPathStream(clientDir, ((OptionalActionClassPath)a).args).map(IOHelper::toURL).collect(Collectors.toCollection(() -> classpath));
        }
        classLoader = new ClientClassLoader(classpath.toArray(new URL[0]), ClassLoader.getSystemClassLoader());
        Thread.currentThread().setContextClassLoader(classLoader);
        ClientLauncherEntryPoint.classLoader.nativePath = clientDir.resolve("natives").toString();
        LauncherEngine.modulesManager.invokeEvent(new ClientProcessClassLoaderEvent(engine, classLoader, profile));
        boolean digest = !profile.isUpdateFastCheck();
        LogHelper.debug((String)"Restore sessions");
        RestoreSessionRequest request = new RestoreSessionRequest(Request.getSession());
        request.request();
        Request.service.reconnectCallback = () -> {
            LogHelper.debug((String)"WebSocket connect closed. Try reconnect");
            try {
                Request.service.open();
                LogHelper.debug((String)"Connect to %s", (Object[])new Object[]{Launcher.getConfig().address});
            }
            catch (Exception e) {
                LogHelper.error((Throwable)e);
                throw new RequestException(String.format("Connect error: %s", e.getMessage() != null ? e.getMessage() : "null"));
            }
            try {
                RestoreSessionRequest request1 = new RestoreSessionRequest(Request.getSession());
                request1.request();
            }
            catch (Exception e) {
                LogHelper.error((Throwable)e);
            }
        };
        AuthService.username = params.playerProfile.username;
        AuthService.uuid = params.playerProfile.uuid;
        ClientService.classLoader = classLoader;
        ClientService.nativePath = ClientLauncherEntryPoint.classLoader.nativePath;
        classLoader.addURL(IOHelper.getCodeSource(ClientLauncherEntryPoint.class).toUri().toURL());
        ClientService.baseURLs = classLoader.getURLs();
        LauncherEngine.modulesManager.invokeEvent((LauncherModule.Event)new ClientProcessReadyEvent(engine, params));
        LogHelper.debug((String)"Starting JVM and client WatchService");
        FileNameMatcher assetMatcher = profile.getAssetUpdateMatcher();
        FileNameMatcher clientMatcher = profile.getClientUpdateMatcher();
        Path javaDir = Paths.get(System.getProperty("java.home"), new String[0]);
        try (DirWatcher assetWatcher = new DirWatcher(assetDir, params.assetHDir, assetMatcher, digest);
             DirWatcher clientWatcher = new DirWatcher(clientDir, params.clientHDir, clientMatcher, digest);
             DirWatcher javaWatcher = params.javaHDir == null ? null : new DirWatcher(javaDir, params.javaHDir, null, digest);){
            CommonHelper.newThread((String)"Asset Directory Watcher", (boolean)true, (Runnable)assetWatcher).start();
            CommonHelper.newThread((String)"Client Directory Watcher", (boolean)true, (Runnable)clientWatcher).start();
            if (javaWatcher != null) {
                CommonHelper.newThread((String)"Java Directory Watcher", (boolean)true, (Runnable)clientWatcher).start();
            }
            ClientLauncherEntryPoint.verifyHDir(assetDir, params.assetHDir, assetMatcher, digest);
            ClientLauncherEntryPoint.verifyHDir(clientDir, params.clientHDir, clientMatcher, digest);
            if (javaWatcher != null) {
                ClientLauncherEntryPoint.verifyHDir(javaDir, params.javaHDir, null, digest);
            }
            LauncherEngine.modulesManager.invokeEvent(new ClientProcessLaunchEvent(engine, params));
            ClientLauncherEntryPoint.launch(profile, params);
        }
    }

    private static void initGson(ClientModuleManager moduleManager) {
        AuthRequest.registerProviders();
        OptionalAction.registerProviders();
        Launcher.gsonManager = new ClientGsonManager(moduleManager);
        Launcher.gsonManager.initGson();
    }

    public static void verifyHDir(Path dir, HashedDir hdir, FileNameMatcher matcher, boolean digest) throws IOException {
        HashedDir currentHDir = new HashedDir(dir, matcher, true, digest);
        HashedDir.Diff diff = hdir.diff(currentHDir, matcher);
        if (!diff.isSame()) {
            throw new SecurityException(String.format("Forbidden modification: '%s'", IOHelper.getFileName((Path)dir)));
        }
    }

    public static void checkJVMBitsAndVersion() {
        if (JVMHelper.JVM_BITS != JVMHelper.OS_BITS) {
            String error = String.format("\u0423 \u0412\u0430\u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 Java %d, \u043d\u043e \u0412\u0430\u0448\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430 \u043a\u0430\u043a %d. \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 Java \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0439 \u0440\u0430\u0437\u0440\u044f\u0434\u043d\u043e\u0441\u0442\u0438", JVMHelper.JVM_BITS, JVMHelper.OS_BITS);
            LogHelper.error((String)error);
            if (Launcher.getConfig().isWarningMissArchJava) {
                JOptionPane.showMessageDialog(null, error);
            }
        }
        String jvmVersion = JVMHelper.RUNTIME_MXBEAN.getVmVersion();
        LogHelper.info((String)jvmVersion);
        if (jvmVersion.startsWith("10.") || jvmVersion.startsWith("9.") || jvmVersion.startsWith("11.")) {
            String error = String.format("\u0423 \u0412\u0430\u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 Java %s. \u0414\u043b\u044f \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0439 \u0440\u0430\u0431\u043e\u0442\u044b \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 Java 8", JVMHelper.RUNTIME_MXBEAN.getVmVersion());
            LogHelper.error((String)error);
            if (Launcher.getConfig().isWarningMissArchJava) {
                JOptionPane.showMessageDialog(null, error);
            }
        }
    }

    private static LinkedList<Path> resolveClassPathList(Path clientDir, String ... classPath) throws IOException {
        return ClientLauncherEntryPoint.resolveClassPathStream(clientDir, classPath).collect(Collectors.toCollection(LinkedList::new));
    }

    private static Stream<Path> resolveClassPathStream(Path clientDir, String ... classPath) throws IOException {
        Stream.Builder<Path> builder = Stream.builder();
        for (String classPathEntry : classPath) {
            Path path = clientDir.resolve(IOHelper.toPath((String)classPathEntry.replace("/", IOHelper.PLATFORM_SEPARATOR)));
            if (IOHelper.isDir((Path)path)) {
                IOHelper.walk((Path)path, (FileVisitor)new ClassPathFileVisitor(builder), (boolean)false);
                continue;
            }
            builder.accept(path);
        }
        return builder.build();
    }

    private static void launch(ClientProfile profile, ClientLauncherProcess.ClientParams params) throws Throwable {
        LinkedList<String> args = new LinkedList<String>();
        if (profile.getVersion().compareTo((Enum)ClientProfile.Version.MC164) >= 0) {
            params.addClientArgs(args);
        } else {
            params.addClientLegacyArgs(args);
            System.setProperty("minecraft.applet.TargetDirectory", params.clientDir);
        }
        Collections.addAll(args, profile.getClientArgs());
        for (OptionalAction action : params.actions) {
            if (!(action instanceof OptionalActionClientArgs)) continue;
            args.addAll(((OptionalActionClientArgs)action).args);
        }
        ArrayList<String> copy = new ArrayList<String>(args);
        int l = copy.size();
        for (int i = 0; i < l; ++i) {
            String s = (String)copy.get(i);
            if (i + 1 >= l || !"--accessToken".equals(s) && !"--session".equals(s)) continue;
            copy.set(i + 1, "censored");
        }
        LogHelper.debug((String)("Args: " + copy));
        Class<?> mainClass = classLoader.loadClass(profile.getMainClass());
        for (URL u : classLoader.getURLs()) {
            LogHelper.info((String)"ClassLoader URL: %s", (Object[])new Object[]{u.toString()});
        }
        FMLPatcher.apply();
        LauncherEngine.modulesManager.invokeEvent(new ClientProcessPreInvokeMainClassEvent(params, profile, args));
        MethodHandle mainMethod = MethodHandles.publicLookup().findStatic(mainClass, "main", MethodType.methodType(Void.TYPE, String[].class)).asFixedArity();
        Launcher.LAUNCHED.set(true);
        JVMHelper.fullGC();
        try {
            mainMethod.invokeWithArguments(new Object[]{args.toArray(new String[0])});
            LogHelper.debug((String)"Main exit successful");
        }
        catch (Throwable e) {
            LogHelper.error((Throwable)e);
            throw e;
        }
        finally {
            LauncherEngine.exitLauncher(0);
        }
    }

    private static final class ClassPathFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Stream.Builder<Path> result;

        private ClassPathFileVisitor(Stream.Builder<Path> result) {
            this.result = result;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (IOHelper.hasExtension((Path)file, (String)"jar") || IOHelper.hasExtension((Path)file, (String)"zip")) {
                this.result.accept(file);
            }
            return super.visitFile(file, attrs);
        }
    }
}

