/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.console.test;

import pro.gravit.launcher.utils.HWIDProvider;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.helper.LogHelper;

public class PrintHardwareInfoCommand
extends Command {
    public String getArgsDescription() {
        return "[]";
    }

    public String getUsageDescription() {
        return "print your hardware info and timings";
    }

    public void invoke(String ... args) throws Exception {
        LogHelper.info((String)"Your Hardware ID:");
        long startTime = System.currentTimeMillis();
        HWIDProvider provider = new HWIDProvider();
        long currentTime = System.currentTimeMillis();
        LogHelper.info((String)"Create HWIDProvider instance: %d ms", (Object[])new Object[]{currentTime - startTime});
        startTime = System.currentTimeMillis();
        int bitness = provider.getBitness();
        long totalMemory = provider.getTotalMemory();
        boolean isBattery = provider.isBattery();
        currentTime = System.currentTimeMillis();
        LogHelper.info((String)"Bitness: %d, totalMemory: %d(%.3f GB), battery %s, TIME: %d ms", (Object[])new Object[]{bitness, totalMemory, (double)totalMemory / 1.073741824E9, Boolean.toString(isBattery), currentTime - startTime});
        startTime = System.currentTimeMillis();
        int logicalProcessors = provider.getProcessorLogicalCount();
        int physicalProcessors = provider.getProcessorPhysicalCount();
        long processorMaxFreq = provider.getProcessorMaxFreq();
        currentTime = System.currentTimeMillis();
        LogHelper.info((String)"Processors || logical: %d physical %d freq %d, TIME: %d ms", (Object[])new Object[]{logicalProcessors, physicalProcessors, processorMaxFreq, currentTime - startTime});
        startTime = System.currentTimeMillis();
        String hwDiskID = provider.getHWDiskID();
        currentTime = System.currentTimeMillis();
        LogHelper.info((String)"HWDiskID %s, TIME: %d ms", (Object[])new Object[]{hwDiskID, currentTime - startTime});
        startTime = System.currentTimeMillis();
        String baseboardSerial = provider.getBaseboardSerialNumber();
        currentTime = System.currentTimeMillis();
        LogHelper.info((String)"BaseboardSerial %s, TIME: %d ms", (Object[])new Object[]{baseboardSerial, currentTime - startTime});
        LogHelper.info((String)"Hardware ID end");
    }
}

