/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.utils;

import oshi.SystemInfo;
import oshi.hardware.Display;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.PowerSource;
import oshi.software.os.OperatingSystem;
import pro.gravit.launcher.request.secure.HardwareReportRequest;

public class HWIDProvider {
    public final SystemInfo systemInfo = new SystemInfo();
    public final OperatingSystem system = this.systemInfo.getOperatingSystem();
    public final HardwareAbstractionLayer hardware = this.systemInfo.getHardware();

    public int getBitness() {
        return this.system.getBitness();
    }

    public long getTotalMemory() {
        return this.hardware.getMemory().getTotal();
    }

    public long getProcessorMaxFreq() {
        return this.hardware.getProcessor().getMaxFreq();
    }

    public int getProcessorPhysicalCount() {
        return this.hardware.getProcessor().getPhysicalProcessorCount();
    }

    public int getProcessorLogicalCount() {
        return this.hardware.getProcessor().getLogicalProcessorCount();
    }

    public boolean isBattery() {
        PowerSource[] powerSources = this.hardware.getPowerSources();
        return powerSources != null && powerSources.length != 0;
    }

    public String getHWDiskID() {
        HWDiskStore[] hwDiskStore = this.hardware.getDiskStores();
        long size = 0L;
        HWDiskStore maxStore = null;
        for (HWDiskStore store : hwDiskStore) {
            if (store.getSize() <= size) continue;
            maxStore = store;
            size = store.getSize();
        }
        if (maxStore != null) {
            return maxStore.getSerial();
        }
        return null;
    }

    public byte[] getDisplayID() {
        Display[] displays = this.hardware.getDisplays();
        if (displays == null || displays.length == 0) {
            return null;
        }
        int n = 0;
        Display[] displayArray = displays;
        int n2 = displayArray.length;
        if (n < n2) {
            Display display = displayArray[n];
            return display.getEdid();
        }
        return null;
    }

    public String getBaseboardSerialNumber() {
        return this.hardware.getComputerSystem().getBaseboard().getSerialNumber();
    }

    public HardwareReportRequest.HardwareInfo getHardwareInfo(boolean needSerial) {
        HardwareReportRequest.HardwareInfo info = new HardwareReportRequest.HardwareInfo();
        info.bitness = this.getBitness();
        info.logicalProcessors = this.getProcessorLogicalCount();
        info.physicalProcessors = this.getProcessorPhysicalCount();
        info.processorMaxFreq = this.getProcessorMaxFreq();
        info.totalMemory = this.getTotalMemory();
        info.battery = this.isBattery();
        if (needSerial) {
            info.hwDiskId = this.getHWDiskID();
            info.displayId = this.getDisplayID();
            info.baseboardSerialNumber = this.getBaseboardSerialNumber();
        }
        return info;
    }
}

