/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.client.ClientLauncherEntryPoint;
import pro.gravit.launcher.client.events.client.ClientProcessBuilderCreateEvent;
import pro.gravit.launcher.client.events.client.ClientProcessBuilderLaunchedEvent;
import pro.gravit.launcher.client.events.client.ClientProcessBuilderParamsWrittedEvent;
import pro.gravit.launcher.client.events.client.ClientProcessBuilderPreLaunchEvent;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.profiles.optional.OptionalView;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.profiles.optional.actions.OptionalActionClientArgs;
import pro.gravit.launcher.profiles.optional.actions.OptionalActionJvmArgs;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.JavaHelper;
import pro.gravit.utils.helper.LogHelper;

public class ClientLauncherProcess {
    public final ClientParams params = new ClientParams();
    public final List<String> jvmArgs = new LinkedList<String>();
    public final List<String> jvmModules = new LinkedList<String>();
    public final List<String> jvmModulesPaths = new LinkedList<String>();
    public final List<String> systemClientArgs = new LinkedList<String>();
    public final List<String> systemClassPath = new LinkedList<String>();
    public final Map<String, String> systemEnv = new HashMap<String, String>();
    public final String mainClass;
    private final transient Boolean[] waitWriteParams = new Boolean[]{false};
    public Path executeFile;
    public Path workDir;
    public Path javaDir;
    public int bits;
    public boolean useLegacyJavaClassPathProperty;
    public boolean isStarted;
    public JavaHelper.JavaVersion javaVersion;
    private transient Process process;

    public ClientLauncherProcess(Path executeFile, Path workDir, Path javaDir, String mainClass) {
        this.executeFile = executeFile;
        this.workDir = workDir;
        this.javaDir = javaDir;
        this.mainClass = mainClass;
    }

    public ClientLauncherProcess(Path clientDir, Path assetDir, Path javaDir, ClientProfile profile, PlayerProfile playerProfile, String accessToken, HashedDir clientHDir, HashedDir assetHDir, HashedDir jvmHDir) {
        this(clientDir, assetDir, javaDir, clientDir.resolve("resourcepacks"), profile, playerProfile, null, accessToken, clientHDir, assetHDir, jvmHDir);
    }

    public ClientLauncherProcess(Path clientDir, Path assetDir, ClientProfile profile, PlayerProfile playerProfile, String accessToken, HashedDir clientHDir, HashedDir assetHDir, HashedDir jvmHDir) {
        this(clientDir, assetDir, Paths.get(System.getProperty("java.home"), new String[0]), clientDir.resolve("resourcepacks"), profile, playerProfile, null, accessToken, clientHDir, assetHDir, jvmHDir);
    }

    public ClientLauncherProcess(Path clientDir, Path assetDir, Path javaDir, Path resourcePackDir, ClientProfile profile, PlayerProfile playerProfile, OptionalView view, String accessToken, HashedDir clientHDir, HashedDir assetHDir, HashedDir jvmHDir) {
        this.workDir = clientDir.toAbsolutePath();
        this.javaDir = javaDir;
        this.executeFile = IOHelper.resolveJavaBin((Path)this.javaDir);
        this.mainClass = ClientLauncherEntryPoint.class.getName();
        this.params.clientDir = this.workDir.toString();
        this.params.resourcePackDir = resourcePackDir.toAbsolutePath().toString();
        this.params.assetDir = assetDir.toAbsolutePath().toString();
        this.params.profile = profile;
        this.params.playerProfile = playerProfile;
        this.params.accessToken = accessToken;
        this.params.assetHDir = assetHDir;
        this.params.clientHDir = clientHDir;
        this.params.javaHDir = jvmHDir;
        if (view != null) {
            this.params.actions = view.getEnabledActions();
        }
        try {
            this.javaVersion = JavaHelper.JavaVersion.getByPath((Path)javaDir);
        }
        catch (IOException e) {
            LogHelper.error((Throwable)e);
            this.javaVersion = null;
        }
        if (this.javaVersion == null) {
            this.javaVersion = JavaHelper.JavaVersion.getCurrentJavaVersion();
        }
        this.bits = JVMHelper.JVM_BITS;
        this.applyClientProfile();
    }

    public static String getPathSeparator() {
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE) {
            return ";";
        }
        return ":";
    }

    private void applyClientProfile() {
        this.systemClassPath.add(IOHelper.getCodeSource(ClientLauncherEntryPoint.class).toAbsolutePath().toString());
        Collections.addAll(this.jvmArgs, this.params.profile.getJvmArgs());
        for (OptionalAction a : this.params.actions) {
            if (!(a instanceof OptionalActionJvmArgs)) continue;
            this.jvmArgs.addAll(((OptionalActionJvmArgs)a).args);
        }
        this.systemEnv.put("JAVA_HOME", this.javaDir.toString());
        Collections.addAll(this.systemClassPath, this.params.profile.getAlternativeClassPath());
        if (this.params.ram > 0) {
            this.jvmArgs.add("-Xmx" + this.params.ram + 'M');
        }
        this.params.oauth = Request.getOAuth();
        if (this.params.oauth == null) {
            throw new UnsupportedOperationException("Legacy session not supported");
        }
        this.params.authId = Request.getAuthId();
        this.params.oauthExpiredTime = Request.getTokenExpiredTime();
        this.params.extendedTokens = Request.getExtendedTokens();
        this.jvmModules.addAll(this.params.profile.getModules());
        this.jvmModulesPaths.addAll(this.params.profile.getModulePath());
        if (this.params.profile.getRuntimeInClientConfig() != ClientProfile.RuntimeInClientConfig.NONE) {
            this.jvmModules.add("javafx.base");
            this.jvmModules.add("javafx.graphics");
            this.jvmModules.add("javafx.fxml");
            this.jvmModules.add("javafx.controls");
            this.jvmModules.add("javafx.swing");
            this.jvmModules.add("javafx.media");
            this.jvmModules.add("javafx.web");
        }
        LauncherEngine.modulesManager.invokeEvent(new ClientProcessBuilderCreateEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean pipeOutput) throws IOException, InterruptedException {
        if (this.isStarted) {
            throw new IllegalStateException("Process already started");
        }
        if (LauncherEngine.guard != null) {
            LauncherEngine.guard.applyGuardParams(this);
        }
        LauncherEngine.modulesManager.invokeEvent(new ClientProcessBuilderPreLaunchEvent(this));
        LinkedList<String> processArgs = new LinkedList<String>();
        processArgs.add(this.executeFile.toString());
        processArgs.addAll(this.jvmArgs);
        if (this.javaVersion.version >= 9) {
            this.applyJava9Params(processArgs);
        }
        if (this.params.profile.getClassLoaderConfig() == ClientProfile.ClassLoaderConfig.AGENT) {
            processArgs.add("-javaagent:".concat(IOHelper.getCodeSource(ClientLauncherEntryPoint.class).toAbsolutePath().toString()));
        } else if (this.params.profile.getClassLoaderConfig() == ClientProfile.ClassLoaderConfig.SYSTEM_ARGS) {
            this.systemClassPath.addAll(ClientLauncherEntryPoint.resolveClassPath(this.workDir, this.params.actions, this.params.profile).map(Path::toString).collect(Collectors.toList()));
        }
        if (this.useLegacyJavaClassPathProperty) {
            processArgs.add("-Djava.class.path=".concat(String.join((CharSequence)ClientLauncherProcess.getPathSeparator(), this.systemClassPath)));
        } else {
            processArgs.add("-cp");
            processArgs.add(String.join((CharSequence)ClientLauncherProcess.getPathSeparator(), this.systemClassPath));
        }
        processArgs.add(this.mainClass);
        processArgs.addAll(this.systemClientArgs);
        Boolean[] booleanArray = this.waitWriteParams;
        synchronized (this.waitWriteParams) {
            if (!this.waitWriteParams[0].booleanValue()) {
                this.waitWriteParams.wait(1000L);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (LogHelper.isDebugEnabled()) {
                LogHelper.debug((String)"Commandline: %s", (Object[])new Object[]{Arrays.toString(processArgs.toArray())});
            }
            ProcessBuilder processBuilder = new ProcessBuilder(processArgs);
            EnvHelper.addEnv((ProcessBuilder)processBuilder);
            processBuilder.environment().put("JAVA_HOME", this.javaDir.toAbsolutePath().toString());
            processBuilder.environment().putAll(this.systemEnv);
            processBuilder.directory(this.workDir.toFile());
            processBuilder.inheritIO();
            if (pipeOutput) {
                processBuilder.redirectErrorStream(true);
                processBuilder.redirectOutput(ProcessBuilder.Redirect.PIPE);
            }
            this.process = processBuilder.start();
            LauncherEngine.modulesManager.invokeEvent(new ClientProcessBuilderLaunchedEvent(this));
            this.isStarted = true;
            return;
        }
    }

    private void applyJava9Params(List<String> processArgs) {
        StringBuilder modulesPath = new StringBuilder();
        StringBuilder modulesAdd = new StringBuilder();
        for (String moduleName : this.jvmModules) {
            if (modulesAdd.length() > 0) {
                modulesAdd.append(",");
            }
            modulesAdd.append(moduleName);
        }
        for (String modulePath : this.jvmModulesPaths) {
            if (modulesPath.length() > 0) {
                modulesPath.append(File.pathSeparator);
            }
            modulesPath.append(modulePath);
        }
        if (modulesAdd.length() > 0) {
            processArgs.add("--add-modules");
            processArgs.add(modulesAdd.toString());
        }
        if (modulesPath.length() > 0) {
            processArgs.add("--module-path");
            processArgs.add(modulesPath.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWriteParams(SocketAddress address) throws IOException {
        try (ServerSocket serverSocket = new ServerSocket();){
            serverSocket.bind(address);
            Boolean[] booleanArray = this.waitWriteParams;
            synchronized (this.waitWriteParams) {
                this.waitWriteParams[0] = true;
                this.waitWriteParams.notifyAll();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                Socket socket = serverSocket.accept();
                try (HOutput output = new HOutput(socket.getOutputStream());){
                    byte[] serializedMainParams = IOHelper.encode((String)Launcher.gsonManager.gson.toJson((Object)this.params));
                    output.writeByteArray(serializedMainParams, 0);
                    this.params.clientHDir.write(output);
                    this.params.assetHDir.write(output);
                    if (this.params.javaHDir == null || this.params.javaHDir == this.params.assetHDir) {
                        output.writeBoolean(false);
                    } else {
                        output.writeBoolean(true);
                        this.params.javaHDir.write(output);
                    }
                }
            }
        }
        {
            LauncherEngine.modulesManager.invokeEvent(new ClientProcessBuilderParamsWrittedEvent(this));
            return;
        }
    }

    public Process getProcess() {
        return this.process;
    }

    public static class ClientParams {
        public String assetDir;
        public String clientDir;
        public String resourcePackDir;
        public PlayerProfile playerProfile;
        public ClientProfile profile;
        public String accessToken;
        public boolean autoEnter;
        public boolean fullScreen;
        public int ram;
        public int width;
        public int height;
        public Set<OptionalAction> actions = new HashSet<OptionalAction>();
        public UUID session;
        public AuthRequestEvent.OAuthRequestEvent oauth;
        public String authId;
        public long oauthExpiredTime;
        public Map<String, String> extendedTokens;
        public boolean offlineMode;
        public transient HashedDir assetHDir;
        public transient HashedDir clientHDir;
        public transient HashedDir javaHDir;

        public void addClientArgs(Collection<String> args) {
            if (this.profile.getVersion().compareTo((Enum)ClientProfile.Version.MC164) >= 0) {
                this.addModernClientArgs(args);
            } else {
                this.addClientLegacyArgs(args);
            }
        }

        public void addClientLegacyArgs(Collection<String> args) {
            args.add(this.playerProfile.username);
            args.add(this.accessToken);
            Collections.addAll(args, "--version", this.profile.getVersion().name);
            Collections.addAll(args, "--gameDir", this.clientDir);
            Collections.addAll(args, "--assetsDir", this.assetDir);
        }

        private void addModernClientArgs(Collection<String> args) {
            ClientProfile.Version version = this.profile.getVersion();
            Collections.addAll(args, "--username", this.playerProfile.username);
            if (version.compareTo((Enum)ClientProfile.Version.MC172) >= 0) {
                Collections.addAll(args, "--uuid", Launcher.toHash((UUID)this.playerProfile.uuid));
                Collections.addAll(args, "--accessToken", this.accessToken);
                if (version.compareTo((Enum)ClientProfile.Version.MC1710) >= 0) {
                    Collections.addAll(args, "--userType", "mojang");
                    Collections.addAll(args, "--userProperties", "{}");
                    Collections.addAll(args, "--assetIndex", this.profile.getAssetIndex());
                }
            } else {
                Collections.addAll(args, "--session", this.accessToken);
            }
            Collections.addAll(args, "--version", this.profile.getVersion().name);
            Collections.addAll(args, "--gameDir", this.clientDir);
            Collections.addAll(args, "--assetsDir", this.assetDir);
            Collections.addAll(args, "--resourcePackDir", this.resourcePackDir);
            if (version.compareTo((Enum)ClientProfile.Version.MC194) >= 0) {
                Collections.addAll(args, "--versionType", "Launcher v" + Version.getVersion().getVersionString());
            }
            if (this.autoEnter) {
                Collections.addAll(args, "--server", this.profile.getServerAddress());
                Collections.addAll(args, "--port", Integer.toString(this.profile.getServerPort()));
            }
            for (OptionalAction a : this.actions) {
                if (!(a instanceof OptionalActionClientArgs)) continue;
                args.addAll(((OptionalActionClientArgs)a).args);
            }
            if (this.fullScreen) {
                Collections.addAll(args, "--fullscreen", Boolean.toString(true));
            }
            if (this.width > 0 && this.height > 0) {
                Collections.addAll(args, "--width", Integer.toString(this.width));
                Collections.addAll(args, "--height", Integer.toString(this.height));
            }
        }
    }
}

