/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.console;

import java.util.Base64;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.helper.LogHelper;

public class SignDataCommand
extends Command {
    private final LauncherEngine engine;

    public SignDataCommand(LauncherEngine engine) {
        this.engine = engine;
    }

    public String getArgsDescription() {
        return "[base64 data]";
    }

    public String getUsageDescription() {
        return "sign any data";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 1);
        byte[] data = Base64.getDecoder().decode(args[0]);
        byte[] signature = this.engine.sign(data);
        String base64 = Base64.getEncoder().encodeToString(signature);
        LogHelper.info((String)"Signature: %s", (Object[])new Object[]{base64});
    }
}

