/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.IOException;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import pro.gravit.launcher.BasicLauncherEventHandler;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherAgent;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.LauncherTrustManager;
import pro.gravit.launcher.client.ClientLauncherCoreModule;
import pro.gravit.launcher.client.ClientLauncherEntryPoint;
import pro.gravit.launcher.client.ClientLauncherProcess;
import pro.gravit.launcher.client.ClientModuleManager;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.events.ClientEngineInitPhase;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.client.events.ClientPreGuiPhase;
import pro.gravit.launcher.console.GetPublicKeyCommand;
import pro.gravit.launcher.console.ModulesCommand;
import pro.gravit.launcher.console.SignDataCommand;
import pro.gravit.launcher.events.request.ExitRequestEvent;
import pro.gravit.launcher.events.request.FeaturesRequestEvent;
import pro.gravit.launcher.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.events.request.GetSecureLevelInfoRequestEvent;
import pro.gravit.launcher.events.request.JoinServerRequestEvent;
import pro.gravit.launcher.events.request.LauncherRequestEvent;
import pro.gravit.launcher.events.request.SecurityReportRequestEvent;
import pro.gravit.launcher.events.request.SetProfileRequestEvent;
import pro.gravit.launcher.guard.LauncherGuard;
import pro.gravit.launcher.guard.LauncherNoGuard;
import pro.gravit.launcher.guard.LauncherWrapperGuard;
import pro.gravit.launcher.gui.NoRuntimeProvider;
import pro.gravit.launcher.gui.RuntimeProvider;
import pro.gravit.launcher.managers.ClientGsonManager;
import pro.gravit.launcher.managers.ConsoleManager;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.LauncherModulesManager;
import pro.gravit.launcher.modules.events.OfflineModeEvent;
import pro.gravit.launcher.modules.events.PreConfigPhase;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.RequestService;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.CheckServerRequest;
import pro.gravit.launcher.request.auth.ExitRequest;
import pro.gravit.launcher.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launcher.request.auth.JoinServerRequest;
import pro.gravit.launcher.request.auth.SetProfileRequest;
import pro.gravit.launcher.request.auth.details.AuthLoginOnlyDetails;
import pro.gravit.launcher.request.management.FeaturesRequest;
import pro.gravit.launcher.request.secure.GetSecureLevelInfoRequest;
import pro.gravit.launcher.request.secure.SecurityReportRequest;
import pro.gravit.launcher.request.update.LauncherRequest;
import pro.gravit.launcher.request.websockets.OfflineRequestService;
import pro.gravit.launcher.request.websockets.StdWebSocketService;
import pro.gravit.launcher.utils.NativeJVMHalt;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class LauncherEngine {
    public static ClientLauncherProcess.ClientParams clientParams;
    public static LauncherGuard guard;
    public static ClientModuleManager modulesManager;
    public final boolean clientInstance;
    private final AtomicBoolean started = new AtomicBoolean(false);
    public RuntimeProvider runtimeProvider;
    public ECPublicKey publicKey;
    public ECPrivateKey privateKey;

    private LauncherEngine(boolean clientInstance) {
        this.clientInstance = clientInstance;
    }

    public static X509Certificate[] getCertificates(Class<?> clazz) {
        Object[] signers = clazz.getSigners();
        if (signers == null) {
            return null;
        }
        return (X509Certificate[])Arrays.stream(signers).filter(c -> c instanceof X509Certificate).map(c -> (X509Certificate)c).toArray(X509Certificate[]::new);
    }

    public static void checkClass(Class<?> clazz) throws SecurityException {
        LauncherTrustManager trustManager = Launcher.getConfig().trustManager;
        if (trustManager == null) {
            return;
        }
        X509Certificate[] certificates = LauncherEngine.getCertificates(clazz);
        if (certificates == null) {
            throw new SecurityException(String.format("Class %s not signed", clazz.getName()));
        }
        try {
            trustManager.checkCertificatesSuccess(certificates, (arg_0, arg_1, arg_2) -> ((LauncherTrustManager)trustManager).stdCertificateChecker(arg_0, arg_1, arg_2));
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static void beforeExit(int code) {
        try {
            modulesManager.invokeEvent((LauncherModule.Event)new ClientExitPhase(code));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void forceExit(int code) {
        try {
            System.exit(code);
        }
        catch (Throwable e) {
            NativeJVMHalt.haltA(code);
        }
    }

    public static void exitLauncher(int code) {
        LauncherEngine.beforeExit(code);
        LauncherEngine.forceExit(code);
    }

    public static void main(String ... args) throws Throwable {
        JVMHelper.checkStackTrace(LauncherEngine.class);
        JVMHelper.verifySystemProperties(Launcher.class, (boolean)true);
        EnvHelper.checkDangerousParams();
        LauncherEngine.verifyNoAgent();
        LogHelper.printVersion((String)"Launcher");
        LogHelper.printLicense((String)"Launcher");
        LauncherEngine.checkClass(LauncherEngine.class);
        LauncherEngine.checkClass(LauncherAgent.class);
        LauncherEngine.checkClass(ClientLauncherEntryPoint.class);
        modulesManager = new ClientModuleManager();
        modulesManager.loadModule(new ClientLauncherCoreModule());
        LauncherConfig.initModules((LauncherModulesManager)modulesManager);
        modulesManager.initModules(null);
        LauncherEngine.initGson(modulesManager);
        ConsoleManager.initConsole();
        modulesManager.invokeEvent((LauncherModule.Event)new PreConfigPhase());
        Launcher.getConfig();
        long startTime = System.currentTimeMillis();
        try {
            new LauncherEngine(false).start(args);
        }
        catch (Exception e) {
            LogHelper.error((Throwable)e);
            return;
        }
        long endTime = System.currentTimeMillis();
        LogHelper.debug((String)"Launcher started in %dms", (Object[])new Object[]{endTime - startTime});
        LauncherEngine.exitLauncher(0);
    }

    public static void initGson(ClientModuleManager modulesManager) {
        AuthRequest.registerProviders();
        GetAvailabilityAuthRequest.registerProviders();
        OptionalAction.registerProviders();
        OptionalTrigger.registerProviders();
        Launcher.gsonManager = new ClientGsonManager(modulesManager);
        Launcher.gsonManager.initGson();
    }

    public static void verifyNoAgent() {
        if (JVMHelper.RUNTIME_MXBEAN.getInputArguments().stream().filter(e -> e != null && !e.isEmpty()).anyMatch(e -> e.contains("javaagent"))) {
            throw new SecurityException("JavaAgent found");
        }
    }

    public static LauncherGuard tryGetStdGuard() {
        switch (Launcher.getConfig().guardType) {
            case "no": {
                return new LauncherNoGuard();
            }
            case "wrapper": {
                return new LauncherWrapperGuard();
            }
        }
        return null;
    }

    public static RequestService initOffline() {
        OfflineRequestService service = new OfflineRequestService();
        LauncherEngine.applyBasicOfflineProcessors(service);
        OfflineModeEvent event = new OfflineModeEvent((RequestService)service);
        modulesManager.invokeEvent((LauncherModule.Event)event);
        return event.service;
    }

    public static void applyBasicOfflineProcessors(OfflineRequestService service) {
        service.registerRequestProcessor(LauncherRequest.class, r -> new LauncherRequestEvent(false, (String)null));
        service.registerRequestProcessor(CheckServerRequest.class, r -> {
            throw new RequestException("CheckServer disabled in offline mode");
        });
        service.registerRequestProcessor(GetAvailabilityAuthRequest.class, r -> {
            ArrayList<AuthLoginOnlyDetails> details = new ArrayList<AuthLoginOnlyDetails>();
            details.add(new AuthLoginOnlyDetails());
            GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability = new GetAvailabilityAuthRequestEvent.AuthAvailability("offline", "Offline Mode", true, details);
            ArrayList<GetAvailabilityAuthRequestEvent.AuthAvailability> list = new ArrayList<GetAvailabilityAuthRequestEvent.AuthAvailability>(1);
            list.add(authAvailability);
            return new GetAvailabilityAuthRequestEvent(list);
        });
        service.registerRequestProcessor(JoinServerRequest.class, r -> new JoinServerRequestEvent(false));
        service.registerRequestProcessor(ExitRequest.class, r -> new ExitRequestEvent(ExitRequestEvent.ExitReason.CLIENT));
        service.registerRequestProcessor(SetProfileRequest.class, r -> new SetProfileRequestEvent(null));
        service.registerRequestProcessor(FeaturesRequest.class, r -> new FeaturesRequestEvent());
        service.registerRequestProcessor(GetSecureLevelInfoRequest.class, r -> new GetSecureLevelInfoRequestEvent(null, false));
        service.registerRequestProcessor(SecurityReportRequest.class, r -> new SecurityReportRequestEvent(SecurityReportRequestEvent.ReportAction.NONE));
    }

    public static LauncherEngine clientInstance() {
        return new LauncherEngine(true);
    }

    public static LauncherEngine newInstance(boolean clientInstance) {
        return new LauncherEngine(clientInstance);
    }

    public ECPublicKey getClientPublicKey() {
        return this.publicKey;
    }

    public byte[] sign(byte[] bytes) {
        return SecurityHelper.sign((byte[])bytes, (ECPrivateKey)this.privateKey);
    }

    public void readKeys() throws IOException, InvalidKeySpecException {
        if (this.privateKey != null || this.publicKey != null) {
            return;
        }
        Path dir = DirBridge.dir;
        Path publicKeyFile = dir.resolve("public.key");
        Path privateKeyFile = dir.resolve("private.key");
        if (IOHelper.isFile((Path)publicKeyFile) && IOHelper.isFile((Path)privateKeyFile)) {
            LogHelper.info((String)"Reading EC keypair");
            this.publicKey = SecurityHelper.toPublicECDSAKey((byte[])IOHelper.read((Path)publicKeyFile));
            this.privateKey = SecurityHelper.toPrivateECDSAKey((byte[])IOHelper.read((Path)privateKeyFile));
        } else {
            LogHelper.info((String)"Generating EC keypair");
            KeyPair pair = SecurityHelper.genECDSAKeyPair((SecureRandom)new SecureRandom());
            this.publicKey = (ECPublicKey)pair.getPublic();
            this.privateKey = (ECPrivateKey)pair.getPrivate();
            LogHelper.info((String)"Writing EC keypair list");
            IOHelper.write((Path)publicKeyFile, (byte[])this.publicKey.getEncoded());
            IOHelper.write((Path)privateKeyFile, (byte[])this.privateKey.getEncoded());
        }
    }

    public void start(String ... args) throws Throwable {
        guard = LauncherEngine.tryGetStdGuard();
        ClientPreGuiPhase event = new ClientPreGuiPhase(null);
        modulesManager.invokeEvent(event);
        this.runtimeProvider = event.runtimeProvider;
        if (this.runtimeProvider == null) {
            this.runtimeProvider = new NoRuntimeProvider();
        }
        this.runtimeProvider.init(this.clientInstance);
        if (!Request.isAvailable()) {
            RequestService service;
            String address = Launcher.getConfig().address;
            LogHelper.debug((String)"Start async connection to %s", (Object[])new Object[]{address});
            try {
                service = (RequestService)StdWebSocketService.initWebSockets((String)address).get();
            }
            catch (Throwable e) {
                if (LogHelper.isDebugEnabled()) {
                    LogHelper.error((Throwable)e);
                }
                LogHelper.warning((String)"Launcher in offline mode");
                service = LauncherEngine.initOffline();
            }
            Request.setRequestService((RequestService)service);
            if (service instanceof StdWebSocketService) {
                ((StdWebSocketService)service).reconnectCallback = () -> {
                    LogHelper.debug((String)"WebSocket connect closed. Try reconnect");
                    try {
                        Request.reconnect();
                    }
                    catch (Exception e) {
                        LogHelper.error((Throwable)e);
                        throw new RequestException("Connection failed", (Throwable)e);
                    }
                };
            }
            service.registerEventHandler((RequestService.EventHandler)new BasicLauncherEventHandler());
        }
        Objects.requireNonNull(args, "args");
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException("Launcher has been already started");
        }
        this.readKeys();
        this.registerCommands();
        modulesManager.invokeEvent((LauncherModule.Event)new ClientEngineInitPhase(this));
        this.runtimeProvider.preLoad();
        LogHelper.debug((String)"Dir: %s", (Object[])new Object[]{DirBridge.dir});
        this.runtimeProvider.run(args);
    }

    private void registerCommands() {
        ConsoleManager.handler.registerCommand("getpublickey", (Command)new GetPublicKeyCommand(this));
        ConsoleManager.handler.registerCommand("signdata", (Command)new SignDataCommand(this));
        ConsoleManager.handler.registerCommand("modules", (Command)new ModulesCommand());
    }
}

