/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.console;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.LauncherTrustManager;
import pro.gravit.launcher.managers.ConsoleManager;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.LauncherModuleInfo;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.helper.LogHelper;

public class ModulesCommand
extends Command {
    public String getArgsDescription() {
        return "[]";
    }

    public String getUsageDescription() {
        return "show modules";
    }

    public void invoke(String ... args) throws Exception {
        for (LauncherModule module : LauncherEngine.modulesManager.getModules()) {
            LauncherModuleInfo info = module.getModuleInfo();
            LauncherTrustManager.CheckClassResult checkStatus = module.getCheckResult();
            if (!ConsoleManager.isConsoleUnlock) {
                LogHelper.info((String)"[MODULE] %s v: %s", (Object[])new Object[]{info.name, info.version.getVersionString()});
                continue;
            }
            LogHelper.info((String)"[MODULE] %s v: %s p: %d deps: %s sig: %s", (Object[])new Object[]{info.name, info.version.getVersionString(), info.priority, Arrays.toString(info.dependencies), checkStatus == null ? "null" : checkStatus.type});
            this.printCheckStatusInfo(checkStatus);
        }
    }

    private void printCheckStatusInfo(LauncherTrustManager.CheckClassResult checkStatus) {
        X509Certificate cert;
        if (checkStatus != null && checkStatus.endCertificate != null) {
            cert = checkStatus.endCertificate;
            LogHelper.info((String)"[MODULE CERT] Module signer: %s", (Object[])new Object[]{cert.getSubjectX500Principal().getName()});
        }
        if (checkStatus != null && checkStatus.rootCertificate != null) {
            cert = checkStatus.rootCertificate;
            LogHelper.info((String)"[MODULE CERT] Module signer CA: %s", (Object[])new Object[]{cert.getSubjectX500Principal().getName()});
        }
    }
}

