/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;

public class ClientClassLoader
extends URLClassLoader {
    private static final ClassLoader SYSTEM_CLASS_LOADER = ClassLoader.getSystemClassLoader();
    public String nativePath;
    private final List<String> packages = new ArrayList<String>();

    public ClientClassLoader(URL[] urls) {
        super(urls);
        this.packages.add("pro.gravit.launcher.");
        this.packages.add("pro.gravit.utils.");
    }

    public ClientClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name != null) {
            for (String pkg : this.packages) {
                if (!name.startsWith(pkg)) continue;
                return SYSTEM_CLASS_LOADER.loadClass(name);
            }
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public String findLibrary(String name) {
        return this.nativePath.concat(IOHelper.PLATFORM_SEPARATOR).concat(this.getNativePrefix()).concat(name).concat(this.getNativeEx());
    }

    public String getNativeEx() {
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE) {
            return ".dll";
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
            return ".so";
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MACOSX) {
            return ".dylib";
        }
        return "";
    }

    public String getNativePrefix() {
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
            return "lib";
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MACOSX) {
            return "lib";
        }
        return "";
    }

    public void addAllowedPackage(String pkg) {
        this.packages.add(pkg);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }
}

