/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pro.gravit.launcher.BasicLauncherEventHandler;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherAgent;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.api.AuthService;
import pro.gravit.launcher.api.ClientService;
import pro.gravit.launcher.api.KeyService;
import pro.gravit.launcher.client.ClientClassLoader;
import pro.gravit.launcher.client.ClientLauncherCoreModule;
import pro.gravit.launcher.client.ClientLauncherProcess;
import pro.gravit.launcher.client.ClientModuleManager;
import pro.gravit.launcher.client.events.client.ClientProcessClassLoaderEvent;
import pro.gravit.launcher.client.events.client.ClientProcessInitPhase;
import pro.gravit.launcher.client.events.client.ClientProcessLaunchEvent;
import pro.gravit.launcher.client.events.client.ClientProcessPreInvokeMainClassEvent;
import pro.gravit.launcher.client.events.client.ClientProcessReadyEvent;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.events.request.ProfileByUUIDRequestEvent;
import pro.gravit.launcher.events.request.ProfileByUsernameRequestEvent;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.hasher.HashedEntry;
import pro.gravit.launcher.managers.ClientGsonManager;
import pro.gravit.launcher.managers.ConsoleManager;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.LauncherModulesManager;
import pro.gravit.launcher.modules.events.OfflineModeEvent;
import pro.gravit.launcher.modules.events.PreConfigPhase;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.ClientProfileVersions;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.profiles.optional.actions.OptionalActionClassPath;
import pro.gravit.launcher.profiles.optional.actions.OptionalActionClientArgs;
import pro.gravit.launcher.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.RequestService;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launcher.request.uuid.ProfileByUUIDRequest;
import pro.gravit.launcher.request.uuid.ProfileByUsernameRequest;
import pro.gravit.launcher.request.websockets.OfflineRequestService;
import pro.gravit.launcher.request.websockets.StdWebSocketService;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.utils.DirWatcher;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class ClientLauncherEntryPoint {
    private static ClassLoader classLoader;

    private static ClientLauncherProcess.ClientParams readParams(SocketAddress address) throws IOException {
        try (Socket socket = IOHelper.newSocket();){
            ClientLauncherProcess.ClientParams clientParams;
            socket.connect(address);
            try (HInput input = new HInput(socket.getInputStream());){
                byte[] serialized = input.readByteArray(0);
                ClientLauncherProcess.ClientParams params = (ClientLauncherProcess.ClientParams)Launcher.gsonManager.gson.fromJson(IOHelper.decode((byte[])serialized), ClientLauncherProcess.ClientParams.class);
                params.clientHDir = new HashedDir(input);
                params.assetHDir = new HashedDir(input);
                boolean isNeedReadJavaDir = input.readBoolean();
                if (isNeedReadJavaDir) {
                    params.javaHDir = new HashedDir(input);
                }
                clientParams = params;
            }
            return clientParams;
        }
    }

    public static void main(String[] args) throws Throwable {
        RequestService service;
        ClientProfile profile;
        LauncherEngine engine = LauncherEngine.clientInstance();
        JVMHelper.verifySystemProperties(ClientLauncherEntryPoint.class, (boolean)true);
        EnvHelper.checkDangerousParams();
        JVMHelper.checkStackTrace(ClientLauncherEntryPoint.class);
        LogHelper.printVersion((String)"Client Launcher");
        LauncherEngine.checkClass(LauncherEngine.class);
        LauncherEngine.checkClass(LauncherAgent.class);
        LauncherEngine.checkClass(ClientLauncherEntryPoint.class);
        LauncherEngine.modulesManager = new ClientModuleManager();
        LauncherEngine.modulesManager.loadModule(new ClientLauncherCoreModule());
        LauncherConfig.initModules((LauncherModulesManager)LauncherEngine.modulesManager);
        LauncherEngine.modulesManager.initModules(null);
        ClientLauncherEntryPoint.initGson(LauncherEngine.modulesManager);
        ConsoleManager.initConsole();
        LauncherEngine.modulesManager.invokeEvent((LauncherModule.Event)new PreConfigPhase());
        engine.readKeys();
        LogHelper.debug((String)"Reading ClientLauncher params");
        ClientLauncherProcess.ClientParams params = ClientLauncherEntryPoint.readParams(new InetSocketAddress("127.0.0.1", Launcher.getConfig().clientPort));
        if (params.profile.getClassLoaderConfig() != ClientProfile.ClassLoaderConfig.AGENT) {
            LauncherEngine.verifyNoAgent();
        }
        Launcher.profile = profile = params.profile;
        AuthService.profile = profile;
        LauncherEngine.clientParams = params;
        if (params.oauth != null) {
            LogHelper.info((String)"Using OAuth");
            if (params.oauthExpiredTime != 0L) {
                Request.setOAuth((String)params.authId, (AuthRequestEvent.OAuthRequestEvent)params.oauth, (long)params.oauthExpiredTime);
            } else {
                Request.setOAuth((String)params.authId, (AuthRequestEvent.OAuthRequestEvent)params.oauth);
            }
            if (params.extendedTokens != null) {
                Request.addAllExtendedToken(params.extendedTokens);
            }
        } else if (params.session != null) {
            throw new UnsupportedOperationException("Legacy session not supported");
        }
        LauncherEngine.modulesManager.invokeEvent((LauncherModule.Event)new ClientProcessInitPhase(engine, params));
        Path clientDir = Paths.get(params.clientDir, new String[0]);
        Path assetDir = Paths.get(params.assetDir, new String[0]);
        LogHelper.debug((String)"Verifying ClientLauncher sign and classpath");
        List classpath = ClientLauncherEntryPoint.resolveClassPath(clientDir, params.actions, params.profile).filter(x -> !profile.getModulePath().contains(clientDir.relativize((Path)x).toString())).collect(Collectors.toList());
        List<URL> classpathURLs = classpath.stream().map(IOHelper::toURL).collect(Collectors.toList());
        if (params.offlineMode) {
            service = ClientLauncherEntryPoint.initOffline((LauncherModulesManager)LauncherEngine.modulesManager, params);
            Request.setRequestService((RequestService)service);
        } else {
            service = (RequestService)StdWebSocketService.initWebSockets((String)Launcher.getConfig().address).get();
            Request.setRequestService((RequestService)service);
            LogHelper.debug((String)"Restore sessions");
            Request.restore();
            service.registerEventHandler((RequestService.EventHandler)new BasicLauncherEventHandler());
            ((StdWebSocketService)service).reconnectCallback = () -> {
                LogHelper.debug((String)"WebSocket connect closed. Try reconnect");
                try {
                    Request.reconnect();
                }
                catch (Exception e) {
                    LogHelper.error((Throwable)e);
                    throw new RequestException("Connection failed", (Throwable)e);
                }
            };
        }
        LogHelper.debug((String)"Natives dir %s", (Object[])new Object[]{params.nativesDir});
        ClientProfile.ClassLoaderConfig classLoaderConfig = profile.getClassLoaderConfig();
        if (classLoaderConfig == ClientProfile.ClassLoaderConfig.LAUNCHER) {
            ClientClassLoader classLoader = new ClientClassLoader(classpathURLs.toArray(new URL[0]), ClientLauncherEntryPoint.class.getClassLoader());
            System.setProperty("java.class.path", classpath.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
            ClientLauncherEntryPoint.classLoader = classLoader;
            Thread.currentThread().setContextClassLoader(classLoader);
            classLoader.nativePath = params.nativesDir;
            LauncherEngine.modulesManager.invokeEvent(new ClientProcessClassLoaderEvent(engine, classLoader, profile));
            ClientService.classLoader = classLoader;
            ClientService.nativePath = classLoader.nativePath;
            classLoader.addURL(IOHelper.getCodeSource(ClientLauncherEntryPoint.class).toUri().toURL());
            ClientService.baseURLs = classLoader.getURLs();
        } else if (classLoaderConfig == ClientProfile.ClassLoaderConfig.AGENT) {
            classLoader = ClassLoader.getSystemClassLoader();
            classpathURLs.add(IOHelper.getCodeSource(ClientLauncherEntryPoint.class).toUri().toURL());
            for (URL url : classpathURLs) {
                LauncherAgent.addJVMClassPath(Paths.get(url.toURI()));
            }
            ClientService.instrumentation = LauncherAgent.inst;
            ClientService.nativePath = params.nativesDir;
            LauncherEngine.modulesManager.invokeEvent(new ClientProcessClassLoaderEvent(engine, classLoader, profile));
            ClientService.classLoader = classLoader;
            ClientService.baseURLs = classpathURLs.toArray(new URL[0]);
        } else if (classLoaderConfig == ClientProfile.ClassLoaderConfig.SYSTEM_ARGS) {
            classLoader = ClassLoader.getSystemClassLoader();
            ClientService.classLoader = ClassLoader.getSystemClassLoader();
            ClientService.baseURLs = classpathURLs.toArray(new URL[0]);
            ClientService.nativePath = params.nativesDir;
        }
        AuthService.username = params.playerProfile.username;
        AuthService.uuid = params.playerProfile.uuid;
        KeyService.serverRsaPublicKey = Launcher.getConfig().rsaPublicKey;
        LauncherEngine.modulesManager.invokeEvent((LauncherModule.Event)new ClientProcessReadyEvent(engine, params));
        LogHelper.debug((String)"Starting JVM and client WatchService");
        FileNameMatcher assetMatcher = profile.getAssetUpdateMatcher();
        FileNameMatcher clientMatcher = profile.getClientUpdateMatcher();
        Path javaDir = Paths.get(System.getProperty("java.home"), new String[0]);
        try (DirWatcher assetWatcher = new DirWatcher(assetDir, params.assetHDir, assetMatcher, true);
             DirWatcher clientWatcher = new DirWatcher(clientDir, params.clientHDir, clientMatcher, true);
             DirWatcher javaWatcher = params.javaHDir == null ? null : new DirWatcher(javaDir, params.javaHDir, null, true);){
            CommonHelper.newThread((String)"Asset Directory Watcher", (boolean)true, (Runnable)assetWatcher).start();
            CommonHelper.newThread((String)"Client Directory Watcher", (boolean)true, (Runnable)clientWatcher).start();
            if (javaWatcher != null) {
                CommonHelper.newThread((String)"Java Directory Watcher", (boolean)true, (Runnable)javaWatcher).start();
            }
            ClientLauncherEntryPoint.verifyHDir(assetDir, params.assetHDir, assetMatcher, false, false);
            ClientLauncherEntryPoint.verifyHDir(clientDir, params.clientHDir, clientMatcher, false, true);
            if (javaWatcher != null) {
                ClientLauncherEntryPoint.verifyHDir(javaDir, params.javaHDir, null, false, true);
            }
            LauncherEngine.modulesManager.invokeEvent(new ClientProcessLaunchEvent(engine, params));
            ClientLauncherEntryPoint.launch(profile, params);
        }
    }

    private static void initGson(ClientModuleManager moduleManager) {
        AuthRequest.registerProviders();
        GetAvailabilityAuthRequest.registerProviders();
        OptionalAction.registerProviders();
        OptionalTrigger.registerProviders();
        Launcher.gsonManager = new ClientGsonManager(moduleManager);
        Launcher.gsonManager.initGson();
    }

    public static RequestService initOffline(LauncherModulesManager modulesManager, ClientLauncherProcess.ClientParams params) {
        OfflineRequestService service = new OfflineRequestService();
        LauncherEngine.applyBasicOfflineProcessors(service);
        ClientLauncherEntryPoint.applyClientOfflineProcessors(service, params);
        OfflineModeEvent event = new OfflineModeEvent((RequestService)service);
        modulesManager.invokeEvent((LauncherModule.Event)event);
        return event.service;
    }

    public static void applyClientOfflineProcessors(OfflineRequestService service, ClientLauncherProcess.ClientParams params) {
        service.registerRequestProcessor(ProfileByUsernameRequest.class, r -> {
            if (params.playerProfile.username.equals(r.username)) {
                return new ProfileByUsernameRequestEvent(params.playerProfile);
            }
            throw new RequestException("User not found");
        });
        service.registerRequestProcessor(ProfileByUUIDRequest.class, r -> {
            if (params.playerProfile.uuid.equals(r.uuid)) {
                return new ProfileByUUIDRequestEvent(params.playerProfile);
            }
            throw new RequestException("User not found");
        });
    }

    public static void verifyHDir(Path dir, HashedDir hdir, FileNameMatcher matcher, boolean digest, boolean checkExtra) throws IOException {
        HashedDir currentHDir = new HashedDir(dir, matcher, true, digest);
        HashedDir.Diff diff = hdir.diff(currentHDir, matcher);
        AtomicReference<String> latestPath = new AtomicReference<String>("unknown");
        if (!diff.mismatch.isEmpty() || checkExtra && !diff.extra.isEmpty()) {
            diff.extra.walk((CharSequence)File.separator, (e, k, v) -> {
                if (v.getType().equals((Object)HashedEntry.Type.FILE)) {
                    LogHelper.error((String)"Extra file %s", (Object[])new Object[]{e});
                    latestPath.set(e);
                } else {
                    LogHelper.error((String)"Extra %s", (Object[])new Object[]{e});
                }
                return HashedDir.WalkAction.CONTINUE;
            });
            diff.mismatch.walk((CharSequence)File.separator, (e, k, v) -> {
                if (v.getType().equals((Object)HashedEntry.Type.FILE)) {
                    LogHelper.error((String)"Mismatch file %s", (Object[])new Object[]{e});
                    latestPath.set(e);
                } else {
                    LogHelper.error((String)"Mismatch %s", (Object[])new Object[]{e});
                }
                return HashedDir.WalkAction.CONTINUE;
            });
            throw new SecurityException(String.format("Forbidden modification: '%s' file '%s'", IOHelper.getFileName((Path)dir), latestPath.get()));
        }
    }

    private static LinkedList<Path> resolveClassPathList(Path clientDir, String ... classPath) throws IOException {
        return ClientLauncherEntryPoint.resolveClassPathStream(clientDir, classPath).collect(Collectors.toCollection(LinkedList::new));
    }

    private static Stream<Path> resolveClassPathStream(Path clientDir, String ... classPath) throws IOException {
        Stream.Builder<Path> builder = Stream.builder();
        for (String classPathEntry : classPath) {
            Path path = clientDir.resolve(IOHelper.toPath((String)classPathEntry.replace("/", IOHelper.PLATFORM_SEPARATOR)));
            if (IOHelper.isDir((Path)path)) {
                IOHelper.walk((Path)path, (FileVisitor)new ClassPathFileVisitor(builder), (boolean)false);
                continue;
            }
            builder.accept(path);
        }
        return builder.build();
    }

    public static Stream<Path> resolveClassPath(Path clientDir, Set<OptionalAction> actions, ClientProfile profile) throws IOException {
        Stream<Path> result = ClientLauncherEntryPoint.resolveClassPathStream(clientDir, profile.getClassPath());
        for (OptionalAction a : actions) {
            if (!(a instanceof OptionalActionClassPath)) continue;
            result = Stream.concat(result, ClientLauncherEntryPoint.resolveClassPathStream(clientDir, ((OptionalActionClassPath)a).args));
        }
        return result;
    }

    private static void launch(ClientProfile profile, ClientLauncherProcess.ClientParams params) throws Throwable {
        LinkedList<String> args = new LinkedList<String>();
        if (profile.getVersion().compareTo(ClientProfileVersions.MINECRAFT_1_6_4) >= 0) {
            params.addClientArgs(args);
        } else {
            params.addClientLegacyArgs(args);
            System.setProperty("minecraft.applet.TargetDirectory", params.clientDir);
        }
        Collections.addAll(args, profile.getClientArgs());
        for (OptionalAction action : params.actions) {
            if (!(action instanceof OptionalActionClientArgs)) continue;
            args.addAll(((OptionalActionClientArgs)action).args);
        }
        ArrayList<String> copy = new ArrayList<String>(args);
        int l = copy.size();
        for (int i = 0; i < l; ++i) {
            String s = (String)copy.get(i);
            if (i + 1 >= l || !"--accessToken".equals(s) && !"--session".equals(s)) continue;
            copy.set(i + 1, "censored");
        }
        LogHelper.debug((String)("Args: " + copy));
        Class<?> mainClass = classLoader.loadClass(profile.getMainClass());
        if (LogHelper.isDevEnabled() && classLoader instanceof URLClassLoader) {
            for (URL u : ((URLClassLoader)classLoader).getURLs()) {
                LogHelper.dev((String)"ClassLoader URL: %s", (Object[])new Object[]{u.toString()});
            }
        }
        LauncherEngine.modulesManager.invokeEvent(new ClientProcessPreInvokeMainClassEvent(params, profile, args));
        try {
            List compatClasses = profile.getCompatClasses();
            for (String e : compatClasses) {
                Class<?> clazz = classLoader.loadClass(e);
                MethodHandle runMethod = MethodHandles.lookup().findStatic(clazz, "run", MethodType.methodType(Void.TYPE));
                runMethod.invoke();
            }
            MethodHandle mainMethod = MethodHandles.lookup().findStatic(mainClass, "main", MethodType.methodType(Void.TYPE, String[].class)).asFixedArity();
            Launcher.LAUNCHED.set(true);
            JVMHelper.fullGC();
            mainMethod.invokeWithArguments(new Object[]{args.toArray(new String[0])});
            LogHelper.debug((String)"Main exit successful");
        }
        catch (Throwable e) {
            LogHelper.error((Throwable)e);
            throw e;
        }
        finally {
            LauncherEngine.exitLauncher(0);
        }
    }

    private static final class ClassPathFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Stream.Builder<Path> result;

        private ClassPathFileVisitor(Stream.Builder<Path> result) {
            this.result = result;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (IOHelper.hasExtension((Path)file, (String)"jar") || IOHelper.hasExtension((Path)file, (String)"zip")) {
                this.result.accept(file);
            }
            return super.visitFile(file, attrs);
        }
    }
}

