/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import pro.gravit.launcher.BasicLauncherEventHandler;
import pro.gravit.launcher.ClientLauncherMethods;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherAgent;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.LauncherEngineWrapper;
import pro.gravit.launcher.LauncherTrustManager;
import pro.gravit.launcher.client.ClientLauncherEntryPoint;
import pro.gravit.launcher.client.ClientParams;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.RuntimeGsonManager;
import pro.gravit.launcher.client.RuntimeLauncherCoreModule;
import pro.gravit.launcher.client.RuntimeModuleManager;
import pro.gravit.launcher.client.events.ClientEngineInitPhase;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.client.events.ClientPreGuiPhase;
import pro.gravit.launcher.console.GetPublicKeyCommand;
import pro.gravit.launcher.console.ModulesCommand;
import pro.gravit.launcher.console.SignDataCommand;
import pro.gravit.launcher.gui.NoRuntimeProvider;
import pro.gravit.launcher.gui.RuntimeProvider;
import pro.gravit.launcher.managers.ConsoleManager;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.LauncherModulesManager;
import pro.gravit.launcher.modules.events.OfflineModeEvent;
import pro.gravit.launcher.modules.events.PreConfigPhase;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.RequestService;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launcher.request.websockets.OfflineRequestService;
import pro.gravit.launcher.request.websockets.StdWebSocketService;
import pro.gravit.launcher.utils.NativeJVMHalt;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class LauncherEngine {
    public static ClientParams clientParams;
    public static RuntimeModuleManager modulesManager;
    public final boolean clientInstance;
    private final AtomicBoolean started = new AtomicBoolean(false);
    public RuntimeProvider runtimeProvider;
    public ECPublicKey publicKey;
    public ECPrivateKey privateKey;
    public Class<? extends RuntimeProvider> basicRuntimeProvider;

    private LauncherEngine(boolean clientInstance, Class<? extends RuntimeProvider> basicRuntimeProvider) {
        this.clientInstance = clientInstance;
        this.basicRuntimeProvider = basicRuntimeProvider;
    }

    public static X509Certificate[] getCertificates(Class<?> clazz) {
        Object[] signers = clazz.getSigners();
        if (signers == null) {
            return null;
        }
        return (X509Certificate[])Arrays.stream(signers).filter(c -> c instanceof X509Certificate).map(c -> (X509Certificate)c).toArray(X509Certificate[]::new);
    }

    public static void checkClass(Class<?> clazz) throws SecurityException {
        LauncherTrustManager trustManager = Launcher.getConfig().trustManager;
        if (trustManager == null) {
            return;
        }
        X509Certificate[] certificates = LauncherEngine.getCertificates(clazz);
        if (certificates == null) {
            throw new SecurityException(String.format("Class %s not signed", clazz.getName()));
        }
        try {
            trustManager.checkCertificatesSuccess(certificates, (arg_0, arg_1, arg_2) -> ((LauncherTrustManager)trustManager).stdCertificateChecker(arg_0, arg_1, arg_2));
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static void beforeExit(int code) {
        try {
            modulesManager.invokeEvent((LauncherModule.Event)new ClientExitPhase(code));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void forceExit(int code) {
        try {
            System.exit(code);
        }
        catch (Throwable e) {
            NativeJVMHalt.haltA((int)code);
        }
    }

    public static void exitLauncher(int code) {
        LauncherEngine.beforeExit(code);
        LauncherEngine.forceExit(code);
    }

    public static boolean contains(String[] array, String value) {
        for (String s : array) {
            if (!s.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static void main(String ... args) throws Throwable {
        JVMHelper.checkStackTrace(LauncherEngineWrapper.class);
        JVMHelper.verifySystemProperties(Launcher.class, (boolean)true);
        EnvHelper.checkDangerousParams();
        LauncherEngine.verifyNoAgent();
        if (LauncherEngine.contains(args, "--log-output") && Launcher.getConfig().environment != LauncherConfig.LauncherEnvironment.PROD) {
            LogHelper.addOutput((Path)Paths.get("Launcher.log", new String[0]));
        }
        LogHelper.printVersion((String)"Launcher");
        LogHelper.printLicense((String)"Launcher");
        LauncherEngine.checkClass(LauncherEngineWrapper.class);
        LauncherEngine.checkClass(LauncherEngine.class);
        LauncherEngine.checkClass(LauncherAgent.class);
        LauncherEngine.checkClass(ClientLauncherEntryPoint.class);
        modulesManager = new RuntimeModuleManager();
        modulesManager.loadModule((LauncherModule)new RuntimeLauncherCoreModule());
        LauncherConfig.initModules((LauncherModulesManager)modulesManager);
        modulesManager.initModules(null);
        LauncherEngine.initGson(modulesManager);
        ConsoleManager.initConsole();
        modulesManager.invokeEvent((LauncherModule.Event)new PreConfigPhase());
        Launcher.getConfig();
        long startTime = System.currentTimeMillis();
        try {
            LauncherEngine.newInstance(false).start(args);
        }
        catch (Exception e) {
            LogHelper.error((Throwable)e);
            return;
        }
        long endTime = System.currentTimeMillis();
        LogHelper.debug((String)"Launcher started in %dms", (Object[])new Object[]{endTime - startTime});
        LauncherEngine.exitLauncher(0);
    }

    public static void initGson(RuntimeModuleManager modulesManager) {
        AuthRequest.registerProviders();
        GetAvailabilityAuthRequest.registerProviders();
        OptionalAction.registerProviders();
        OptionalTrigger.registerProviders();
        Launcher.gsonManager = new RuntimeGsonManager(modulesManager);
        Launcher.gsonManager.initGson();
    }

    public static void verifyNoAgent() {
        if (JVMHelper.RUNTIME_MXBEAN.getInputArguments().stream().filter(e -> e != null && !e.isEmpty()).anyMatch(e -> e.contains("javaagent"))) {
            throw new SecurityException("JavaAgent found");
        }
    }

    public static RequestService initOffline() {
        OfflineRequestService service = new OfflineRequestService();
        ClientLauncherMethods.applyBasicOfflineProcessors((OfflineRequestService)service);
        OfflineModeEvent event = new OfflineModeEvent((RequestService)service);
        modulesManager.invokeEvent((LauncherModule.Event)event);
        return event.service;
    }

    public static LauncherEngine newInstance(boolean clientInstance) {
        return new LauncherEngine(clientInstance, NoRuntimeProvider.class);
    }

    public static LauncherEngine newInstance(boolean clientInstance, Class<? extends RuntimeProvider> basicRuntimeProvider) {
        return new LauncherEngine(clientInstance, basicRuntimeProvider);
    }

    public ECPublicKey getClientPublicKey() {
        return this.publicKey;
    }

    public byte[] sign(byte[] bytes) {
        return SecurityHelper.sign((byte[])bytes, (ECPrivateKey)this.privateKey);
    }

    public void readKeys() throws IOException, InvalidKeySpecException {
        if (this.privateKey != null || this.publicKey != null) {
            return;
        }
        Path dir = DirBridge.dir;
        Path publicKeyFile = dir.resolve("public.key");
        Path privateKeyFile = dir.resolve("private.key");
        if (IOHelper.isFile((Path)publicKeyFile) && IOHelper.isFile((Path)privateKeyFile)) {
            LogHelper.info((String)"Reading EC keypair");
            this.publicKey = SecurityHelper.toPublicECDSAKey((byte[])IOHelper.read((Path)publicKeyFile));
            this.privateKey = SecurityHelper.toPrivateECDSAKey((byte[])IOHelper.read((Path)privateKeyFile));
        } else {
            LogHelper.info((String)"Generating EC keypair");
            KeyPair pair = SecurityHelper.genECDSAKeyPair((SecureRandom)new SecureRandom());
            this.publicKey = (ECPublicKey)pair.getPublic();
            this.privateKey = (ECPrivateKey)pair.getPrivate();
            LogHelper.info((String)"Writing EC keypair list");
            IOHelper.write((Path)publicKeyFile, (byte[])this.publicKey.getEncoded());
            IOHelper.write((Path)privateKeyFile, (byte[])this.privateKey.getEncoded());
        }
    }

    public void start(String ... args) throws Throwable {
        ClientPreGuiPhase event = new ClientPreGuiPhase(null);
        modulesManager.invokeEvent((LauncherModule.Event)event);
        this.runtimeProvider = event.runtimeProvider;
        if (this.runtimeProvider == null) {
            this.runtimeProvider = this.basicRuntimeProvider.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        this.runtimeProvider.init(this.clientInstance);
        if (!Request.isAvailable()) {
            RequestService service;
            String address = Launcher.getConfig().address;
            LogHelper.debug((String)"Start async connection to %s", (Object[])new Object[]{address});
            try {
                service = (RequestService)StdWebSocketService.initWebSockets((String)address).get();
            }
            catch (Throwable e) {
                if (LogHelper.isDebugEnabled()) {
                    LogHelper.error((Throwable)e);
                }
                LogHelper.warning((String)"Launcher in offline mode");
                service = LauncherEngine.initOffline();
            }
            Request.setRequestService((RequestService)service);
            if (service instanceof StdWebSocketService) {
                ((StdWebSocketService)service).reconnectCallback = () -> {
                    LogHelper.debug((String)"WebSocket connect closed. Try reconnect");
                    try {
                        Request.reconnect();
                    }
                    catch (Exception e) {
                        LogHelper.error((Throwable)e);
                        throw new RequestException("Connection failed", (Throwable)e);
                    }
                };
            }
        }
        Request.startAutoRefresh();
        Request.getRequestService().registerEventHandler((RequestService.EventHandler)new BasicLauncherEventHandler());
        Objects.requireNonNull(args, "args");
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException("Launcher has been already started");
        }
        this.readKeys();
        this.registerCommands();
        modulesManager.invokeEvent((LauncherModule.Event)new ClientEngineInitPhase(this));
        this.runtimeProvider.preLoad();
        LogHelper.debug((String)"Dir: %s", (Object[])new Object[]{DirBridge.dir});
        this.runtimeProvider.run(args);
    }

    private void registerCommands() {
        ConsoleManager.handler.registerCommand("getpublickey", (Command)new GetPublicKeyCommand(this));
        ConsoleManager.handler.registerCommand("signdata", (Command)new SignDataCommand(this));
        ConsoleManager.handler.registerCommand("modules", (Command)new ModulesCommand());
    }
}

