/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.launch.ClassLoaderControl;
import pro.gravit.utils.launch.LaunchOptions;
import pro.gravit.utils.launch.ModuleLaunch;

@LauncherNetworkAPI
public class LauncherEngineWrapper {
    private static final List<String> modules = new ArrayList<String>();

    public static void main(String[] args) throws Throwable {
        ModuleLaunch launch = new ModuleLaunch();
        LaunchOptions options = new LaunchOptions();
        options.disablePackageDelegateSupport = true;
        options.moduleConf = new LaunchOptions.ModuleConf();
        ArrayList<Path> classpath = new ArrayList<Path>();
        classpath.add(IOHelper.getCodeSource(LauncherEngine.class));
        Path libDirectory = Path.of(System.getProperty("java.home"), new String[0]).resolve("lib");
        for (String moduleName : modules) {
            Path path = libDirectory.resolve(moduleName.concat(".jar"));
            if (!Files.exists(path, new LinkOption[0])) continue;
            options.moduleConf.modules.add(moduleName);
            options.moduleConf.modulePath.add(path.toAbsolutePath().toString());
        }
        ClassLoaderControl control = launch.init(classpath, null, options);
        launch.launch(LauncherEngine.class.getName(), null, List.of(args));
    }

    static {
        modules.add("javafx.base");
        modules.add("javafx.graphics");
        modules.add("javafx.fxml");
        modules.add("javafx.controls");
        modules.add("javafx.media");
        modules.add("javafx.web");
    }
}

