/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.debug;

import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.api.AuthService;
import pro.gravit.launcher.api.ClientService;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.gui.RuntimeProvider;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.update.ProfilesRequest;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.launch.BasicLaunch;
import pro.gravit.utils.launch.ClassLoaderControl;
import pro.gravit.utils.launch.LaunchOptions;
import pro.gravit.utils.launch.LegacyLaunch;
import pro.gravit.utils.launch.ModuleLaunch;

public class ClientRuntimeProvider
implements RuntimeProvider {
    @Override
    public void run(String[] args) {
        ArrayList<String> newArgs = new ArrayList<String>(Arrays.asList(args));
        try {
            ClassLoaderControl classLoaderControl;
            LaunchOptions options;
            String username = System.getProperty("launcher.runtime.username", null);
            String uuid = System.getProperty("launcher.runtime.uuid", null);
            String login = System.getProperty("launcher.runtime.login", username);
            String password = System.getProperty("launcher.runtime.password", "Player");
            String authId = System.getProperty("launcher.runtime.auth.authid", "std");
            String accessToken = System.getProperty("launcher.runtime.auth.accesstoken", null);
            String refreshToken = System.getProperty("launcher.runtime.auth.refreshtoken", null);
            String minecraftAccessToken = System.getProperty("launcher.runtime.auth.minecraftaccesstoken", "DEBUG");
            long expire = Long.parseLong(System.getProperty("launcher.runtime.auth.expire", "0"));
            String profileUUID = System.getProperty("launcher.runtime.profileuuid", null);
            String mainClass = System.getProperty("launcher.runtime.mainclass", null);
            String mainModule = System.getProperty("launcher.runtime.mainmodule", null);
            String launchMode = System.getProperty("launcher.runtime.launch", "basic");
            String compatClasses = System.getProperty("launcher.runtime.launch.compat", null);
            String nativesDir = System.getProperty("launcher.runtime.launch.natives", "natives");
            String launcherOptionsPath = System.getProperty("launcher.runtime.launch.options", null);
            boolean enableHacks = Boolean.getBoolean("launcher.runtime.launch.enablehacks");
            ClientPermissions permissions = new ClientPermissions();
            if (mainClass == null) {
                throw new NullPointerException("Add `-Dlauncher.runtime.mainclass=YOUR_MAIN_CLASS` to jvmArgs");
            }
            if (uuid == null) {
                if (accessToken != null) {
                    Request.setOAuth((String)authId, (AuthRequestEvent.OAuthRequestEvent)new AuthRequestEvent.OAuthRequestEvent(accessToken, refreshToken, expire));
                    Request.RequestRestoreReport report = Request.restore((boolean)true, (boolean)false, (boolean)true);
                    permissions = report.userInfo.permissions;
                    username = report.userInfo.playerProfile.username;
                    uuid = report.userInfo.playerProfile.uuid.toString();
                    if (report.userInfo.accessToken != null) {
                        minecraftAccessToken = report.userInfo.accessToken;
                    }
                } else {
                    AuthRequest request = new AuthRequest(login, password, authId, AuthRequest.ConnectTypes.API);
                    AuthRequestEvent event = (AuthRequestEvent)request.request();
                    Request.setOAuth((String)authId, (AuthRequestEvent.OAuthRequestEvent)event.oauth);
                    if (event.accessToken != null) {
                        minecraftAccessToken = event.accessToken;
                    }
                    username = event.playerProfile.username;
                    uuid = event.playerProfile.uuid.toString();
                }
            }
            if (profileUUID != null) {
                UUID profileUuid = UUID.fromString(profileUUID);
                Object profiles = new ProfilesRequest();
                ProfilesRequestEvent event = (ProfilesRequestEvent)profiles.request();
                for (ClientProfile profile : event.profiles) {
                    if (!profile.getUUID().equals(profileUuid)) continue;
                    AuthService.profile = profile;
                }
            }
            if (username == null) {
                username = "Player";
            }
            if (uuid == null) {
                uuid = "a7899336-e61c-4e51-b480-0c815b18aed8";
            }
            this.replaceOrCreateArgument(newArgs, "--username", username);
            this.replaceOrCreateArgument(newArgs, "--uuid", uuid);
            this.replaceOrCreateArgument(newArgs, "--accessToken", minecraftAccessToken);
            AuthService.uuid = UUID.fromString(uuid);
            AuthService.username = username;
            AuthService.permissions = permissions;
            BasicLaunch launch = switch (launchMode) {
                case "basic" -> new BasicLaunch();
                case "legacy" -> new LegacyLaunch();
                case "module" -> new ModuleLaunch();
                default -> throw new UnsupportedOperationException(String.format("Unknown launch mode: '%s'", launchMode));
            };
            ArrayList<Path> classpath = new ArrayList<Path>();
            try {
                for (String c : System.getProperty("java.class.path").split(File.pathSeparator)) {
                    classpath.add(Paths.get(c, new String[0]));
                }
            }
            catch (Throwable e) {
                LogHelper.error((Throwable)e);
            }
            if (launcherOptionsPath != null) {
                try (BufferedReader reader = IOHelper.newReader((Path)Paths.get(launcherOptionsPath, new String[0]));){
                    options = (LaunchOptions)Launcher.gsonManager.gson.fromJson((Reader)reader, LaunchOptions.class);
                }
            } else {
                options = new LaunchOptions();
            }
            options.enableHacks = enableHacks;
            ClientService.classLoaderControl = classLoaderControl = launch.init(classpath, nativesDir, options);
            if (compatClasses != null) {
                String[] compatClassesList;
                for (String e : compatClassesList = compatClasses.split(",")) {
                    Class clazz = classLoaderControl.getClass(e);
                    MethodHandle runMethod = MethodHandles.lookup().findStatic(clazz, "run", MethodType.methodType(Void.TYPE, ClassLoaderControl.class));
                    runMethod.invoke(classLoaderControl);
                }
            }
            launch.launch(mainClass, mainModule, Arrays.asList(args));
        }
        catch (Throwable e) {
            LogHelper.error((Throwable)e);
            LauncherEngine.exitLauncher(-15);
        }
    }

    public void replaceOrCreateArgument(ArrayList<String> args, String name, String value) {
        int index = args.indexOf(name);
        if (index < 0) {
            args.add(name);
            if (value != null) {
                args.add(value);
            }
            return;
        }
        if (value != null) {
            int valueIndex = index + 1;
            args.set(valueIndex, value);
        }
    }

    @Override
    public void preLoad() {
    }

    @Override
    public void init(boolean clientInstance) {
    }
}

