/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.client;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.CipherOutputStream;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launcher.base.modules.LauncherModule;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.PlayerProfile;
import pro.gravit.launcher.base.profiles.optional.OptionalView;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalActionJvmArgs;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.client.ClientLauncherEntryPoint;
import pro.gravit.launcher.client.ClientParams;
import pro.gravit.launcher.core.hasher.HashedDir;
import pro.gravit.launcher.core.serialize.HOutput;
import pro.gravit.launcher.runtime.LauncherEngine;
import pro.gravit.launcher.runtime.client.events.ClientProcessBuilderCreateEvent;
import pro.gravit.launcher.runtime.client.events.ClientProcessBuilderLaunchedEvent;
import pro.gravit.launcher.runtime.client.events.ClientProcessBuilderParamsWrittedEvent;
import pro.gravit.launcher.runtime.client.events.ClientProcessBuilderPreLaunchEvent;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.JavaHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class ClientLauncherProcess {
    public final List<String> pre = new LinkedList<String>();
    public final ClientParams params = new ClientParams();
    public final List<String> jvmArgs = new LinkedList<String>();
    public final List<String> jvmModules = new LinkedList<String>();
    public final List<String> jvmModulesPaths = new LinkedList<String>();
    public final List<String> systemClientArgs = new LinkedList<String>();
    public final List<String> systemClassPath = new LinkedList<String>();
    public final Map<String, String> systemEnv = new HashMap<String, String>();
    public final String mainClass;
    private final transient Boolean[] waitWriteParams = new Boolean[]{false};
    public Path executeFile;
    public Path workDir;
    public JavaHelper.JavaVersion javaVersion;
    public boolean useLegacyJavaClassPathProperty;
    public boolean isStarted;
    private transient Process process;

    public ClientLauncherProcess(Path executeFile, Path workDir, JavaHelper.JavaVersion javaVersion, String mainClass) {
        this.executeFile = executeFile;
        this.workDir = workDir;
        this.javaVersion = javaVersion;
        this.mainClass = mainClass;
    }

    public ClientLauncherProcess(Path clientDir, Path assetDir, JavaHelper.JavaVersion javaVersion, ClientProfile profile, PlayerProfile playerProfile, String accessToken, HashedDir clientHDir, HashedDir assetHDir, HashedDir jvmHDir) {
        this(clientDir, assetDir, javaVersion, clientDir.resolve("resourcepacks"), profile, playerProfile, null, accessToken, clientHDir, assetHDir, jvmHDir);
    }

    public ClientLauncherProcess(Path clientDir, Path assetDir, ClientProfile profile, PlayerProfile playerProfile, String accessToken, HashedDir clientHDir, HashedDir assetHDir, HashedDir jvmHDir) {
        this(clientDir, assetDir, JavaHelper.JavaVersion.getCurrentJavaVersion(), clientDir.resolve("resourcepacks"), profile, playerProfile, null, accessToken, clientHDir, assetHDir, jvmHDir);
    }

    public ClientLauncherProcess(Path clientDir, Path assetDir, JavaHelper.JavaVersion javaVersion, Path resourcePackDir, ClientProfile profile, PlayerProfile playerProfile, OptionalView view, String accessToken, HashedDir clientHDir, HashedDir assetHDir, HashedDir jvmHDir) {
        this.javaVersion = javaVersion;
        this.workDir = clientDir.toAbsolutePath();
        this.executeFile = IOHelper.resolveJavaBin((Path)this.javaVersion.jvmDir);
        this.mainClass = ClientLauncherEntryPoint.class.getName();
        this.params.clientDir = this.workDir.toString();
        this.params.resourcePackDir = resourcePackDir.toAbsolutePath().toString();
        this.params.assetDir = assetDir.toAbsolutePath().toString();
        this.params.timestamp = System.currentTimeMillis();
        Path nativesPath = profile.hasFlag(ClientProfile.CompatibilityFlags.LEGACY_NATIVES_DIR) ? this.workDir.resolve("natives") : this.workDir.resolve("natives").resolve(JVMHelper.OS_TYPE.name).resolve(javaVersion.arch.name);
        if (!Files.isDirectory(nativesPath, new LinkOption[0])) {
            throw new RuntimeException(String.format("Natives dir %s not exist! Your operating system or architecture not supported", nativesPath.toAbsolutePath()));
        }
        this.params.nativesDir = nativesPath.toString();
        this.params.profile = profile;
        this.params.playerProfile = playerProfile;
        this.params.accessToken = accessToken;
        this.params.assetHDir = assetHDir;
        this.params.clientHDir = clientHDir;
        this.params.javaHDir = jvmHDir;
        if (view != null) {
            this.params.actions = view.getEnabledActions();
        }
        this.applyClientProfile();
    }

    public static String getPathSeparator() {
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE) {
            return ";";
        }
        return ":";
    }

    private void applyClientProfile() {
        this.systemClassPath.add(IOHelper.getCodeSource(ClientLauncherEntryPoint.class).toAbsolutePath().toString());
        Collections.addAll(this.jvmArgs, this.params.profile.getJvmArgs());
        for (OptionalAction a : this.params.actions) {
            if (!(a instanceof OptionalActionJvmArgs)) continue;
            this.jvmArgs.addAll(((OptionalActionJvmArgs)a).args);
        }
        this.systemEnv.put("JAVA_HOME", this.javaVersion.jvmDir.toString());
        Collections.addAll(this.systemClassPath, this.params.profile.getAlternativeClassPath());
        if (this.params.ram > 0) {
            this.jvmArgs.add("-Xmx" + this.params.ram + "M");
        }
        this.params.oauth = Request.getOAuth();
        if (this.params.oauth == null) {
            throw new UnsupportedOperationException("Legacy session not supported");
        }
        this.params.authId = Request.getAuthId();
        this.params.oauthExpiredTime = Request.getTokenExpiredTime();
        this.params.extendedTokens = Request.getExtendedTokens();
        this.jvmModules.addAll(this.params.profile.getModules());
        this.jvmModulesPaths.addAll(this.params.profile.getModulePath());
        LauncherEngine.modulesManager.invokeEvent((LauncherModule.Event)new ClientProcessBuilderCreateEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean pipeOutput) throws IOException, InterruptedException {
        if (this.isStarted) {
            throw new IllegalStateException("Process already started");
        }
        LauncherEngine.modulesManager.invokeEvent((LauncherModule.Event)new ClientProcessBuilderPreLaunchEvent(this));
        LinkedList<String> processArgs = new LinkedList<String>(this.pre);
        processArgs.add(this.executeFile.toString());
        processArgs.addAll(this.jvmArgs);
        if (this.javaVersion.version >= 9) {
            this.applyJava9Params(processArgs);
        }
        processArgs.add(JVMHelper.jvmProperty((String)"java.library.path", (String)this.params.nativesDir));
        if (this.params.profile.getClassLoaderConfig() == ClientProfile.ClassLoaderConfig.AGENT) {
            processArgs.add("-javaagent:".concat(IOHelper.getCodeSource(ClientLauncherEntryPoint.class).toAbsolutePath().toString()));
        } else if (this.params.profile.getClassLoaderConfig() == ClientProfile.ClassLoaderConfig.SYSTEM_ARGS) {
            this.systemClassPath.addAll(ClientLauncherEntryPoint.resolveClassPath((Path)this.workDir, (Set)this.params.actions, (ClientProfile)this.params.profile).filter(x -> !this.params.profile.getModulePath().contains(this.workDir.relativize((Path)x).toString())).map(Path::toString).toList());
        }
        if (Launcher.getConfig().environment != LauncherConfig.LauncherEnvironment.PROD) {
            processArgs.add(JVMHelper.jvmProperty((String)"launcher.dev", (String)String.valueOf(LogHelper.isDevEnabled())));
            processArgs.add(JVMHelper.jvmProperty((String)"launcher.debug", (String)String.valueOf(LogHelper.isDebugEnabled())));
            processArgs.add(JVMHelper.jvmProperty((String)"launcher.stacktrace", (String)String.valueOf(LogHelper.isStacktraceEnabled())));
        }
        if (this.useLegacyJavaClassPathProperty) {
            processArgs.add("-Djava.class.path=".concat(String.join((CharSequence)ClientLauncherProcess.getPathSeparator(), this.systemClassPath)));
        } else {
            processArgs.add("-cp");
            processArgs.add(String.join((CharSequence)ClientLauncherProcess.getPathSeparator(), this.systemClassPath));
        }
        processArgs.add(this.mainClass);
        processArgs.addAll(this.systemClientArgs);
        Boolean[] booleanArray = this.waitWriteParams;
        synchronized (this.waitWriteParams) {
            if (!this.waitWriteParams[0].booleanValue()) {
                this.waitWriteParams.wait(1000L);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (LogHelper.isDebugEnabled()) {
                LogHelper.debug((String)"Commandline: %s", (Object[])new Object[]{Arrays.toString(processArgs.toArray())});
            }
            ProcessBuilder processBuilder = new ProcessBuilder(processArgs);
            EnvHelper.addEnv((ProcessBuilder)processBuilder);
            if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
                Map<String, String> env = processBuilder.environment();
                env.put("__GL_THREADED_OPTIMIZATIONS", "0");
                if (this.params.lwjglGlfwWayland && !this.params.profile.hasFlag(ClientProfile.CompatibilityFlags.WAYLAND_USE_CUSTOM_GLFW)) {
                    env.remove("DISPLAY");
                }
            }
            processBuilder.environment().put("JAVA_HOME", this.javaVersion.jvmDir.toAbsolutePath().toString());
            processBuilder.environment().putAll(this.systemEnv);
            processBuilder.directory(this.workDir.toFile());
            processBuilder.inheritIO();
            if (pipeOutput) {
                processBuilder.redirectErrorStream(true);
                processBuilder.redirectOutput(ProcessBuilder.Redirect.PIPE);
            }
            this.process = processBuilder.start();
            LauncherEngine.modulesManager.invokeEvent((LauncherModule.Event)new ClientProcessBuilderLaunchedEvent(this));
            this.isStarted = true;
            return;
        }
    }

    private void applyJava9Params(List<String> processArgs) {
        StringBuilder modulesPath = new StringBuilder();
        StringBuilder modulesAdd = new StringBuilder();
        for (String moduleName : this.jvmModules) {
            if (!modulesAdd.isEmpty()) {
                modulesAdd.append(",");
            }
            modulesAdd.append(moduleName);
        }
        for (String modulePath : this.jvmModulesPaths) {
            if (!modulesPath.isEmpty()) {
                modulesPath.append(File.pathSeparator);
            }
            modulesPath.append(modulePath);
        }
        if (!modulesAdd.isEmpty()) {
            processArgs.add("--add-modules");
            processArgs.add(modulesAdd.toString());
        }
        if (!modulesPath.isEmpty()) {
            processArgs.add("--module-path");
            processArgs.add(modulesPath.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWriteParams(SocketAddress address) throws IOException {
        try (ServerSocket serverSocket = new ServerSocket();){
            serverSocket.bind(address);
            Boolean[] booleanArray = this.waitWriteParams;
            synchronized (this.waitWriteParams) {
                this.waitWriteParams[0] = true;
                this.waitWriteParams.notifyAll();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                Socket socket = serverSocket.accept();
                try (HOutput output = new HOutput((OutputStream)new CipherOutputStream(socket.getOutputStream(), SecurityHelper.newAESEncryptCipher((byte[])SecurityHelper.fromHex((String)Launcher.getConfig().secretKeyClient))));){
                    byte[] serializedMainParams = IOHelper.encode((String)Launcher.gsonManager.gson.toJson((Object)this.params));
                    output.writeByteArray(serializedMainParams, 0);
                    this.params.clientHDir.write(output);
                    this.params.assetHDir.write(output);
                    if (this.params.javaHDir == null || this.params.javaHDir == this.params.assetHDir) {
                        output.writeBoolean(false);
                    } else {
                        output.writeBoolean(true);
                        this.params.javaHDir.write(output);
                    }
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }
        {
            LauncherEngine.modulesManager.invokeEvent((LauncherModule.Event)new ClientProcessBuilderParamsWrittedEvent(this));
            return;
        }
    }

    public Process getProcess() {
        return this.process;
    }
}

