/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.HttpsURLConnection;
import pro.gravit.launcher.base.Downloader;
import pro.gravit.launcher.base.request.update.LauncherRequest;
import pro.gravit.launcher.core.LauncherInject;
import pro.gravit.launcher.runtime.LauncherEngine;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class LauncherUpdater {
    @LauncherInject(value="launcher.certificatePinning")
    private static boolean isCertificatePinning;

    public static void nothing() {
    }

    private static Path getLauncherPath() {
        Path pathToCore = IOHelper.getCodeSource(IOHelper.class);
        Path pathToApi = IOHelper.getCodeSource(LauncherRequest.class);
        Path pathToSelf = IOHelper.getCodeSource(LauncherUpdater.class);
        if (pathToCore.equals(pathToApi) && pathToCore.equals(pathToSelf)) {
            return pathToCore;
        }
        throw new SecurityException("Found split-jar launcher");
    }

    public static Path prepareUpdate(URL url) throws Exception {
        Path pathToLauncher = LauncherUpdater.getLauncherPath();
        Path tempFile = Files.createTempFile("launcher-update-", ".jar", new FileAttribute[0]);
        URLConnection connection = url.openConnection();
        if (isCertificatePinning) {
            HttpsURLConnection connection1 = (HttpsURLConnection)connection;
            try {
                connection1.setSSLSocketFactory(Downloader.makeSSLSocketFactory());
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IOException(e);
            }
        }
        try (InputStream in = connection.getInputStream();){
            IOHelper.transfer((InputStream)in, (Path)tempFile);
        }
        if (Arrays.equals(SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.MD5, (Path)tempFile), SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.MD5, (Path)pathToLauncher))) {
            throw new IOException("Invalid update (launcher needs update, but link has old launcher), check LaunchServer config...");
        }
        return tempFile;
    }

    public static void restart() {
        ArrayList<String> args = new ArrayList<String>(8);
        args.add(IOHelper.resolveJavaBin(null).toString());
        args.add("-jar");
        args.add(IOHelper.getCodeSource(LauncherUpdater.class).toString());
        ProcessBuilder builder = new ProcessBuilder(args.toArray(new String[0]));
        builder.inheritIO();
        try {
            builder.start();
        }
        catch (IOException e) {
            LogHelper.error((Throwable)e);
        }
        LauncherEngine.forceExit(0);
    }
}

