/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherTrustManager;
import pro.gravit.launcher.client.ClientGsonManager;
import pro.gravit.launcher.client.ClientLauncherEntryPoint;
import pro.gravit.launcher.client.ClientModuleManager;
import pro.gravit.launcher.client.ClientParams;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.events.request.ExitRequestEvent;
import pro.gravit.launcher.events.request.FeaturesRequestEvent;
import pro.gravit.launcher.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.events.request.GetSecureLevelInfoRequestEvent;
import pro.gravit.launcher.events.request.JoinServerRequestEvent;
import pro.gravit.launcher.events.request.LauncherRequestEvent;
import pro.gravit.launcher.events.request.ProfileByUUIDRequestEvent;
import pro.gravit.launcher.events.request.ProfileByUsernameRequestEvent;
import pro.gravit.launcher.events.request.SecurityReportRequestEvent;
import pro.gravit.launcher.events.request.SetProfileRequestEvent;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.LauncherModulesManager;
import pro.gravit.launcher.modules.events.OfflineModeEvent;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.RequestService;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.CheckServerRequest;
import pro.gravit.launcher.request.auth.ExitRequest;
import pro.gravit.launcher.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launcher.request.auth.JoinServerRequest;
import pro.gravit.launcher.request.auth.SetProfileRequest;
import pro.gravit.launcher.request.auth.details.AuthLoginOnlyDetails;
import pro.gravit.launcher.request.management.FeaturesRequest;
import pro.gravit.launcher.request.secure.GetSecureLevelInfoRequest;
import pro.gravit.launcher.request.secure.SecurityReportRequest;
import pro.gravit.launcher.request.update.LauncherRequest;
import pro.gravit.launcher.request.uuid.ProfileByUUIDRequest;
import pro.gravit.launcher.request.uuid.ProfileByUsernameRequest;
import pro.gravit.launcher.request.websockets.OfflineRequestService;
import pro.gravit.launcher.utils.NativeJVMHalt;
import pro.gravit.utils.helper.JVMHelper;

public class ClientLauncherMethods {
    public static void verifyNoAgent() {
        if (JVMHelper.RUNTIME_MXBEAN.getInputArguments().stream().filter(e -> e != null && !e.isEmpty()).anyMatch(e -> e.contains("javaagent"))) {
            throw new SecurityException("JavaAgent found");
        }
    }

    public static X509Certificate[] getCertificates(Class<?> clazz) {
        Object[] signers = clazz.getSigners();
        if (signers == null) {
            return null;
        }
        return (X509Certificate[])Arrays.stream(signers).filter(c -> c instanceof X509Certificate).map(c -> (X509Certificate)c).toArray(X509Certificate[]::new);
    }

    public static void beforeExit(int code) {
        try {
            ClientLauncherEntryPoint.modulesManager.invokeEvent((LauncherModule.Event)new ClientExitPhase(code));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void forceExit(int code) {
        try {
            System.exit(code);
        }
        catch (Throwable e) {
            NativeJVMHalt.haltA(code);
        }
    }

    public static void exitLauncher(int code) {
        ClientLauncherMethods.beforeExit(code);
        ClientLauncherMethods.forceExit(code);
    }

    public static void checkClass(Class<?> clazz) throws SecurityException {
        LauncherTrustManager trustManager = Launcher.getConfig().trustManager;
        if (trustManager == null) {
            return;
        }
        X509Certificate[] certificates = ClientLauncherMethods.getCertificates(clazz);
        if (certificates == null) {
            throw new SecurityException(String.format("Class %s not signed", clazz.getName()));
        }
        try {
            trustManager.checkCertificatesSuccess(certificates, (arg_0, arg_1, arg_2) -> ((LauncherTrustManager)trustManager).stdCertificateChecker(arg_0, arg_1, arg_2));
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static void initGson(ClientModuleManager moduleManager) {
        AuthRequest.registerProviders();
        GetAvailabilityAuthRequest.registerProviders();
        OptionalAction.registerProviders();
        OptionalTrigger.registerProviders();
        Launcher.gsonManager = new ClientGsonManager(moduleManager);
        Launcher.gsonManager.initGson();
    }

    public static RequestService initOffline(LauncherModulesManager modulesManager, ClientParams params) {
        OfflineRequestService service = new OfflineRequestService();
        ClientLauncherMethods.applyBasicOfflineProcessors(service);
        ClientLauncherMethods.applyClientOfflineProcessors(service, params);
        OfflineModeEvent event = new OfflineModeEvent((RequestService)service);
        modulesManager.invokeEvent((LauncherModule.Event)event);
        return event.service;
    }

    public static void applyClientOfflineProcessors(OfflineRequestService service, ClientParams params) {
        service.registerRequestProcessor(ProfileByUsernameRequest.class, r -> {
            if (params.playerProfile.username.equals(r.username)) {
                return new ProfileByUsernameRequestEvent(params.playerProfile);
            }
            throw new RequestException("User not found");
        });
        service.registerRequestProcessor(ProfileByUUIDRequest.class, r -> {
            if (params.playerProfile.uuid.equals(r.uuid)) {
                return new ProfileByUUIDRequestEvent(params.playerProfile);
            }
            throw new RequestException("User not found");
        });
    }

    public static void applyBasicOfflineProcessors(OfflineRequestService service) {
        service.registerRequestProcessor(LauncherRequest.class, r -> new LauncherRequestEvent(false, (String)null));
        service.registerRequestProcessor(CheckServerRequest.class, r -> {
            throw new RequestException("CheckServer disabled in offline mode");
        });
        service.registerRequestProcessor(GetAvailabilityAuthRequest.class, r -> {
            ArrayList<AuthLoginOnlyDetails> details = new ArrayList<AuthLoginOnlyDetails>();
            details.add(new AuthLoginOnlyDetails());
            GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability = new GetAvailabilityAuthRequestEvent.AuthAvailability(details, "offline", "Offline Mode", true, new HashSet());
            ArrayList<GetAvailabilityAuthRequestEvent.AuthAvailability> list = new ArrayList<GetAvailabilityAuthRequestEvent.AuthAvailability>(1);
            list.add(authAvailability);
            return new GetAvailabilityAuthRequestEvent(list);
        });
        service.registerRequestProcessor(JoinServerRequest.class, r -> new JoinServerRequestEvent(false));
        service.registerRequestProcessor(ExitRequest.class, r -> new ExitRequestEvent(ExitRequestEvent.ExitReason.CLIENT));
        service.registerRequestProcessor(SetProfileRequest.class, r -> new SetProfileRequestEvent(null));
        service.registerRequestProcessor(FeaturesRequest.class, r -> new FeaturesRequestEvent());
        service.registerRequestProcessor(GetSecureLevelInfoRequest.class, r -> new GetSecureLevelInfoRequestEvent(null, false));
        service.registerRequestProcessor(SecurityReportRequest.class, r -> new SecurityReportRequestEvent(SecurityReportRequestEvent.ReportAction.NONE));
    }
}

