/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.ClientProfileVersions;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.profiles.optional.actions.OptionalActionClientArgs;
import pro.gravit.launcher.request.Request;
import pro.gravit.utils.Version;

public class ClientParams {
    public String assetDir;
    public String clientDir;
    public String resourcePackDir;
    public String nativesDir;
    public PlayerProfile playerProfile;
    public ClientProfile profile;
    public String accessToken;
    public boolean autoEnter;
    public boolean fullScreen;
    public boolean lwjglGlfwWayland;
    public int ram;
    public int width;
    public int height;
    public Set<OptionalAction> actions = new HashSet<OptionalAction>();
    public UUID session;
    public AuthRequestEvent.OAuthRequestEvent oauth;
    public String authId;
    public long oauthExpiredTime;
    public Map<String, Request.ExtendedToken> extendedTokens;
    public boolean offlineMode;
    public transient HashedDir assetHDir;
    public transient HashedDir clientHDir;
    public transient HashedDir javaHDir;

    public void addClientArgs(Collection<String> args) {
        if (this.profile.getVersion().compareTo(ClientProfileVersions.MINECRAFT_1_6_4) >= 0) {
            this.addModernClientArgs(args);
        } else {
            this.addClientLegacyArgs(args);
        }
    }

    public void addClientLegacyArgs(Collection<String> args) {
        args.add(this.playerProfile.username);
        args.add(this.accessToken);
        Collections.addAll(args, "--version", this.profile.getVersion().toString());
        Collections.addAll(args, "--gameDir", this.clientDir);
        Collections.addAll(args, "--assetsDir", this.assetDir);
    }

    private void addModernClientArgs(Collection<String> args) {
        ClientProfile.Version version = this.profile.getVersion();
        Collections.addAll(args, "--username", this.playerProfile.username);
        if (version.compareTo(ClientProfileVersions.MINECRAFT_1_7_2) >= 0) {
            Collections.addAll(args, "--uuid", Launcher.toHash((UUID)this.playerProfile.uuid));
            Collections.addAll(args, "--accessToken", this.accessToken);
            if (version.compareTo(ClientProfileVersions.MINECRAFT_1_7_10) >= 0) {
                Collections.addAll(args, "--userType", "mojang");
                Collections.addAll(args, "--userProperties", "{}");
                Collections.addAll(args, "--assetIndex", this.profile.getAssetIndex());
            }
        } else {
            Collections.addAll(args, "--session", this.accessToken);
        }
        Collections.addAll(args, "--version", this.profile.getVersion().toString());
        Collections.addAll(args, "--gameDir", this.clientDir);
        Collections.addAll(args, "--assetsDir", this.assetDir);
        Collections.addAll(args, "--resourcePackDir", this.resourcePackDir);
        if (version.compareTo(ClientProfileVersions.MINECRAFT_1_9_4) >= 0) {
            Collections.addAll(args, "--versionType", "Launcher v" + Version.getVersion().getVersionString());
        }
        if (this.autoEnter) {
            if (version.compareTo(ClientProfileVersions.MINECRAFT_1_20) <= 0) {
                Collections.addAll(args, "--server", this.profile.getServerAddress());
                Collections.addAll(args, "--port", Integer.toString(this.profile.getServerPort()));
            } else {
                Collections.addAll(args, "--quickPlayMultiplayer", String.format("%s:%d", this.profile.getServerAddress(), this.profile.getServerPort()));
            }
        }
        for (OptionalAction a : this.actions) {
            if (!(a instanceof OptionalActionClientArgs)) continue;
            args.addAll(((OptionalActionClientArgs)a).args);
        }
        if (this.fullScreen) {
            Collections.addAll(args, "--fullscreen", Boolean.toString(true));
        }
        if (this.width > 0 && this.height > 0) {
            Collections.addAll(args, "--width", Integer.toString(this.width));
            Collections.addAll(args, "--height", Integer.toString(this.height));
        }
    }
}

