/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.CipherInputStream;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launcher.base.api.AuthService;
import pro.gravit.launcher.base.api.ClientService;
import pro.gravit.launcher.base.api.KeyService;
import pro.gravit.launcher.base.events.request.AuthRequestEvent;
import pro.gravit.launcher.base.modules.LauncherModule;
import pro.gravit.launcher.base.modules.LauncherModulesManager;
import pro.gravit.launcher.base.modules.events.PreConfigPhase;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.ClientProfileVersions;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalActionClassPath;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalActionClientArgs;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.RequestException;
import pro.gravit.launcher.base.request.RequestService;
import pro.gravit.launcher.base.request.websockets.StdWebSocketService;
import pro.gravit.launcher.client.BasicLauncherEventHandler;
import pro.gravit.launcher.client.ClientLauncherCoreModule;
import pro.gravit.launcher.client.ClientLauncherMethods;
import pro.gravit.launcher.client.ClientModuleManager;
import pro.gravit.launcher.client.ClientParams;
import pro.gravit.launcher.client.events.ClientProcessClassLoaderEvent;
import pro.gravit.launcher.client.events.ClientProcessInitPhase;
import pro.gravit.launcher.client.events.ClientProcessLaunchEvent;
import pro.gravit.launcher.client.events.ClientProcessPreInvokeMainClassEvent;
import pro.gravit.launcher.client.events.ClientProcessReadyEvent;
import pro.gravit.launcher.client.utils.DirWatcher;
import pro.gravit.launcher.core.hasher.FileNameMatcher;
import pro.gravit.launcher.core.hasher.HashedDir;
import pro.gravit.launcher.core.hasher.HashedEntry;
import pro.gravit.launcher.core.serialize.HInput;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.launch.BasicLaunch;
import pro.gravit.utils.launch.ClassLoaderControl;
import pro.gravit.utils.launch.Launch;
import pro.gravit.utils.launch.LaunchOptions;
import pro.gravit.utils.launch.LegacyLaunch;
import pro.gravit.utils.launch.ModuleLaunch;

public class ClientLauncherEntryPoint {
    public static ClientModuleManager modulesManager;
    public static ClientParams clientParams;
    private static Launch launch;
    private static ClassLoaderControl classLoaderControl;

    private static ClientParams readParams(SocketAddress address) throws IOException {
        try (Socket socket = IOHelper.newSocket();){
            ClientParams clientParams;
            socket.connect(address);
            try (HInput input = new HInput((InputStream)new CipherInputStream(socket.getInputStream(), SecurityHelper.newAESDecryptCipher((byte[])SecurityHelper.fromHex((String)Launcher.getConfig().secretKeyClient))));){
                byte[] serialized = input.readByteArray(0);
                ClientParams params = (ClientParams)Launcher.gsonManager.gson.fromJson(IOHelper.decode((byte[])serialized), ClientParams.class);
                params.clientHDir = new HashedDir(input);
                params.assetHDir = new HashedDir(input);
                boolean isNeedReadJavaDir = input.readBoolean();
                if (isNeedReadJavaDir) {
                    params.javaHDir = new HashedDir(input);
                }
                clientParams = params;
            }
            return clientParams;
        }
    }

    public static void main(String[] args) {
        JVMHelper.verifySystemProperties(ClientLauncherEntryPoint.class, (boolean)true);
        EnvHelper.checkDangerousParams();
        JVMHelper.checkStackTrace(ClientLauncherEntryPoint.class);
        LogHelper.printVersion((String)"Client Launcher");
        ClientLauncherMethods.checkClass(ClientLauncherEntryPoint.class);
        try {
            ClientLauncherEntryPoint.realMain(args);
        }
        catch (Throwable e) {
            LogHelper.error((Throwable)e);
        }
    }

    private static void realMain(String[] args) throws Throwable {
        ClientProfile profile;
        modulesManager = new ClientModuleManager();
        modulesManager.loadModule(new ClientLauncherCoreModule());
        LauncherConfig.initModules((LauncherModulesManager)modulesManager);
        modulesManager.initModules(null);
        ClientLauncherMethods.initGson(modulesManager);
        modulesManager.invokeEvent((LauncherModule.Event)new PreConfigPhase());
        LogHelper.debug((String)"Reading ClientLauncher params");
        ClientParams params = ClientLauncherEntryPoint.readParams(new InetSocketAddress("127.0.0.1", Launcher.getConfig().clientPort));
        ClientLauncherMethods.verifyNoAgent();
        if (params.timestamp > System.currentTimeMillis() || params.timestamp + 30000L < System.currentTimeMillis()) {
            LogHelper.error((String)"Timestamp failed. Exit");
            ClientLauncherMethods.exitLauncher(-662);
            return;
        }
        Launcher.profile = profile = params.profile;
        AuthService.profile = profile;
        clientParams = params;
        if (params.oauth != null) {
            LogHelper.info((String)"Using OAuth");
            if (params.oauthExpiredTime != 0L) {
                Request.setOAuth((String)params.authId, (AuthRequestEvent.OAuthRequestEvent)params.oauth, (long)params.oauthExpiredTime);
            } else {
                Request.setOAuth((String)params.authId, (AuthRequestEvent.OAuthRequestEvent)params.oauth);
            }
            if (params.extendedTokens != null) {
                Request.addAllExtendedToken(params.extendedTokens);
            }
        } else if (params.session != null) {
            throw new UnsupportedOperationException("Legacy session not supported");
        }
        modulesManager.invokeEvent((LauncherModule.Event)new ClientProcessInitPhase(params));
        Path clientDir = Paths.get(params.clientDir, new String[0]);
        Path assetDir = Paths.get(params.assetDir, new String[0]);
        LogHelper.debug((String)"Verifying ClientLauncher sign and classpath");
        HashSet<Path> ignoredPath = new HashSet<Path>();
        List classpath = ClientLauncherEntryPoint.resolveClassPath(ignoredPath, clientDir, params.actions, params.profile).collect(Collectors.toCollection(ArrayList::new));
        if (LogHelper.isDevEnabled()) {
            for (Path e : classpath) {
                LogHelper.dev((String)"Classpath entry %s", (Object[])new Object[]{e});
            }
        }
        List<URL> classpathURLs = classpath.stream().map(IOHelper::toURL).collect(Collectors.toList());
        if (params.offlineMode) {
            service = ClientLauncherMethods.initOffline((LauncherModulesManager)modulesManager, params);
            Request.setRequestService((RequestService)service);
        } else {
            service = (RequestService)StdWebSocketService.initWebSockets((String)Launcher.getConfig().address).get();
            Request.setRequestService((RequestService)service);
            LogHelper.debug((String)"Restore sessions");
            Request.restore((boolean)false, (boolean)false, (boolean)true);
            service.registerEventHandler((RequestService.EventHandler)new BasicLauncherEventHandler());
            ((StdWebSocketService)service).reconnectCallback = () -> {
                LogHelper.debug((String)"WebSocket connect closed. Try reconnect");
                try {
                    Request.reconnect();
                }
                catch (Exception e) {
                    LogHelper.error((Throwable)e);
                    throw new RequestException("Connection failed", (Throwable)e);
                }
            };
        }
        LogHelper.debug((String)"Natives dir %s", (Object[])new Object[]{params.nativesDir});
        ClientProfile.ClassLoaderConfig classLoaderConfig = profile.getClassLoaderConfig();
        LaunchOptions options = new LaunchOptions();
        options.enableHacks = profile.hasFlag(ClientProfile.CompatibilityFlags.ENABLE_HACKS);
        options.moduleConf = profile.getModuleConf();
        ClientService.nativePath = params.nativesDir;
        if (profile.getLoadNatives() != null) {
            for (String e : profile.getLoadNatives()) {
                System.load(Paths.get(params.nativesDir, new String[0]).resolve(ClientService.findLibrary((String)e)).toAbsolutePath().toString());
            }
        }
        if (classLoaderConfig == ClientProfile.ClassLoaderConfig.LAUNCHER || classLoaderConfig == ClientProfile.ClassLoaderConfig.MODULE) {
            launch = JVMHelper.JVM_VERSION <= 11 ? new LegacyLaunch() : new ModuleLaunch();
            classLoaderControl = launch.init(classpath, params.nativesDir, options);
            System.setProperty("java.class.path", classpath.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
            modulesManager.invokeEvent(new ClientProcessClassLoaderEvent(launch, classLoaderControl, profile));
            ClientService.baseURLs = classLoaderControl.getURLs();
        } else if (classLoaderConfig == ClientProfile.ClassLoaderConfig.SYSTEM_ARGS) {
            launch = new BasicLaunch();
            classLoaderControl = launch.init(classpath, params.nativesDir, options);
            ClientService.baseURLs = classpathURLs.toArray(new URL[0]);
        } else {
            throw new UnsupportedOperationException(String.format("Unknown classLoaderConfig %s", classLoaderConfig));
        }
        if (profile.hasFlag(ClientProfile.CompatibilityFlags.CLASS_CONTROL_API)) {
            ClientService.classLoaderControl = classLoaderControl;
        }
        if (params.lwjglGlfwWayland && profile.hasFlag(ClientProfile.CompatibilityFlags.WAYLAND_USE_CUSTOM_GLFW)) {
            String glfwName = ClientService.findLibrary((String)"glfw_wayland");
            System.setProperty("org.lwjgl.glfw.libname", glfwName);
        }
        AuthService.projectName = Launcher.getConfig().projectName;
        AuthService.username = params.playerProfile.username;
        AuthService.uuid = params.playerProfile.uuid;
        KeyService.serverRsaPublicKey = Launcher.getConfig().rsaPublicKey;
        KeyService.serverEcPublicKey = Launcher.getConfig().ecdsaPublicKey;
        modulesManager.invokeEvent((LauncherModule.Event)new ClientProcessReadyEvent(params));
        LogHelper.debug((String)"Starting JVM and client WatchService");
        FileNameMatcher assetMatcher = profile.getAssetUpdateMatcher();
        FileNameMatcher clientMatcher = profile.getClientUpdateMatcher();
        Path javaDir = Paths.get(System.getProperty("java.home"), new String[0]);
        try (DirWatcher assetWatcher = new DirWatcher(assetDir, params.assetHDir, assetMatcher, true);
             DirWatcher clientWatcher = new DirWatcher(clientDir, params.clientHDir, clientMatcher, true);
             DirWatcher javaWatcher = params.javaHDir == null ? null : new DirWatcher(javaDir, params.javaHDir, null, true);){
            CommonHelper.newThread((String)"Asset Directory Watcher", (boolean)true, (Runnable)assetWatcher).start();
            CommonHelper.newThread((String)"Client Directory Watcher", (boolean)true, (Runnable)clientWatcher).start();
            if (javaWatcher != null) {
                CommonHelper.newThread((String)"Java Directory Watcher", (boolean)true, (Runnable)javaWatcher).start();
            }
            ClientLauncherEntryPoint.verifyHDir(assetDir, params.assetHDir, assetMatcher, false, false);
            ClientLauncherEntryPoint.verifyHDir(clientDir, params.clientHDir, clientMatcher, false, true);
            if (javaWatcher != null) {
                ClientLauncherEntryPoint.verifyHDir(javaDir, params.javaHDir, null, false, true);
            }
            modulesManager.invokeEvent(new ClientProcessLaunchEvent(params));
            ClientLauncherEntryPoint.launch(profile, params);
        }
    }

    public static void verifyHDir(Path dir, HashedDir hdir, FileNameMatcher matcher, boolean digest, boolean checkExtra) throws IOException {
        HashedDir currentHDir = new HashedDir(dir, matcher, true, digest);
        HashedDir.Diff diff = hdir.diff(currentHDir, matcher);
        AtomicReference<String> latestPath = new AtomicReference<String>("unknown");
        if (!diff.mismatch.isEmpty() || checkExtra && !diff.extra.isEmpty()) {
            diff.extra.walk((CharSequence)File.separator, (e, k, v) -> {
                if (v.getType().equals((Object)HashedEntry.Type.FILE)) {
                    LogHelper.error((String)"Extra file %s", (Object[])new Object[]{e});
                    latestPath.set(e);
                } else {
                    LogHelper.error((String)"Extra %s", (Object[])new Object[]{e});
                }
                return HashedDir.WalkAction.CONTINUE;
            });
            diff.mismatch.walk((CharSequence)File.separator, (e, k, v) -> {
                if (v.getType().equals((Object)HashedEntry.Type.FILE)) {
                    LogHelper.error((String)"Mismatch file %s", (Object[])new Object[]{e});
                    latestPath.set(e);
                } else {
                    LogHelper.error((String)"Mismatch %s", (Object[])new Object[]{e});
                }
                return HashedDir.WalkAction.CONTINUE;
            });
            throw new SecurityException(String.format("Forbidden modification: '%s' file '%s'", IOHelper.getFileName((Path)dir), latestPath.get()));
        }
    }

    private static LinkedList<Path> resolveClassPathList(Set<Path> ignorePaths, Path clientDir, List<String> classPath) throws IOException {
        return ClientLauncherEntryPoint.resolveClassPathStream(ignorePaths, clientDir, classPath).collect(Collectors.toCollection(LinkedList::new));
    }

    private static Stream<Path> resolveClassPathStream(Set<Path> ignorePaths, Path clientDir, List<String> classPath) throws IOException {
        Stream.Builder<Path> builder = Stream.builder();
        for (String classPathEntry : classPath) {
            Path path = clientDir.resolve(IOHelper.toPath((String)classPathEntry.replace("/", IOHelper.PLATFORM_SEPARATOR)));
            if (IOHelper.isDir((Path)path)) {
                ArrayList<Path> jars = new ArrayList<Path>(32);
                IOHelper.walk((Path)path, (FileVisitor)new ClassPathFileVisitor(jars), (boolean)false);
                Collections.sort(jars);
                for (Path e : jars) {
                    if (ignorePaths.contains(e)) continue;
                    builder.accept(e);
                    ignorePaths.add(e);
                }
                continue;
            }
            if (ignorePaths.contains(path)) continue;
            builder.accept(path);
            ignorePaths.add(path);
        }
        return builder.build();
    }

    public static Stream<Path> resolveClassPath(Set<Path> ignorePaths, Path clientDir, Set<OptionalAction> actions, ClientProfile profile) throws IOException {
        Stream<Path> result = ClientLauncherEntryPoint.resolveClassPathStream(ignorePaths, clientDir, profile.getClassPath());
        for (OptionalAction a : actions) {
            if (!(a instanceof OptionalActionClassPath)) continue;
            result = Stream.concat(result, ClientLauncherEntryPoint.resolveClassPathStream(ignorePaths, clientDir, ((OptionalActionClassPath)a).args));
        }
        return result;
    }

    private static void launch(ClientProfile profile, ClientParams params) throws Throwable {
        LinkedList<String> args = new LinkedList<String>();
        if (profile.getVersion().compareTo(ClientProfileVersions.MINECRAFT_1_6_4) >= 0) {
            params.addClientArgs(args);
        } else {
            params.addClientLegacyArgs(args);
            System.setProperty("minecraft.applet.TargetDirectory", params.clientDir);
        }
        args.addAll(profile.getClientArgs());
        for (OptionalAction action : params.actions) {
            if (!(action instanceof OptionalActionClientArgs)) continue;
            args.addAll(((OptionalActionClientArgs)action).args);
        }
        ArrayList<String> copy = new ArrayList<String>(args);
        int l = copy.size();
        for (int i = 0; i < l; ++i) {
            String s = (String)copy.get(i);
            if (i + 1 >= l || !"--accessToken".equals(s) && !"--session".equals(s)) continue;
            copy.set(i + 1, "censored");
        }
        LogHelper.debug((String)("Args: " + String.valueOf(copy)));
        modulesManager.invokeEvent(new ClientProcessPreInvokeMainClassEvent(params, profile, args));
        try {
            List compatClasses = profile.getCompatClasses();
            for (String e : compatClasses) {
                Class clazz = classLoaderControl.getClass(e);
                MethodHandle runMethod = MethodHandles.lookup().findStatic(clazz, "run", MethodType.methodType(Void.TYPE, ClassLoaderControl.class));
                runMethod.invoke(classLoaderControl);
            }
            Launcher.LAUNCHED.set(true);
            JVMHelper.fullGC();
            launch.launch(params.profile.getMainClass(), params.profile.getMainModule(), args);
            LogHelper.debug((String)"Main exit successful");
        }
        catch (Throwable e) {
            LogHelper.error((Throwable)e);
            throw e;
        }
        finally {
            ClientLauncherMethods.exitLauncher(0);
        }
    }

    private static final class ClassPathFileVisitor
    extends SimpleFileVisitor<Path> {
        private final List<Path> result;

        private ClassPathFileVisitor(List<Path> result) {
            this.result = result;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (IOHelper.hasExtension((Path)file, (String)"jar") || IOHelper.hasExtension((Path)file, (String)"zip")) {
                this.result.add(file);
            }
            return super.visitFile(file, attrs);
        }
    }
}

