/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public final class HTTPRequest {
    private static final int TIMEOUT = 10000;
    private static final JsonParser parser = new JsonParser();

    public static int sendCrashreport(String strurl, byte[] data) throws IOException {
        URL url = new URL(strurl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestProperty("Content-Length", Integer.toString(data.length));
        connection.setRequestProperty("Content-Language", "en-US");
        OutputStream outputStream = connection.getOutputStream();
        outputStream.write(data);
        outputStream.close();
        return connection.getResponseCode();
    }

    public static int sendCrashreport(String strurl, String data) throws IOException {
        return HTTPRequest.sendCrashreport(strurl, data.getBytes(IOHelper.UNICODE_CHARSET));
    }

    public static JsonElement jsonRequest(JsonElement request, URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        connection.setRequestProperty("Accept", "application/json");
        connection.setConnectTimeout(10000);
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), Charset.forName("UTF-8"));
        writer.write(request.toString());
        writer.flush();
        writer.close();
        int statusCode = connection.getResponseCode();
        InputStreamReader reader = 200 <= statusCode && statusCode < 300 ? new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8) : new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8);
        try {
            return parser.parse((Reader)reader);
        }
        catch (Exception e) {
            if (200 > statusCode || statusCode > 300) {
                LogHelper.error("JsonRequest failed. Server response code %d", statusCode);
                throw new IOException(e);
            }
            return null;
        }
    }

    private HTTPRequest() {
    }
}

