/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import pro.gravit.utils.command.BaseCommandCategory;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.CommandCategory;
import pro.gravit.utils.command.CommandException;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.LogHelper;

public abstract class CommandHandler
implements Runnable {
    private final List<Category> categories = new ArrayList<Category>();
    private final CommandCategory baseCategory = new BaseCommandCategory();

    public void eval(String line, boolean bell) {
        LogHelper.info("Command '%s'", line);
        try {
            this.evalNative(line, bell);
        }
        catch (Exception e) {
            LogHelper.error(e);
        }
    }

    public void evalNative(String line, boolean bell) throws Exception {
        String[] args = CommonHelper.parseCommand(line);
        if (args.length > 0) {
            args[0] = args[0].toLowerCase();
        }
        this.eval(args, bell);
    }

    public void eval(String[] args, boolean bell) throws Exception {
        if (args.length == 0) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.lookup(args[0]).invoke(Arrays.copyOfRange(args, 1, args.length));
        long endTime = System.currentTimeMillis();
        if (bell && endTime - startTime >= 5000L) {
            this.bell();
        }
    }

    public Command lookup(String name) throws CommandException {
        Command command = this.findCommand(name);
        if (command == null) {
            throw new CommandException(String.format("Unknown command: '%s'", name));
        }
        return command;
    }

    public Command findCommand(String name) {
        Command cmd = this.baseCategory.findCommand(name);
        if (cmd == null) {
            for (Category entry : this.categories) {
                cmd = entry.category.findCommand(name);
                if (cmd == null) continue;
                return cmd;
            }
        }
        return cmd;
    }

    public abstract String readLine() throws IOException;

    private void readLoop() throws IOException {
        String line = this.readLine();
        while (line != null) {
            this.eval(line, true);
            line = this.readLine();
        }
    }

    public void registerCommand(String name, Command command) {
        this.baseCategory.registerCommand(name, command);
    }

    public void registerCategory(Category category) {
        this.categories.add(category);
    }

    public boolean unregisterCategory(Category category) {
        return this.categories.remove(category);
    }

    public Category findCategory(String name) {
        for (Category category : this.categories) {
            if (!category.name.equals(name)) continue;
            return category;
        }
        return null;
    }

    public Command unregisterCommand(String name) {
        return this.baseCategory.unregisterCommand(name);
    }

    @Override
    public void run() {
        try {
            this.readLoop();
        }
        catch (IOException e) {
            LogHelper.error(e);
        }
    }

    public void walk(CommandWalk callback) {
        for (Category category : this.getCategories()) {
            for (Map.Entry<String, Command> entry : category.category.commandsMap().entrySet()) {
                callback.walk(category, entry.getKey(), entry.getValue());
            }
        }
        for (Map.Entry entry : this.getBaseCategory().commandsMap().entrySet()) {
            callback.walk(null, (String)entry.getKey(), (Command)entry.getValue());
        }
    }

    public CommandCategory getBaseCategory() {
        return this.baseCategory;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public abstract void bell() throws IOException;

    public abstract void clear() throws IOException;

    @FunctionalInterface
    public static interface CommandWalk {
        public void walk(Category var1, String var2, Command var3);
    }

    public static class Category {
        public CommandCategory category;
        public String name;
        public String description;

        public Category(CommandCategory category, String name) {
            this.category = category;
            this.name = name;
        }

        public Category(CommandCategory category, String name, String description) {
            this.category = category;
            this.name = name;
            this.description = description;
        }
    }
}

