/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.fusesource.jansi.AnsiOutputStream;
import pro.gravit.launcher.LauncherAPI;
import pro.gravit.utils.helper.FormatHelper;
import pro.gravit.utils.helper.IOHelper;

public final class LogHelper {
    @LauncherAPI
    public static final String DEBUG_PROPERTY = "launcher.debug";
    @LauncherAPI
    public static final String DEV_PROPERTY = "launcher.dev";
    @LauncherAPI
    public static final String STACKTRACE_PROPERTY = "launcher.stacktrace";
    @LauncherAPI
    public static final String NO_JANSI_PROPERTY = "launcher.noJAnsi";
    @LauncherAPI
    public static final boolean JANSI;
    private static final DateTimeFormatter DATE_TIME_FORMATTER;
    private static final AtomicBoolean DEBUG_ENABLED;
    private static final AtomicBoolean STACKTRACE_ENABLED;
    private static final AtomicBoolean DEV_ENABLED;
    private static final Set<OutputEnity> OUTPUTS;
    private static final Set<Consumer<Throwable>> EXCEPTIONS_CALLBACKS;
    private static final OutputEnity STD_OUTPUT;

    private LogHelper() {
    }

    @LauncherAPI
    public static void addOutput(OutputEnity output) {
        OUTPUTS.add(Objects.requireNonNull(output, "output"));
    }

    @LauncherAPI
    public static void addExcCallback(Consumer<Throwable> output) {
        EXCEPTIONS_CALLBACKS.add(Objects.requireNonNull(output, "output"));
    }

    @LauncherAPI
    public static void addOutput(Output output, OutputTypes type) {
        OUTPUTS.add(new OutputEnity(Objects.requireNonNull(output, "output"), type));
    }

    @LauncherAPI
    public static void addOutput(Path file) throws IOException {
        if (JANSI) {
            LogHelper.addOutput(new JAnsiOutput(IOHelper.newOutput(file, true)), OutputTypes.JANSI);
        } else {
            LogHelper.addOutput(IOHelper.newWriter(file, true));
        }
    }

    @LauncherAPI
    public static void addOutput(Writer writer) {
        LogHelper.addOutput(new WriterOutput(writer), OutputTypes.PLAIN);
    }

    @LauncherAPI
    public static void debug(String message) {
        if (LogHelper.isDebugEnabled()) {
            LogHelper.log(Level.DEBUG, message, false);
        }
    }

    @LauncherAPI
    public static void dev(String message) {
        if (LogHelper.isDevEnabled()) {
            LogHelper.log(Level.DEV, message, false);
        }
    }

    @LauncherAPI
    public static void debug(String format, Object ... args) {
        LogHelper.debug(String.format(format, args));
    }

    @LauncherAPI
    public static void dev(String format, Object ... args) {
        if (LogHelper.isDevEnabled()) {
            LogHelper.dev(String.format(format, args));
        }
    }

    @LauncherAPI
    public static void error(Throwable exc) {
        EXCEPTIONS_CALLBACKS.forEach(e -> e.accept(exc));
        LogHelper.error(LogHelper.isStacktraceEnabled() ? LogHelper.toString(exc) : exc.toString());
    }

    @LauncherAPI
    public static void error(String message) {
        LogHelper.log(Level.ERROR, message, false);
    }

    @LauncherAPI
    public static void error(String format, Object ... args) {
        LogHelper.error(String.format(format, args));
    }

    @LauncherAPI
    public static void info(String message) {
        LogHelper.log(Level.INFO, message, false);
    }

    @LauncherAPI
    public static void info(String format, Object ... args) {
        LogHelper.info(String.format(format, args));
    }

    @LauncherAPI
    public static boolean isDebugEnabled() {
        return DEBUG_ENABLED.get();
    }

    @LauncherAPI
    public static void setDebugEnabled(boolean debugEnabled) {
        DEBUG_ENABLED.set(debugEnabled);
    }

    @LauncherAPI
    public static boolean isStacktraceEnabled() {
        return STACKTRACE_ENABLED.get();
    }

    @LauncherAPI
    public static boolean isDevEnabled() {
        return DEV_ENABLED.get();
    }

    @LauncherAPI
    public static void setStacktraceEnabled(boolean stacktraceEnabled) {
        STACKTRACE_ENABLED.set(stacktraceEnabled);
    }

    @LauncherAPI
    public static void setDevEnabled(boolean stacktraceEnabled) {
        DEV_ENABLED.set(stacktraceEnabled);
    }

    public static String getDataTime() {
        return DATE_TIME_FORMATTER.format(LocalDateTime.now());
    }

    @LauncherAPI
    public static void log(Level level, String message, boolean sub) {
        String dateTime = DATE_TIME_FORMATTER.format(LocalDateTime.now());
        String jansiString = null;
        String plainString = null;
        String htmlString = null;
        for (OutputEnity output : OUTPUTS) {
            if (output.type == OutputTypes.JANSI && JANSI) {
                if (jansiString != null) {
                    output.output.println(jansiString);
                    continue;
                }
                jansiString = LogHelper.ansiFormatLog(level, dateTime, message, sub);
                output.output.println(jansiString);
                continue;
            }
            if (output.type == OutputTypes.HTML) {
                if (htmlString != null) {
                    output.output.println(htmlString);
                    continue;
                }
                htmlString = LogHelper.htmlFormatLog(level, dateTime, message, sub);
                output.output.println(htmlString);
                continue;
            }
            if (plainString != null) {
                output.output.println(plainString);
                continue;
            }
            plainString = LogHelper.formatLog(level, message, dateTime, sub);
            output.output.println(plainString);
        }
    }

    @LauncherAPI
    public static void rawLog(Supplier<String> plainStr, Supplier<String> jansiStr) {
        LogHelper.rawLog(plainStr, jansiStr, null);
    }

    @LauncherAPI
    public static void rawLog(Supplier<String> plainStr, Supplier<String> jansiStr, Supplier<String> htmlStr) {
        String jansiString = null;
        String plainString = null;
        String htmlString = null;
        for (OutputEnity output : OUTPUTS) {
            if (output.type == OutputTypes.JANSI && JANSI) {
                if (jansiString != null) {
                    output.output.println(jansiString);
                    continue;
                }
                jansiString = jansiStr.get();
                output.output.println(jansiString);
                continue;
            }
            if (output.type == OutputTypes.HTML) {
                if (htmlString != null) {
                    output.output.println(htmlString);
                    continue;
                }
                htmlString = htmlStr.get();
                output.output.println(htmlString);
                continue;
            }
            if (plainString != null) {
                output.output.println(plainString);
                continue;
            }
            plainString = plainStr.get();
            output.output.println(plainString);
        }
    }

    @LauncherAPI
    public static void printVersion(String product) {
        String jansiString = null;
        String plainString = null;
        for (OutputEnity output : OUTPUTS) {
            if (output.type == OutputTypes.JANSI && JANSI) {
                if (jansiString != null) {
                    output.output.println(jansiString);
                    continue;
                }
                jansiString = FormatHelper.ansiFormatVersion(product);
                output.output.println(jansiString);
                continue;
            }
            if (plainString != null) {
                output.output.println(plainString);
                continue;
            }
            plainString = FormatHelper.formatVersion(product);
            output.output.println(plainString);
        }
    }

    @LauncherAPI
    public static void printLicense(String product) {
        String jansiString = null;
        String plainString = null;
        for (OutputEnity output : OUTPUTS) {
            if (output.type == OutputTypes.JANSI && JANSI) {
                if (jansiString != null) {
                    output.output.println(jansiString);
                    continue;
                }
                jansiString = FormatHelper.ansiFormatLicense(product);
                output.output.println(jansiString);
                continue;
            }
            if (plainString != null) {
                output.output.println(plainString);
                continue;
            }
            plainString = FormatHelper.formatLicense(product);
            output.output.println(plainString);
        }
    }

    @LauncherAPI
    public static boolean removeOutput(OutputEnity output) {
        return OUTPUTS.remove(output);
    }

    @LauncherAPI
    public static boolean removeStdOutput() {
        return LogHelper.removeOutput(STD_OUTPUT);
    }

    @LauncherAPI
    public static void subDebug(String message) {
        if (LogHelper.isDebugEnabled()) {
            LogHelper.log(Level.DEBUG, message, true);
        }
    }

    @LauncherAPI
    public static void subDebug(String format, Object ... args) {
        LogHelper.subDebug(String.format(format, args));
    }

    @LauncherAPI
    public static void subInfo(String message) {
        LogHelper.log(Level.INFO, message, true);
    }

    @LauncherAPI
    public static void subInfo(String format, Object ... args) {
        LogHelper.subInfo(String.format(format, args));
    }

    @LauncherAPI
    public static void subWarning(String message) {
        LogHelper.log(Level.WARNING, message, true);
    }

    @LauncherAPI
    public static void subWarning(String format, Object ... args) {
        LogHelper.subWarning(String.format(format, args));
    }

    @LauncherAPI
    public static String toString(Throwable exc) {
        StringWriter sw = new StringWriter();
        exc.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    @LauncherAPI
    public static void warning(String message) {
        LogHelper.log(Level.WARNING, message, false);
    }

    @LauncherAPI
    public static void warning(String format, Object ... args) {
        LogHelper.warning(String.format(format, args));
    }

    private static String ansiFormatLog(Level level, String dateTime, String message, boolean sub) {
        Ansi ansi = FormatHelper.rawAnsiFormat(level, dateTime, sub);
        ansi.a(message);
        return ansi.reset().toString();
    }

    public static String htmlFormatLog(Level level, String dateTime, String message, boolean sub) {
        String levelColor;
        switch (level) {
            case WARNING: {
                levelColor = "gravitlauncher-log-warning";
                break;
            }
            case ERROR: {
                levelColor = "gravitlauncher-log-error";
                break;
            }
            case INFO: {
                levelColor = "gravitlauncher-log-info";
                break;
            }
            case DEBUG: {
                levelColor = "gravitlauncher-log-debug";
                break;
            }
            case DEV: {
                levelColor = "gravitlauncher-log-dev";
                break;
            }
            default: {
                levelColor = "gravitlauncher-log-unknown";
            }
        }
        if (sub) {
            levelColor = levelColor + " gravitlauncher-log-sub";
        }
        return String.format("%s <span class=\"gravitlauncher-log %s\">[%s] %s</span>", dateTime, levelColor, level.toString(), sub ? ' ' + message : message);
    }

    private static String formatLog(Level level, String message, String dateTime, boolean sub) {
        return FormatHelper.rawFormat(level, dateTime, sub) + message;
    }

    static {
        boolean jansi;
        DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm:ss", Locale.US);
        DEBUG_ENABLED = new AtomicBoolean(Boolean.getBoolean(DEBUG_PROPERTY));
        STACKTRACE_ENABLED = new AtomicBoolean(Boolean.getBoolean(STACKTRACE_PROPERTY));
        DEV_ENABLED = new AtomicBoolean(Boolean.getBoolean(DEV_PROPERTY));
        OUTPUTS = Collections.newSetFromMap(new ConcurrentHashMap(2));
        EXCEPTIONS_CALLBACKS = Collections.newSetFromMap(new ConcurrentHashMap(2));
        try {
            if (Boolean.getBoolean(NO_JANSI_PROPERTY)) {
                jansi = false;
            } else {
                Class.forName("org.fusesource.jansi.Ansi");
                AnsiConsole.systemInstall();
                jansi = true;
            }
        }
        catch (ClassNotFoundException ignored) {
            jansi = false;
        }
        JANSI = jansi;
        STD_OUTPUT = new OutputEnity(System.out::println, JANSI ? OutputTypes.JANSI : OutputTypes.PLAIN);
        LogHelper.addOutput(STD_OUTPUT);
        String logFile = System.getProperty("launcher.logFile");
        if (logFile != null) {
            try {
                LogHelper.addOutput(IOHelper.toPath(logFile));
            }
            catch (IOException e) {
                LogHelper.error(e);
            }
        }
    }

    private static class WriterOutput
    implements Output,
    AutoCloseable {
        private final Writer writer;

        private WriterOutput(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }

        @Override
        public void println(String message) {
            try {
                this.writer.write(message + System.lineSeparator());
                this.writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static final class JAnsiOutput
    extends WriterOutput {
        private JAnsiOutput(OutputStream output) {
            super(IOHelper.newWriter((OutputStream)new AnsiOutputStream(output)));
        }
    }

    @LauncherAPI
    public static enum Level {
        DEV("DEV"),
        DEBUG("DEBUG"),
        INFO("INFO"),
        WARNING("WARN"),
        ERROR("ERROR");

        public final String name;

        private Level(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    @FunctionalInterface
    @LauncherAPI
    public static interface Output {
        public void println(String var1);
    }

    public static enum OutputTypes {
        PLAIN,
        JANSI,
        HTML;

    }

    public static class OutputEnity {
        public Output output;
        public OutputTypes type;

        public OutputEnity(Output output, OutputTypes type) {
            this.output = output;
            this.type = type;
        }
    }
}

