/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.hasher;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import pro.gravit.launcher.LauncherAPI;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.hasher.HashedEntry;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class HashedFile
extends HashedEntry {
    public static final SecurityHelper.DigestAlgorithm DIGEST_ALGO = SecurityHelper.DigestAlgorithm.MD5;
    @LauncherAPI
    public final long size;
    @LauncherNetworkAPI
    private final byte[] digest;

    @LauncherAPI
    public HashedFile(HInput input) throws IOException {
        this(input.readVarLong(), input.readBoolean() ? input.readByteArray(-HashedFile.DIGEST_ALGO.bytes) : null);
    }

    @LauncherAPI
    public HashedFile(long size, byte[] digest) {
        this.size = VerifyHelper.verifyLong(size, VerifyHelper.L_NOT_NEGATIVE, "Illegal size: " + size);
        this.digest = digest == null ? null : (byte[])DIGEST_ALGO.verify(digest).clone();
    }

    @LauncherAPI
    public HashedFile(Path file, long size, boolean digest) throws IOException {
        this(size, digest ? SecurityHelper.digest(DIGEST_ALGO, file) : null);
    }

    @Override
    public HashedEntry.Type getType() {
        return HashedEntry.Type.FILE;
    }

    @LauncherAPI
    public boolean isSame(HashedFile o) {
        return this.size == o.size && (this.digest == null || o.digest == null || Arrays.equals(this.digest, o.digest));
    }

    @LauncherAPI
    public boolean isSame(Path file, boolean digest) throws IOException {
        if (this.size != IOHelper.readAttributes(file).size()) {
            return false;
        }
        if (!digest || this.digest == null) {
            return true;
        }
        byte[] actualDigest = SecurityHelper.digest(DIGEST_ALGO, file);
        return Arrays.equals(this.digest, actualDigest);
    }

    @LauncherAPI
    public boolean isSameDigest(byte[] digest) {
        return this.digest == null || digest == null || Arrays.equals(this.digest, digest);
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void write(HOutput output) throws IOException {
        output.writeVarLong(this.size);
        output.writeBoolean(this.digest != null);
        if (this.digest != null) {
            output.writeByteArray(this.digest, -HashedFile.DIGEST_ALGO.bytes);
        }
    }
}

