/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.command;

import java.io.IOException;
import java.util.List;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.InfoCmp;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.CommandHandler;

public class JLineCommandHandler
extends CommandHandler {
    private final Terminal terminal;
    private final TerminalBuilder terminalBuilder = TerminalBuilder.builder();
    private final Completer completer;
    private final LineReader reader;

    public JLineCommandHandler() throws IOException {
        this.terminal = this.terminalBuilder.build();
        this.completer = new JLineConsoleCompleter();
        this.reader = LineReaderBuilder.builder().terminal(this.terminal).completer(this.completer).build();
    }

    @Override
    public void bell() throws IOException {
        this.terminal.puts(InfoCmp.Capability.bell, new Object[0]);
    }

    @Override
    public void clear() throws IOException {
        this.terminal.puts(InfoCmp.Capability.clear_screen, new Object[0]);
    }

    @Override
    public String readLine() throws IOException {
        try {
            return this.reader.readLine();
        }
        catch (UserInterruptException e) {
            System.exit(0);
            return null;
        }
    }

    public class JLineConsoleCompleter
    implements Completer {
        public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            String completeWord = line.word();
            if (line.wordIndex() == 0) {
                JLineCommandHandler.this.walk((category, name, command) -> {
                    if (name.startsWith(completeWord)) {
                        candidates.add(command.buildCandidate(category, name));
                    }
                });
            } else {
                Command target = JLineCommandHandler.this.findCommand((String)line.words().get(0));
                List words = line.words();
                List<Candidate> candidates1 = target.complete(words.subList(1, words.size()), line.wordIndex() - 1, completeWord);
                candidates.addAll(candidates1);
            }
        }
    }
}

