/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.hasher;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.hasher.HashedEntry;
import pro.gravit.launcher.hasher.HashedFile;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.launcher.serialize.stream.EnumSerializer;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class HashedDir
extends HashedEntry {
    @LauncherNetworkAPI
    private final Map<String, HashedEntry> map = new HashMap<String, HashedEntry>(32);

    public HashedDir() {
    }

    public HashedDir(HInput input) throws IOException {
        int entriesCount = input.readLength(0);
        for (int i = 0; i < entriesCount; ++i) {
            HashedEntry entry;
            String name = IOHelper.verifyFileName(input.readString(255));
            HashedEntry.Type type = HashedEntry.Type.read(input);
            switch (type) {
                case FILE: {
                    entry = new HashedFile(input);
                    break;
                }
                case DIR: {
                    entry = new HashedDir(input);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unsupported hashed entry type: " + type.name()));
                }
            }
            VerifyHelper.putIfAbsent(this.map, name, entry, String.format("Duplicate dir entry: '%s'", name));
        }
    }

    public HashedDir(Path dir, FileNameMatcher matcher, boolean allowSymlinks, boolean digest) throws IOException {
        IOHelper.walk(dir, new HashFileVisitor(dir, matcher, allowSymlinks, digest), true);
    }

    public Diff diff(HashedDir other, FileNameMatcher matcher) {
        HashedDir mismatch = this.sideDiff(other, matcher, new LinkedList<String>(), true);
        HashedDir extra = other.sideDiff(this, matcher, new LinkedList<String>(), false);
        return new Diff(mismatch, extra);
    }

    public Diff compare(HashedDir other, FileNameMatcher matcher) {
        HashedDir mismatch = this.sideDiff(other, matcher, new LinkedList<String>(), true);
        HashedDir extra = other.sideDiff(this, matcher, new LinkedList<String>(), false);
        return new Diff(mismatch, extra);
    }

    public void remove(String name) {
        this.map.remove(name);
    }

    public void removeR(String name) {
        LinkedList<String> dirs = new LinkedList<String>();
        StringTokenizer t = new StringTokenizer(name, "/");
        while (t.hasMoreTokens()) {
            dirs.add(t.nextToken());
        }
        Map<String, HashedEntry> current = this.map;
        for (String s : dirs) {
            HashedEntry e = current.get(s);
            if (e == null) {
                if (LogHelper.isDebugEnabled()) {
                    LogHelper.debug("Null %s", s);
                }
                if (!LogHelper.isDebugEnabled()) break;
                for (String x : current.keySet()) {
                    LogHelper.debug("Contains %s", x);
                }
                break;
            }
            if (e.getType() == HashedEntry.Type.DIR) {
                current = ((HashedDir)e).map;
                if (!LogHelper.isDebugEnabled()) continue;
                LogHelper.debug("Found dir %s", s);
                continue;
            }
            current.remove(s);
            if (!LogHelper.isDebugEnabled()) break;
            LogHelper.debug("Found filename %s", s);
            break;
        }
    }

    public HashedEntry getEntry(String name) {
        return this.map.get(name);
    }

    @Override
    public HashedEntry.Type getType() {
        return HashedEntry.Type.DIR;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Map<String, HashedEntry> map() {
        return Collections.unmodifiableMap(this.map);
    }

    public HashedEntry resolve(Iterable<String> path) {
        HashedEntry current = this;
        for (String pathEntry : path) {
            if (current instanceof HashedDir) {
                current = current.map.get(pathEntry);
                continue;
            }
            return null;
        }
        return current;
    }

    private HashedDir sideDiff(HashedDir other, FileNameMatcher matcher, Deque<String> path, boolean mismatchList) {
        HashedDir diff = new HashedDir();
        for (Map.Entry<String, HashedEntry> mapEntry : this.map.entrySet()) {
            String name = mapEntry.getKey();
            HashedEntry entry = mapEntry.getValue();
            path.add(name);
            boolean shouldUpdate = matcher == null || matcher.shouldUpdate(path);
            HashedEntry.Type type = entry.getType();
            HashedEntry otherEntry = other.map.get(name);
            if (otherEntry == null || otherEntry.getType() != type) {
                if (shouldUpdate || mismatchList && otherEntry == null) {
                    diff.map.put(name, entry);
                    if (!mismatchList) {
                        entry.flag = true;
                    }
                }
                path.removeLast();
                continue;
            }
            switch (type) {
                case FILE: {
                    HashedFile file = (HashedFile)entry;
                    HashedFile otherFile = (HashedFile)otherEntry;
                    if (!mismatchList || !shouldUpdate || file.isSame(otherFile)) break;
                    diff.map.put(name, entry);
                    break;
                }
                case DIR: {
                    HashedDir mismatch;
                    HashedDir dir = (HashedDir)entry;
                    HashedDir otherDir = (HashedDir)otherEntry;
                    if (!mismatchList && !shouldUpdate || (mismatch = dir.sideDiff(otherDir, matcher, path, mismatchList)).isEmpty()) break;
                    diff.map.put(name, mismatch);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unsupported hashed entry type: " + type.name()));
                }
            }
            path.removeLast();
        }
        return diff;
    }

    public HashedDir sideCompare(HashedDir other, FileNameMatcher matcher, Deque<String> path, boolean mismatchList) {
        HashedDir diff = new HashedDir();
        for (Map.Entry<String, HashedEntry> mapEntry : this.map.entrySet()) {
            String name = mapEntry.getKey();
            HashedEntry entry = mapEntry.getValue();
            path.add(name);
            boolean shouldUpdate = matcher == null || matcher.shouldUpdate(path);
            HashedEntry.Type type = entry.getType();
            HashedEntry otherEntry = other.map.get(name);
            if (otherEntry == null || otherEntry.getType() != type) {
                if (shouldUpdate || mismatchList && otherEntry == null) {
                    diff.map.put(name, entry);
                    if (!mismatchList) {
                        entry.flag = true;
                    }
                }
                path.removeLast();
                continue;
            }
            switch (type) {
                case FILE: {
                    HashedFile file = (HashedFile)entry;
                    HashedFile otherFile = (HashedFile)otherEntry;
                    if (!mismatchList || !shouldUpdate || !file.isSame(otherFile)) break;
                    diff.map.put(name, entry);
                    break;
                }
                case DIR: {
                    HashedDir mismatch;
                    HashedDir dir = (HashedDir)entry;
                    HashedDir otherDir = (HashedDir)otherEntry;
                    if (!mismatchList && !shouldUpdate || (mismatch = dir.sideCompare(otherDir, matcher, path, mismatchList)).isEmpty()) break;
                    diff.map.put(name, mismatch);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unsupported hashed entry type: " + type.name()));
                }
            }
            path.removeLast();
        }
        return diff;
    }

    @Override
    public long size() {
        return this.map.values().stream().mapToLong(HashedEntry::size).sum();
    }

    @Override
    public void write(HOutput output) throws IOException {
        Set<Map.Entry<String, HashedEntry>> entries = this.map.entrySet();
        output.writeLength(entries.size(), 0);
        for (Map.Entry<String, HashedEntry> mapEntry : entries) {
            output.writeString(mapEntry.getKey(), 255);
            HashedEntry entry = mapEntry.getValue();
            EnumSerializer.write(output, entry.getType());
            entry.write(output);
        }
    }

    public void walk(CharSequence separator, WalkCallback callback) throws IOException {
        String append = "";
        this.walk(append, separator, callback, true);
    }

    private WalkAction walk(String append, CharSequence separator, WalkCallback callback, boolean noSeparator) throws IOException {
        for (Map.Entry<String, HashedEntry> entry : this.map.entrySet()) {
            HashedEntry e = entry.getValue();
            if (e.getType() == HashedEntry.Type.FILE) {
                WalkAction a;
                if (!(noSeparator ? (a = callback.walked(append + entry.getKey(), entry.getKey(), e)) == WalkAction.STOP : (a = callback.walked(append + separator + entry.getKey(), entry.getKey(), e)) == WalkAction.STOP)) continue;
                return a;
            }
            String newAppend = noSeparator ? append + entry.getKey() : append + separator + entry.getKey();
            WalkAction a = callback.walked(newAppend, entry.getKey(), e);
            if (a == WalkAction.STOP) {
                return a;
            }
            a = ((HashedDir)e).walk(newAppend, separator, callback, false);
            if (a != WalkAction.STOP) continue;
            return a;
        }
        return WalkAction.CONTINUE;
    }

    @FunctionalInterface
    public static interface WalkCallback {
        public WalkAction walked(String var1, String var2, HashedEntry var3) throws IOException;
    }

    public static enum WalkAction {
        STOP,
        CONTINUE;

    }

    private final class HashFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path dir;
        private final FileNameMatcher matcher;
        private final boolean allowSymlinks;
        private final boolean digest;
        private HashedDir current;
        private final Deque<String> path;
        private final Deque<HashedDir> stack;

        private HashFileVisitor(Path dir, FileNameMatcher matcher, boolean allowSymlinks, boolean digest) {
            this.current = HashedDir.this;
            this.path = new LinkedList<String>();
            this.stack = new LinkedList<HashedDir>();
            this.dir = dir;
            this.matcher = matcher;
            this.allowSymlinks = allowSymlinks;
            this.digest = digest;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            FileVisitResult result = super.postVisitDirectory(dir, exc);
            if (this.dir.equals(dir)) {
                return result;
            }
            HashedDir parent = this.stack.removeLast();
            parent.map.put(this.path.removeLast(), this.current);
            this.current = parent;
            return result;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            FileVisitResult result = super.preVisitDirectory(dir, attrs);
            if (this.dir.equals(dir)) {
                return result;
            }
            if (!this.allowSymlinks && attrs.isSymbolicLink()) {
                throw new SecurityException("Symlinks are not allowed");
            }
            this.stack.add(this.current);
            this.current = new HashedDir();
            this.path.add(IOHelper.getFileName(dir));
            return result;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (!this.allowSymlinks && attrs.isSymbolicLink()) {
                throw new SecurityException("Symlinks are not allowed");
            }
            this.path.add(IOHelper.getFileName(file));
            boolean doDigest = this.digest && (this.matcher == null || this.matcher.shouldUpdate(this.path));
            this.current.map.put(this.path.removeLast(), new HashedFile(file, attrs.size(), doDigest));
            return super.visitFile(file, attrs);
        }
    }

    public static final class Diff {
        public final HashedDir mismatch;
        public final HashedDir extra;

        private Diff(HashedDir mismatch, HashedDir extra) {
            this.mismatch = mismatch;
            this.extra = extra;
        }

        public boolean isSame() {
            return this.mismatch.isEmpty() && this.extra.isEmpty();
        }
    }
}

